/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.lowlevel.query.impl.Queries;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.search.common.NamedValues;
import org.hibernate.search.engine.search.query.spi.QueryParameters;

public class PredicateRequestContext {
    private final BackendSessionContext sessionContext;
    private final ElasticsearchSearchIndexScope<?> searchIndexScope;
    private final Set<String> routingKeys;
    private final QueryParameters parameters;
    private final String nestedPath;

    public PredicateRequestContext(BackendSessionContext sessionContext, ElasticsearchSearchIndexScope<?> searchIndexScope, Set<String> routingKeys, QueryParameters parameters) {
        this(sessionContext, searchIndexScope, routingKeys, parameters, null);
    }

    private PredicateRequestContext(BackendSessionContext sessionContext, ElasticsearchSearchIndexScope<?> searchIndexScope, Set<String> routingKeys, QueryParameters parameters, String nestedPath) {
        this.sessionContext = sessionContext;
        this.searchIndexScope = searchIndexScope;
        this.routingKeys = routingKeys;
        this.parameters = parameters;
        this.nestedPath = nestedPath;
    }

    public String getNestedPath() {
        return this.nestedPath;
    }

    String getTenantId() {
        return this.sessionContext.tenantIdentifier();
    }

    public JsonArray tenantAndRoutingFilters() {
        JsonArray filters = new JsonArray();
        JsonObject filter = this.searchIndexScope.filterOrNull(this.sessionContext.tenantIdentifier());
        if (filter != null) {
            filters.add((JsonElement)filter);
        }
        if (!this.routingKeys.isEmpty()) {
            filters.add((JsonElement)Queries.anyTerm("_routing", this.routingKeys));
        }
        return filters;
    }

    public PredicateRequestContext withNestedPath(String path) {
        return new PredicateRequestContext(this.sessionContext, this.searchIndexScope, this.routingKeys, this.parameters, path);
    }

    public NamedValues queryParameters() {
        return this.parameters;
    }
}

