/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public abstract class AbstractWriteAttributeHandler<T>
implements OperationStepHandler {
    private static final ParametersValidator NAME_VALIDATOR = new ParametersValidator();
    private final Map<String, AttributeDefinition> attributeDefinitions;

    protected AbstractWriteAttributeHandler() {
        this.attributeDefinitions = Map.of();
    }

    @Deprecated(forRemoval=true)
    protected AbstractWriteAttributeHandler(AttributeDefinition ... definitions) {
        this(Arrays.asList(definitions));
    }

    @Deprecated(forRemoval=true)
    protected AbstractWriteAttributeHandler(Collection<AttributeDefinition> definitions) {
        if (definitions.isEmpty()) {
            this.attributeDefinitions = Collections.emptyMap();
        } else if (definitions.size() == 1) {
            AttributeDefinition definition = definitions.iterator().next();
            this.attributeDefinitions = Collections.singletonMap(definition.getName(), definition);
        } else {
            HashMap<String, AttributeDefinition> attributes = new HashMap<String, AttributeDefinition>(definitions.size());
            for (AttributeDefinition definition : definitions) {
                attributes.put(definition.getName(), definition);
            }
            this.attributeDefinitions = Collections.unmodifiableMap(attributes);
        }
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        NAME_VALIDATOR.validate(operation);
        final String attributeName = operation.require("name").asString();
        ModelNode attributeValue = operation.hasDefined("value") ? operation.get("value") : new ModelNode();
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        final ModelNode submodel = resource.getModel();
        final ModelNode currentValue = submodel.get(attributeName).clone();
        AttributeAccess attributeAccess = context.getResourceRegistration().getAttributeAccess(PathAddress.EMPTY_ADDRESS, attributeName);
        if (attributeAccess == null) {
            throw new OperationFailedException(ControllerLogger.MGMT_OP_LOGGER.unknownAttribute(attributeName));
        }
        if (!attributeAccess.getAccessType().isWritable()) {
            throw new OperationFailedException(ControllerLogger.MGMT_OP_LOGGER.attributeNotWritable(attributeName));
        }
        final AttributeDefinition attributeDefinition = attributeAccess.getAttributeDefinition();
        final ModelNode defaultValue = attributeDefinition.getDefaultValue();
        ModelNode syntheticOp = new ModelNode();
        syntheticOp.get(attributeName).set(attributeValue);
        attributeDefinition.validateAndSet(syntheticOp, submodel);
        ModelNode newValue = submodel.get(attributeName);
        this.recordCapabilitiesAndRequirements(context, attributeDefinition, newValue, currentValue);
        this.finishModelStage(context, operation, attributeName, newValue, currentValue, resource);
        if (this.requiresRuntime(context)) {
            context.addStep(operation, new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    HandbackHolder handback;
                    final ModelNode resolvedValue = attributeDefinition.resolveModelAttribute(context, submodel);
                    final boolean reloadRequired = AbstractWriteAttributeHandler.this.applyUpdateToRuntime(context, operation, attributeName, resolvedValue, currentValue, handback = new HandbackHolder());
                    if (reloadRequired) {
                        if (attributeDefinition.getFlags().contains(AttributeAccess.Flag.RESTART_JVM)) {
                            context.restartRequired();
                        } else {
                            context.reloadRequired();
                        }
                    }
                    context.completeStep(new OperationContext.RollbackHandler(){

                        @Override
                        public void handleRollback(OperationContext context, ModelNode operation) {
                            try {
                                ModelNode valueToRestore = context.resolveExpressions(currentValue);
                                if (!valueToRestore.isDefined() && defaultValue != null) {
                                    valueToRestore = defaultValue;
                                }
                                AbstractWriteAttributeHandler.this.revertUpdateToRuntime(context, operation, attributeName, valueToRestore, resolvedValue, handback.handback);
                            }
                            catch (Exception e) {
                                ControllerLogger.MGMT_OP_LOGGER.errorRevertingOperation(e, this.getClass().getSimpleName(), operation.require("operation").asString(), context.getCurrentAddress());
                            }
                            if (reloadRequired) {
                                if (attributeDefinition.getFlags().contains(AttributeAccess.Flag.RESTART_JVM)) {
                                    context.revertRestartRequired();
                                } else {
                                    context.revertReloadRequired();
                                }
                            }
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    protected abstract boolean applyUpdateToRuntime(OperationContext var1, ModelNode var2, String var3, ModelNode var4, ModelNode var5, HandbackHolder<T> var6) throws OperationFailedException;

    protected abstract void revertUpdateToRuntime(OperationContext var1, ModelNode var2, String var3, ModelNode var4, ModelNode var5, T var6) throws OperationFailedException;

    protected void recordCapabilitiesAndRequirements(OperationContext context, AttributeDefinition attributeDefinition, ModelNode newValue, ModelNode oldValue) {
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        attributeDefinition.removeCapabilityRequirements(context, resource, oldValue);
        attributeDefinition.addCapabilityRequirements(context, resource, newValue);
    }

    protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource model) throws OperationFailedException {
        this.validateUpdatedModel(context, model);
    }

    protected void validateUpdatedModel(OperationContext context, Resource model) throws OperationFailedException {
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.isDefaultRequiresRuntime() && !context.isBooting();
    }

    @Deprecated(forRemoval=true)
    protected AttributeDefinition getAttributeDefinition(String attributeName) {
        AttributeDefinition response = this.attributeDefinitions.get(attributeName);
        if (response == null) {
            throw ControllerLogger.MGMT_OP_LOGGER.invalidAttributeDefinition(attributeName);
        }
        return response;
    }

    public static class HandbackHolder<T> {
        private T handback;

        public void setHandback(T handback) {
            this.handback = handback;
        }
    }
}

