/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ConfigurationChangesCollector;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.Service;

public class LegacyConfigurationChangeResourceDefinition
extends SimpleResourceDefinition {
    public static final SimpleAttributeDefinition MAX_HISTORY = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"max-history", (ModelType)ModelType.INT, (boolean)true).setDefaultValue(new ModelNode(10))).build();
    public static final PathElement PATH = PathElement.pathElement((String)"service", (String)"configuration-changes");
    public static final String OPERATION_NAME = "list-changes";
    static final String CONFIGURATION_CHANGES_CAPABILITY_NAME = "org.wildfly.management.configuration.changes";
    public static final RuntimeCapability<Void> CONFIGURATION_CHANGES_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.management.configuration.changes", (boolean)false, Void.class).build();
    public static final LegacyConfigurationChangeResourceDefinition INSTANCE = new LegacyConfigurationChangeResourceDefinition();

    static ResourceDefinition forDomain() {
        return new SimpleResourceDefinition(new SimpleResourceDefinition.Parameters(PATH, DomainManagementResolver.getResolver("core", "management", "service", "configuration-changes")).setAddHandler(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                String warning = DomainManagementLogger.ROOT_LOGGER.removedBrokenResource(context.getCurrentAddress().toCLIStyleString());
                DomainManagementLogger.ROOT_LOGGER.warn(warning);
                context.getResult().add(warning);
            }
        }).setDeprecatedSince(ModelVersion.create((int)4, (int)2)));
    }

    private LegacyConfigurationChangeResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(PATH, DomainManagementResolver.getResolver("core", "management", "service", "configuration-changes")).addCapabilities(new RuntimeCapability[]{CONFIGURATION_CHANGES_CAPABILITY}).setAddHandler((OperationStepHandler)new LegacyConfigurationChangeResourceAddHandler()).setRemoveHandler((OperationStepHandler)new LegacyConfigurationChangeResourceRemoveHandler()));
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler(LegacyConfigurationChangesHandler.DEFINITION, (OperationStepHandler)LegacyConfigurationChangesHandler.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)MAX_HISTORY, null, (OperationStepHandler)new LegacyMaxHistoryWriteHandler((ConfigurationChangesCollector)ConfigurationChangesCollector.INSTANCE));
    }

    private static class LegacyConfigurationChangeResourceAddHandler
    extends AbstractAddStepHandler {
        private LegacyConfigurationChangeResourceAddHandler() {
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ModelNode maxHistory = MAX_HISTORY.resolveModelAttribute(context, model);
            context.getServiceTarget().addService(CONFIGURATION_CHANGES_CAPABILITY.getCapabilityServiceName()).setInstance(Service.NULL).install();
            ConfigurationChangesCollector.INSTANCE.setMaxHistory(maxHistory.asInt());
        }

        protected boolean requiresRuntime(OperationContext context) {
            return context.getProcessType() != ProcessType.EMBEDDED_HOST_CONTROLLER && context.getProcessType() != ProcessType.EMBEDDED_SERVER && context.getRunningMode() != RunningMode.ADMIN_ONLY;
        }
    }

    private static class LegacyConfigurationChangeResourceRemoveHandler
    extends AbstractRemoveStepHandler {
        private LegacyConfigurationChangeResourceRemoveHandler() {
        }

        protected boolean requiresRuntime(OperationContext context) {
            return context.getProcessType() != ProcessType.EMBEDDED_HOST_CONTROLLER && context.getProcessType() != ProcessType.EMBEDDED_SERVER && context.getRunningMode() != RunningMode.ADMIN_ONLY;
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.performRuntime(context, operation, model);
            ConfigurationChangesCollector.INSTANCE.deactivate();
            context.removeService(CONFIGURATION_CHANGES_CAPABILITY.getCapabilityServiceName());
        }
    }

    private static class LegacyConfigurationChangesHandler
    extends AbstractRuntimeOnlyHandler {
        private static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("list-changes", DomainManagementResolver.getResolver("core", "management", "service", "configuration-changes")).setReplyType(ModelType.STRING).setRuntimeOnly().build();
        private static final LegacyConfigurationChangesHandler INSTANCE = new LegacyConfigurationChangesHandler((ConfigurationChangesCollector)ConfigurationChangesCollector.INSTANCE);
        private static final Set<Action.ActionEffect> ADDRESS_EFFECT = EnumSet.of(Action.ActionEffect.ADDRESS);
        private static final Set<Action.ActionEffect> READ_EFFECT = EnumSet.of(Action.ActionEffect.READ_CONFIG, Action.ActionEffect.READ_RUNTIME);
        private final ConfigurationChangesCollector collector;

        private LegacyConfigurationChangesHandler(ConfigurationChangesCollector collector) {
            this.collector = collector;
        }

        protected boolean requiresRuntime(OperationContext context) {
            return true;
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (this.collector != null) {
                ModelNode result = context.getResult().setEmptyList();
                for (ModelNode change : this.collector.getChanges()) {
                    ModelNode configurationChange = change.clone();
                    this.secureHistory(context, configurationChange);
                    result.add(configurationChange);
                }
            }
        }

        private void secureHistory(OperationContext context, ModelNode configurationChange) throws OperationFailedException {
            if (configurationChange.has("operations")) {
                List operations = configurationChange.get("operations").asList();
                ModelNode authorizedOperations = configurationChange.get("operations").setEmptyList();
                for (ModelNode operation : operations) {
                    authorizedOperations.add(this.secureOperation(context, operation));
                }
            }
        }

        private ModelNode secureOperation(OperationContext context, ModelNode operation) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            for (int i = 0; i < address.size(); ++i) {
                if (this.isAccessPermitted(context, address.subAddress(0, i).toModelNode())) continue;
                return this.accessDenied(operation);
            }
            ModelNode fakeOperation = new ModelNode();
            fakeOperation.get("operation").set("read-resource");
            fakeOperation.get("address").set(address.toModelNode());
            AuthorizationResult authResult = context.authorize(fakeOperation, ADDRESS_EFFECT);
            if (authResult.getDecision() == AuthorizationResult.Decision.PERMIT) {
                return this.secureOperationParameters(context, operation);
            }
            return this.accessDenied(operation);
        }

        private ModelNode accessDenied(ModelNode operation) {
            ModelNode securedOperation = new ModelNode();
            securedOperation.get("operation").set(operation.get("operation"));
            securedOperation.get("address").set(ControllerLogger.MGMT_OP_LOGGER.permissionDenied());
            return securedOperation;
        }

        private boolean isAccessPermitted(OperationContext context, ModelNode address) {
            ModelNode fakeOperation = new ModelNode();
            fakeOperation.get("operation").set("read-resource");
            fakeOperation.get("address").set(address);
            AuthorizationResult authResult = context.authorize(fakeOperation, READ_EFFECT);
            return authResult.getDecision() == AuthorizationResult.Decision.PERMIT;
        }

        private ModelNode secureOperationParameters(OperationContext context, ModelNode op) throws OperationFailedException {
            OperationEntry operationEntry;
            Set<Action.ActionEffect> effects;
            ModelNode operation = op.clone();
            if (context.authorize(operation, effects = this.getEffects(operationEntry = context.getRootResourceRegistration().getOperationEntry(PathAddress.pathAddress((ModelNode)operation.get("address")), operation.get("operation").asString()))).getDecision() == AuthorizationResult.Decision.PERMIT) {
                return operation;
            }
            ModelNode securedOperation = new ModelNode();
            securedOperation.get("operation").set(operation.get("operation"));
            securedOperation.get("address").set(operation.get("address"));
            return securedOperation;
        }

        private Set<Action.ActionEffect> getEffects(OperationEntry operationEntry) {
            HashSet<Action.ActionEffect> effects = new HashSet<Action.ActionEffect>(5);
            effects.add(Action.ActionEffect.ADDRESS);
            if (operationEntry != null) {
                effects.add(Action.ActionEffect.READ_RUNTIME);
                if (!operationEntry.getFlags().contains(OperationEntry.Flag.RUNTIME_ONLY)) {
                    effects.add(Action.ActionEffect.READ_CONFIG);
                }
                if (!operationEntry.getFlags().contains(OperationEntry.Flag.READ_ONLY)) {
                    effects.add(Action.ActionEffect.WRITE_RUNTIME);
                    if (!operationEntry.getFlags().contains(OperationEntry.Flag.RUNTIME_ONLY)) {
                        effects.add(Action.ActionEffect.WRITE_CONFIG);
                    }
                }
            }
            return effects;
        }
    }

    private static class LegacyMaxHistoryWriteHandler
    extends AbstractWriteAttributeHandler<Integer> {
        private final ConfigurationChangesCollector collector;

        private LegacyMaxHistoryWriteHandler(ConfigurationChangesCollector collector) {
            this.collector = collector;
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Integer> handbackHolder) throws OperationFailedException {
            this.collector.setMaxHistory(resolvedValue.asInt());
            return false;
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Integer handback) throws OperationFailedException {
            this.collector.setMaxHistory(valueToRestore.asInt());
        }
    }
}

