/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.security.manager;

import java.security.Permission;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.security.LoadedPermissionFactory;
import org.jboss.modules.security.ModularPermissionFactory;
import org.jboss.modules.security.PermissionFactory;
import org.wildfly.common.Assert;
import org.wildfly.extension.security.manager.logging.SecurityManagerLogger;
import org.wildfly.security.manager.WildFlySecurityManager;

public class DeferredPermissionFactory
implements PermissionFactory {
    private final Type type;
    private final ModuleLoader moduleLoader;
    private final String moduleName;
    private final String permissionClass;
    private final String permissionName;
    private final String permissionActions;
    private volatile PermissionFactory factory;

    public DeferredPermissionFactory(Type type, ModuleLoader moduleLoader, String moduleName, String permissionClass, String permissionName, String permissionActions) {
        this.type = (Type)((Object)Assert.checkNotNullParam((String)"type", (Object)((Object)type)));
        this.moduleLoader = (ModuleLoader)Assert.checkNotNullParam((String)"moduleLoader", (Object)moduleLoader);
        this.moduleName = moduleName;
        this.permissionClass = (String)Assert.checkNotNullParam((String)"permissionClass", (Object)permissionClass);
        this.permissionName = permissionName;
        this.permissionActions = permissionActions;
        this.factory = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PermissionFactory getFactory() {
        Object local = this.factory;
        if (local != null) {
            return local;
        }
        DeferredPermissionFactory deferredPermissionFactory = this;
        synchronized (deferredPermissionFactory) {
            local = this.factory;
            if (local == null) {
                local = this.moduleName == null ? new LoadedPermissionFactory(WildFlySecurityManager.getClassLoaderPrivileged(this.getClass()), this.permissionClass, this.permissionName, this.permissionActions) : new ModularPermissionFactory(this.moduleLoader, this.moduleName, this.permissionClass, this.permissionName, this.permissionActions);
            }
            this.factory = local;
            return local;
        }
    }

    public Permission construct() {
        Permission result = this.getFactory().construct();
        if (result == null) {
            SecurityManagerLogger.ROOT_LOGGER.ignoredPermission(this.type.name().replace("_", "-").toLowerCase(), this.permissionClass, this.permissionName == null ? "" : this.permissionName, this.permissionActions == null ? "" : this.permissionActions);
        }
        return result;
    }

    public static enum Type {
        DEPLOYMENT,
        MAXIMUM_SET,
        MINIMUM_SET;

    }
}

