/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.extensions.policy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.annotations.Policy;
import org.jboss.wsf.stack.cxf.client.ProviderImpl;
import org.jboss.wsf.stack.cxf.extensions.policy.PolicyAttachment;

public class PolicyAttachmentStore {
    private static final String POLICY_ATTACHMENT_LOCATION = "META-INF/policies/";
    private final Map<String, List<PolicyAttachment>> attachments;
    private static PolicyAttachmentStore defaultServerInstance;

    public PolicyAttachmentStore(ClassLoader cl) {
        HashMap<String, List<PolicyAttachment>> map = new HashMap<String, List<PolicyAttachment>>();
        PolicyAttachmentStore.parsePolicyAttachmentResources(cl, map);
        this.attachments = map;
    }

    public static synchronized PolicyAttachmentStore getDefaultInstance() {
        if (defaultServerInstance == null) {
            defaultServerInstance = new PolicyAttachmentStore(ProviderImpl.class.getClassLoader());
        }
        return defaultServerInstance;
    }

    public void merge(PolicyAttachmentStore pas) {
        this.attachments.putAll(pas.attachments);
    }

    public List<PolicyAttachment> get(String setName) {
        List<PolicyAttachment> l = this.attachments.get(setName);
        if (l != null && !l.isEmpty()) {
            return Collections.unmodifiableList(l);
        }
        return Collections.emptyList();
    }

    public boolean isEmpty() {
        return this.attachments.isEmpty();
    }

    private static void parsePolicyAttachmentResources(ClassLoader cl, Map<String, List<PolicyAttachment>> map) {
        try {
            Enumeration<URL> urls = PolicyAttachmentStore.getResources(cl, POLICY_ATTACHMENT_LOCATION + PolicyAttachmentStore.class.getName());
            if (urls != null) {
                while (urls.hasMoreElements()) {
                    PolicyAttachmentStore.parsePolicyAttachmentStore(urls.nextElement(), map);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parsePolicyAttachmentStore(URL url, Map<String, List<PolicyAttachment>> map) throws IOException {
        InputStream storeStream = url.openStream();
        if (storeStream != null) {
            String baseUrl = url.toString();
            baseUrl = baseUrl.substring(0, baseUrl.length() - PolicyAttachmentStore.class.getName().length());
            try (BufferedReader br = new BufferedReader(new InputStreamReader(storeStream, "UTF-8"));){
                String set;
                while ((set = br.readLine()) != null) {
                    for (Policy.Placement p : Policy.Placement.values()) {
                        String newUrl = baseUrl + set + "-" + String.valueOf(p) + ".xml";
                        URL policyAttachmentUrl = new URL(newUrl);
                        try (InputStream is = null;){
                            is = policyAttachmentUrl.openStream();
                            if (is == null) continue;
                            if (map.containsKey(set)) {
                                map.get(set).add(new PolicyAttachment(p, newUrl));
                                continue;
                            }
                            ArrayList<PolicyAttachment> list = new ArrayList<PolicyAttachment>(4);
                            list.add(new PolicyAttachment(p, newUrl));
                            map.put(set, list);
                        }
                    }
                }
            }
        }
    }

    private static Enumeration<URL> getResources(final ClassLoader cl, final String filename) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return cl.getResources(filename);
        }
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Enumeration<URL>>(){

            @Override
            public Enumeration<URL> run() throws Exception {
                return cl.getResources(filename);
            }
        });
    }
}

