/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.amqp;

import io.vertx.core.json.JsonObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Footer;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.message.Message;

public class OutgoingAmqpMetadata {
    private final Message message = Message.Factory.create();

    public OutgoingAmqpMetadata() {
    }

    public OutgoingAmqpMetadata(String address, boolean durable, short priority, long ttl, DeliveryAnnotations deliveryAnnotations, MessageAnnotations messageAnnotations, String id, String userId, String subject, String replyTo, String correlationId, String contentType, String contentEncoding, long expiryTime, long creationTime, String groupId, long groupSequence, String replyToGroupId, JsonObject applicationProperties, Footer footer) {
        this();
        this.message.setAddress(address);
        this.message.setDurable(durable);
        if (priority > 0) {
            this.message.setPriority(priority);
        }
        if (ttl > 0L) {
            this.message.setTtl(ttl);
        }
        this.message.setDeliveryAnnotations(deliveryAnnotations);
        this.message.setMessageAnnotations(messageAnnotations);
        this.message.setMessageId((Object)id);
        if (userId != null) {
            this.message.setUserId(userId.getBytes());
        }
        this.message.setSubject(subject);
        this.message.setReplyTo(replyTo);
        this.message.setCorrelationId((Object)correlationId);
        this.message.setContentType(contentType);
        this.message.setContentEncoding(contentEncoding);
        if (expiryTime > 0L) {
            this.message.setExpiryTime(expiryTime);
        }
        if (creationTime > 0L) {
            this.message.setCreationTime(creationTime);
        }
        this.message.setGroupId(groupId);
        if (groupSequence >= 0L) {
            this.message.setGroupSequence(groupSequence);
        }
        this.message.setReplyToGroupId(replyToGroupId);
        this.message.setApplicationProperties(new ApplicationProperties(applicationProperties.getMap()));
        this.message.setFooter(footer);
    }

    public String getAddress() {
        return this.message.getAddress();
    }

    public String getUserId() {
        byte[] userId = this.message.getUserId();
        if (userId != null) {
            return new String(userId);
        }
        return null;
    }

    public String getReplyTo() {
        return this.message.getReplyTo();
    }

    public String getGroupId() {
        return this.message.getGroupId();
    }

    public String getContentType() {
        return this.message.getContentType();
    }

    public long getExpiryTime() {
        return this.message.getExpiryTime();
    }

    public String getCorrelationId() {
        Object correlationId = this.message.getCorrelationId();
        if (correlationId != null) {
            return correlationId.toString();
        }
        return null;
    }

    public String getContentEncoding() {
        return this.message.getContentEncoding();
    }

    public String getSubject() {
        return this.message.getSubject();
    }

    public DeliveryAnnotations getDeliveryAnnotations() {
        DeliveryAnnotations annotations = this.message.getDeliveryAnnotations();
        if (annotations == null) {
            return new DeliveryAnnotations(Collections.emptyMap());
        }
        return annotations;
    }

    public MessageAnnotations getMessageAnnotations() {
        MessageAnnotations annotations = this.message.getMessageAnnotations();
        if (annotations == null) {
            return new MessageAnnotations(Collections.emptyMap());
        }
        return annotations;
    }

    public Footer getFooter() {
        Footer footer = this.message.getFooter();
        if (footer == null) {
            return new Footer(Collections.emptyMap());
        }
        return footer;
    }

    public boolean isDurable() {
        return this.message.isDurable();
    }

    public short getPriority() {
        return this.message.getPriority();
    }

    public long getTtl() {
        return this.message.getTtl();
    }

    public String getMessageId() {
        Object messageId = this.message.getMessageId();
        if (messageId != null) {
            return messageId.toString();
        }
        return null;
    }

    public long getGroupSequence() {
        return this.message.getGroupSequence();
    }

    public String getReplyToGroupId() {
        return this.message.getReplyToGroupId();
    }

    public long getCreationTime() {
        return this.message.getCreationTime();
    }

    public JsonObject getProperties() {
        ApplicationProperties applicationProperties = this.message.getApplicationProperties();
        if (applicationProperties != null) {
            return new JsonObject(applicationProperties.getValue());
        }
        return new JsonObject();
    }

    public static OutgoingAmqpMetadataBuilder builder() {
        return new OutgoingAmqpMetadataBuilder();
    }

    public static OutgoingAmqpMetadataBuilder from(OutgoingAmqpMetadata existing) {
        return new OutgoingAmqpMetadataBuilder(existing);
    }

    public static final class OutgoingAmqpMetadataBuilder {
        private boolean durable;
        private short priority = (short)-1;
        private long ttl = -1L;
        private Map<Symbol, Object> deliveryAnnotations = new HashMap<Symbol, Object>();
        private Map<Symbol, Object> messageAnnotations = new HashMap<Symbol, Object>();
        private String address;
        private String id;
        private String userId;
        private String subject;
        private String replyTo;
        private String correlationId;
        private String contentType;
        private String contentEncoding;
        private long expiryTime = -1L;
        private long creationTime = -1L;
        private String groupId;
        private long groupSequence = -1L;
        private String replyToGroupId;
        private JsonObject applicationProperties = new JsonObject();
        private final Map<String, Object> footer = new HashMap<String, Object>();

        private OutgoingAmqpMetadataBuilder() {
        }

        private OutgoingAmqpMetadataBuilder(OutgoingAmqpMetadata existing) {
            this.address = existing.message.getAddress();
            this.durable = existing.isDurable();
            this.priority = existing.getPriority();
            this.ttl = existing.getTtl();
            this.applicationProperties = existing.getProperties();
            this.deliveryAnnotations.putAll(existing.getDeliveryAnnotations().getValue());
            this.messageAnnotations.putAll(existing.getMessageAnnotations().getValue());
            this.id = existing.getMessageId();
            this.userId = existing.getUserId();
            this.subject = existing.getSubject();
            this.replyTo = existing.getReplyTo();
            this.correlationId = existing.getCorrelationId();
            this.contentType = existing.getContentType();
            this.contentEncoding = existing.getContentEncoding();
            this.expiryTime = existing.getExpiryTime();
            this.creationTime = existing.getCreationTime();
            this.groupId = existing.getGroupId();
            this.groupSequence = existing.getGroupSequence();
            this.replyToGroupId = existing.getReplyToGroupId();
            Map footer = existing.getFooter().getValue();
            this.footer.putAll(footer);
        }

        public OutgoingAmqpMetadataBuilder withAddress(String address) {
            this.address = address;
            return this;
        }

        public OutgoingAmqpMetadataBuilder withDurable(boolean durable) {
            this.durable = durable;
            return this;
        }

        public OutgoingAmqpMetadataBuilder withPriority(short priority) {
            this.priority = priority;
            return this;
        }

        public OutgoingAmqpMetadataBuilder withTtl(long ttl) {
            this.ttl = ttl;
            return this;
        }

        public OutgoingAmqpMetadataBuilder withDeliveryAnnotations(DeliveryAnnotations deliveryAnnotations) {
            this.deliveryAnnotations = deliveryAnnotations.getValue();
            return this;
        }

        public OutgoingAmqpMetadataBuilder withMessageAnnotations(MessageAnnotations messageAnnotations) {
            this.messageAnnotations = messageAnnotations.getValue();
            return this;
        }

        public OutgoingAmqpMetadataBuilder withDeliveryAnnotations(String key, Object value) {
            if (this.deliveryAnnotations == null) {
                this.deliveryAnnotations = new HashMap<Symbol, Object>();
            }
            this.deliveryAnnotations.put(Symbol.valueOf((String)key), value);
            return this;
        }

        public OutgoingAmqpMetadataBuilder withMessageAnnotations(String key, Object value) {
            if (this.messageAnnotations == null) {
                this.messageAnnotations = new HashMap<Symbol, Object>();
            }
            this.messageAnnotations.put(Symbol.valueOf((String)key), value);
            return this;
        }

        public OutgoingAmqpMetadataBuilder withMessageId(String id) {
            this.id = id;
            return this;
        }

        public OutgoingAmqpMetadataBuilder withUserId(String userId) {
            this.userId = userId;
            return this;
        }

        public OutgoingAmqpMetadataBuilder withReplyTo(String replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public OutgoingAmqpMetadataBuilder withCorrelationId(String correlationId) {
            this.correlationId = correlationId;
            return this;
        }

        public OutgoingAmqpMetadataBuilder withContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public OutgoingAmqpMetadataBuilder withContentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public OutgoingAmqpMetadataBuilder withExpiryTime(long expiryTime) {
            this.expiryTime = expiryTime;
            return this;
        }

        public OutgoingAmqpMetadataBuilder withCreationTime(long creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public OutgoingAmqpMetadataBuilder withGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public OutgoingAmqpMetadataBuilder withGroupSequence(int groupSequence) {
            this.groupSequence = groupSequence;
            return this;
        }

        public OutgoingAmqpMetadataBuilder withReplyToGroupId(String replyToGroupId) {
            this.replyToGroupId = replyToGroupId;
            return this;
        }

        public OutgoingAmqpMetadataBuilder withSubject(String subject) {
            this.subject = subject;
            return this;
        }

        public OutgoingAmqpMetadataBuilder withApplicationProperty(String key, Object value) {
            this.applicationProperties.put(key, value);
            return this;
        }

        public OutgoingAmqpMetadataBuilder withApplicationProperties(JsonObject json) {
            this.applicationProperties = json;
            return this;
        }

        public OutgoingAmqpMetadataBuilder withFooter(String key, Object value) {
            this.footer.put(key, value);
            return this;
        }

        public OutgoingAmqpMetadata build() {
            return new OutgoingAmqpMetadata(this.address, this.durable, this.priority, this.ttl, new DeliveryAnnotations(this.deliveryAnnotations), new MessageAnnotations(this.messageAnnotations), this.id, this.userId, this.subject, this.replyTo, this.correlationId, this.contentType, this.contentEncoding, this.expiryTime, this.creationTime, this.groupId, this.groupSequence, this.replyToGroupId, this.applicationProperties, new Footer(this.footer));
        }
    }
}

