/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.jsp;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.parser.ee.DescriptionGroupMetaDataParser;
import org.jboss.metadata.parser.jsp.Attribute;
import org.jboss.metadata.parser.jsp.Element;
import org.jboss.metadata.parser.jsp.TldExtensionMetaDataParser;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.web.spec.TagFileMetaData;
import org.jboss.metadata.web.spec.TldExtensionMetaData;

public class TagFileMetaDataParser
extends MetaDataElementParser {
    public static TagFileMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        TagFileMetaData tagFile = new TagFileMetaData();
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (TagFileMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i)) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    tagFile.setId(value);
                    continue block9;
                }
                default: {
                    throw TagFileMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        DescriptionGroupMetaData descriptionGroup = new DescriptionGroupMetaData();
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            if (DescriptionGroupMetaDataParser.parse((XMLStreamReader)reader, (DescriptionGroupMetaData)descriptionGroup)) {
                if (tagFile.getDescriptionGroup() != null) continue;
                tagFile.setDescriptionGroup(descriptionGroup);
                continue;
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case NAME: {
                    tagFile.setName(TagFileMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block10;
                }
                case PATH: {
                    tagFile.setPath(TagFileMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block10;
                }
                case EXAMPLE: {
                    List<String> examples = tagFile.getExamples();
                    if (examples == null) {
                        examples = new ArrayList<String>();
                        tagFile.setExamples(examples);
                    }
                    examples.add(TagFileMetaDataParser.getElementText((XMLStreamReader)reader));
                    continue block10;
                }
                case TAG_EXTENSION: {
                    List<TldExtensionMetaData> extensions = tagFile.getTagExtensions();
                    if (extensions == null) {
                        extensions = new ArrayList<TldExtensionMetaData>();
                        tagFile.setTagExtensions(extensions);
                    }
                    extensions.add(TldExtensionMetaDataParser.parse(reader));
                    continue block10;
                }
            }
            throw TagFileMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return tagFile;
    }
}

