/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.el.expressly;

import jakarta.el.FunctionMapper;
import jakarta.el.VariableMapper;
import java.io.IOException;
import java.lang.reflect.Field;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import org.glassfish.expressly.MethodExpressionImpl;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.SimpleObjectOutput;
import org.wildfly.security.manager.WildFlySecurityManager;

public class MethodExpressionImplMarshaller
implements ProtoStreamMarshaller<MethodExpressionImpl> {
    private static final int EXPRESSION_INDEX = 1;
    private static final int EXPECTED_TYPE_INDEX = 2;
    private static final int FUNCTION_MAPPER_INDEX = 3;
    private static final int VARIABLE_MAPPER_INDEX = 4;
    private static final int PARAMETER_TYPE_INDEX = 5;
    private static final Field EXPECTED_TYPE_FIELD = MethodExpressionImplMarshaller.getField(Class.class);
    private static final Field PARAMETER_TYPES_FIELD = MethodExpressionImplMarshaller.getField(Class[].class);

    private static Field getField(final Class<?> targetType) {
        return (Field)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                for (Field field : MethodExpressionImpl.class.getDeclaredFields()) {
                    if (field.getType() != targetType) continue;
                    field.setAccessible(true);
                    return field;
                }
                throw new IllegalStateException();
            }
        });
    }

    public Class<? extends MethodExpressionImpl> getJavaClass() {
        return MethodExpressionImpl.class;
    }

    public MethodExpressionImpl readFrom(ProtoStreamReader reader) throws IOException {
        String expression = null;
        Class expectedType = null;
        FunctionMapper functionMapper = null;
        VariableMapper variableMapper = null;
        LinkedList<Class> parameterTypes = new LinkedList<Class>();
        block7: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    expression = reader.readString();
                    continue block7;
                }
                case 2: {
                    expectedType = (Class)reader.readAny(Class.class);
                    continue block7;
                }
                case 3: {
                    functionMapper = (FunctionMapper)reader.readAny(FunctionMapper.class);
                    continue block7;
                }
                case 4: {
                    variableMapper = (VariableMapper)reader.readAny(VariableMapper.class);
                    continue block7;
                }
                case 5: {
                    parameterTypes.add((Class)reader.readAny(Class.class));
                    continue block7;
                }
            }
            reader.skipField(tag);
        }
        return new MethodExpressionImpl(expression, null, functionMapper, variableMapper, expectedType, parameterTypes.toArray(new Class[0]));
    }

    public void writeTo(ProtoStreamWriter writer, MethodExpressionImpl value) throws IOException {
        Object variableMapper;
        Class[] parameterTypes;
        Class expectedType;
        String[] strings = new String[2];
        Object[] objects = new Object[3];
        value.writeExternal(new SimpleObjectOutput.Builder().with(strings).with(objects).build());
        String expression = value.getExpressionString();
        if (expression != null) {
            writer.writeString(1, expression);
        }
        if ((expectedType = MethodExpressionImplMarshaller.getValue(value, EXPECTED_TYPE_FIELD, Class.class)) != null) {
            writer.writeAny(2, (Object)expectedType);
        }
        for (Class parameterType : parameterTypes = MethodExpressionImplMarshaller.getValue(value, PARAMETER_TYPES_FIELD, Class[].class)) {
            writer.writeAny(5, (Object)parameterType);
        }
        Object functionMapper = objects[1];
        if (functionMapper != null) {
            writer.writeAny(3, functionMapper);
        }
        if ((variableMapper = objects[2]) != null) {
            writer.writeAny(4, variableMapper);
        }
    }

    private static <T> T getValue(final MethodExpressionImpl value, final Field field, final Class<T> targetClass) {
        return (T)WildFlySecurityManager.doUnchecked((PrivilegedAction)new PrivilegedAction<T>(){

            @Override
            public T run() {
                try {
                    return targetClass.cast(field.get(value));
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }
}

