/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.concurrent;

import jakarta.enterprise.concurrent.LastExecution;
import jakarta.enterprise.concurrent.Trigger;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.glassfish.enterprise.concurrent.AbstractManagedThread;
import org.glassfish.enterprise.concurrent.ContextServiceImpl;
import org.jboss.as.controller.ProcessStateNotifier;
import org.jboss.as.ee.concurrent.ControlPointUtils;
import org.jboss.as.ee.concurrent.ManagedExecutorRuntimeStats;
import org.jboss.as.ee.concurrent.ManagedExecutorRuntimeStatsImpl30;
import org.jboss.as.ee.concurrent.ManagedExecutorServiceImpl;
import org.jboss.as.ee.concurrent.ManagedThreadFactoryImpl;
import org.jboss.as.ee.concurrent.SecurityIdentityUtils;
import org.jboss.as.ee.concurrent.WildFlyContextService;
import org.jboss.as.ee.concurrent.WildFlyManagedExecutorService;
import org.jboss.as.ee.concurrent.WildFlyManagedScheduledExecutorService;
import org.jboss.as.ee.concurrent.WildFlyManagedThreadFactory;
import org.jboss.as.ee.logging.EeLogger;
import org.wildfly.extension.requestcontroller.ControlPoint;

public class ManagedScheduledExecutorServiceImpl
extends org.glassfish.enterprise.concurrent.ManagedScheduledExecutorServiceImpl
implements WildFlyManagedScheduledExecutorService {
    private final ControlPoint controlPoint;
    private final ProcessStateNotifier processStateNotifier;
    private final ManagedExecutorRuntimeStats runtimeStats;

    public ManagedScheduledExecutorServiceImpl(String name, WildFlyManagedThreadFactory managedThreadFactory, long hungTaskThreshold, boolean longRunningTasks, int corePoolSize, long keepAliveTime, TimeUnit keepAliveTimeUnit, long threadLifeTime, WildFlyContextService contextService, WildFlyManagedExecutorService.RejectPolicy rejectPolicy, ControlPoint controlPoint, ProcessStateNotifier processStateNotifier) {
        super(name, (org.glassfish.enterprise.concurrent.ManagedThreadFactoryImpl)((ManagedThreadFactoryImpl)managedThreadFactory), hungTaskThreshold, longRunningTasks, corePoolSize, keepAliveTime, keepAliveTimeUnit, threadLifeTime, (ContextServiceImpl)contextService, ManagedExecutorServiceImpl.convertRejectPolicy(rejectPolicy));
        this.controlPoint = controlPoint;
        this.processStateNotifier = processStateNotifier;
        this.runtimeStats = new ManagedExecutorRuntimeStatsImpl30(this);
    }

    public WildFlyManagedThreadFactory getWildFlyManagedThreadFactory() {
        return (WildFlyManagedThreadFactory)this.getManagedThreadFactory();
    }

    public void execute(Runnable command) {
        super.execute(SecurityIdentityUtils.doIdentityWrap((Runnable)ControlPointUtils.doWrap((Runnable)command, (ControlPoint)this.controlPoint, (ProcessStateNotifier)this.processStateNotifier)));
    }

    public Future<?> submit(Runnable task) {
        return super.submit(SecurityIdentityUtils.doIdentityWrap((Runnable)ControlPointUtils.doWrap((Runnable)task, (ControlPoint)this.controlPoint, (ProcessStateNotifier)this.processStateNotifier)));
    }

    public <T> Future<T> submit(Runnable task, T result) {
        return super.submit(SecurityIdentityUtils.doIdentityWrap((Runnable)ControlPointUtils.doWrap((Runnable)task, (ControlPoint)this.controlPoint, (ProcessStateNotifier)this.processStateNotifier)), result);
    }

    public <T> Future<T> submit(Callable<T> task) {
        return super.submit(SecurityIdentityUtils.doIdentityWrap((Callable)ControlPointUtils.doWrap(task, (ControlPoint)this.controlPoint, (ProcessStateNotifier)this.processStateNotifier)));
    }

    public ScheduledFuture<?> schedule(Runnable command, Trigger trigger) {
        CancellableTrigger ctrigger = new CancellableTrigger(trigger);
        ctrigger.future = super.schedule(SecurityIdentityUtils.doIdentityWrap((Runnable)ControlPointUtils.doScheduledWrap((Runnable)command, (ControlPoint)this.controlPoint, (ProcessStateNotifier)this.processStateNotifier)), (Trigger)ctrigger);
        return ctrigger.future;
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, Trigger trigger) {
        CancellableTrigger ctrigger = new CancellableTrigger(trigger);
        ctrigger.future = super.schedule(SecurityIdentityUtils.doIdentityWrap((Callable)ControlPointUtils.doScheduledWrap(callable, (ControlPoint)this.controlPoint, (ProcessStateNotifier)this.processStateNotifier)), (Trigger)ctrigger);
        return ctrigger.future;
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return super.schedule(SecurityIdentityUtils.doIdentityWrap((Runnable)ControlPointUtils.doScheduledWrap((Runnable)command, (ControlPoint)this.controlPoint, (ProcessStateNotifier)this.processStateNotifier)), delay, unit);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return super.schedule(SecurityIdentityUtils.doIdentityWrap((Callable)ControlPointUtils.doScheduledWrap(callable, (ControlPoint)this.controlPoint, (ProcessStateNotifier)this.processStateNotifier)), delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return super.scheduleAtFixedRate(SecurityIdentityUtils.doIdentityWrap((Runnable)ControlPointUtils.doScheduledWrap((Runnable)command, (ControlPoint)this.controlPoint, (ProcessStateNotifier)this.processStateNotifier)), initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return super.scheduleWithFixedDelay(SecurityIdentityUtils.doIdentityWrap((Runnable)ControlPointUtils.doScheduledWrap((Runnable)command, (ControlPoint)this.controlPoint, (ProcessStateNotifier)this.processStateNotifier)), initialDelay, delay, unit);
    }

    protected ThreadPoolExecutor getThreadPoolExecutor() {
        return (ThreadPoolExecutor)super.getThreadPoolExecutor();
    }

    public ManagedExecutorRuntimeStats getRuntimeStats() {
        return this.runtimeStats;
    }

    public void terminateHungTasks() {
        String executorName = ((Object)((Object)this)).getClass().getSimpleName() + ":" + this.getName();
        EeLogger.ROOT_LOGGER.debugf("Cancelling %s hung tasks...", (Object)executorName);
        Collection hungThreads = this.getHungThreads();
        if (hungThreads != null) {
            for (AbstractManagedThread t : hungThreads) {
                String taskIdentityName = t.getTaskIdentityName();
                try {
                    if (!(t instanceof ManagedThreadFactoryImpl.ManagedThread)) continue;
                    if (((ManagedThreadFactoryImpl.ManagedThread)t).cancelTask()) {
                        EeLogger.ROOT_LOGGER.hungTaskCancelled(executorName, taskIdentityName);
                        continue;
                    }
                    EeLogger.ROOT_LOGGER.hungTaskNotCancelled(executorName, taskIdentityName);
                }
                catch (Throwable throwable) {
                    EeLogger.ROOT_LOGGER.huntTaskTerminationFailure(throwable, executorName, taskIdentityName);
                }
            }
        }
    }

    private static class CancellableTrigger
    implements Trigger {
        private final Trigger trigger;
        private ScheduledFuture future;

        CancellableTrigger(Trigger trigger) {
            this.trigger = trigger;
        }

        public Date getNextRunTime(LastExecution lastExecution, Date taskScheduledTime) {
            Date nextRunTime = this.trigger.getNextRunTime(lastExecution, taskScheduledTime);
            ScheduledFuture future = this.future;
            if (future != null && future.isCancelled()) {
                nextRunTime = null;
            }
            return nextRunTime;
        }

        public boolean skipRun(LastExecution lastExecution, Date date) {
            return this.trigger.skipRun(lastExecution, date);
        }
    }
}

