/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded;

import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.metadata.Metadata;
import org.wildfly.clustering.cache.infinispan.embedded.AbstractAdvancedCache;

public class InvalidationCache<K, V>
extends AbstractAdvancedCache<K, V>
implements AdvancedCache<K, V> {
    private final Collection<Flag> flags;

    public InvalidationCache(Cache<K, V> cache) {
        this(cache.getAdvancedCache());
    }

    public InvalidationCache(AdvancedCache<K, V> cache) {
        this(cache, EnumSet.noneOf(Flag.class));
    }

    private InvalidationCache(AdvancedCache<K, V> cache, Collection<Flag> flags) {
        super(cache);
        this.flags = flags;
    }

    public AdvancedCache<K, V> withFlags(Collection<Flag> flags) {
        AdvancedCache cache = this.cache.withFlags(flags);
        return cache != this.cache ? new InvalidationCache<K, V>(cache, flags) : this;
    }

    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        V newValue;
        if (this.flags.contains(Flag.SKIP_CACHE_LOAD)) {
            return (V)super.compute(key, remappingFunction, metadata);
        }
        Object oldValue = this.lockOnReadCache().get(key);
        return oldValue != (newValue = remappingFunction.apply(key, oldValue)) ? (this.update(key, oldValue, newValue, metadata) ? newValue : this.compute(key, remappingFunction, metadata)) : newValue;
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, Metadata metadata) {
        Object newValue;
        if (this.flags.contains(Flag.SKIP_CACHE_LOAD)) {
            return (V)super.computeIfAbsent(key, mappingFunction, metadata);
        }
        Object oldValue = this.lockOnReadCache().get(key);
        Object object = newValue = oldValue == null ? mappingFunction.apply(key) : oldValue;
        return (V)(oldValue != newValue ? (this.update(key, oldValue, newValue, metadata) ? newValue : this.computeIfAbsent(key, mappingFunction, metadata)) : newValue);
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        V newValue;
        if (this.flags.contains(Flag.SKIP_CACHE_LOAD)) {
            return (V)super.computeIfPresent(key, remappingFunction, metadata);
        }
        Object oldValue = this.lockOnReadCache().get(key);
        V v = newValue = oldValue != null ? (V)remappingFunction.apply((K)key, (V)oldValue) : null;
        return oldValue != newValue ? (this.update(key, oldValue, newValue, metadata) ? newValue : (V)this.computeIfPresent(key, remappingFunction, metadata)) : newValue;
    }

    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        V newValue;
        if (this.flags.contains(Flag.SKIP_CACHE_LOAD)) {
            return (V)super.merge(key, value, remappingFunction, metadata);
        }
        Object oldValue = this.lockOnReadCache().get(key);
        V v = newValue = oldValue != null ? remappingFunction.apply(oldValue, value) : value;
        return oldValue != newValue ? (this.update(key, oldValue, newValue, metadata) ? newValue : this.merge(key, value, remappingFunction, metadata)) : newValue;
    }

    public V put(K key, V newValue, Metadata metadata) {
        if (this.flags.contains(Flag.IGNORE_RETURN_VALUES) || this.flags.contains(Flag.SKIP_CACHE_LOAD)) {
            return (V)super.put(key, newValue, metadata);
        }
        Object oldValue = this.lockOnReadCache().get(key);
        return (V)(this.update(key, oldValue, newValue, metadata) ? oldValue : this.put(key, newValue, metadata));
    }

    public V putIfAbsent(K key, V newValue, Metadata metadata) {
        if (this.flags.contains(Flag.SKIP_CACHE_LOAD)) {
            return (V)super.putIfAbsent(key, newValue, metadata);
        }
        Object oldValue = this.lockOnReadCache().get(key);
        return (V)(oldValue == null ? (this.update(key, oldValue, newValue, metadata) ? oldValue : this.putIfAbsent(key, newValue, metadata)) : oldValue);
    }

    public V remove(Object key) {
        if (this.flags.contains(Flag.SKIP_CACHE_LOAD)) {
            return (V)super.remove(key);
        }
        Object typedKey = key;
        Object oldValue = this.lockOnReadCache().get(key);
        return (V)(oldValue != null ? (this.update(typedKey, oldValue, null, null) ? oldValue : this.remove(key)) : oldValue);
    }

    public V replace(K key, V newValue, Metadata metadata) {
        if (this.flags.contains(Flag.IGNORE_RETURN_VALUES) || this.flags.contains(Flag.SKIP_CACHE_LOAD)) {
            return (V)super.put(key, newValue, metadata);
        }
        Object oldValue = this.lockOnReadCache().get(key);
        return (V)(oldValue != null ? (this.update(key, oldValue, newValue, metadata) ? oldValue : this.replace(key, newValue, metadata)) : oldValue);
    }

    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        if (this.flags.contains(Flag.SKIP_CACHE_LOAD)) {
            return super.computeAsync(key, remappingFunction, metadata);
        }
        return ((CompletableFuture)((CompletableFuture)this.lockOnReadCache().getAsync(key).thenApply(oldValue -> new AbstractMap.SimpleImmutableEntry(oldValue, remappingFunction.apply((Object)key, (Object)oldValue)))).thenCompose(entry -> this.updateAsync(key, entry.getKey(), entry.getValue(), metadata).thenApply(updated -> updated != false ? entry : null))).thenCompose(entry -> entry != null ? CompletableFuture.completedStage(entry.getValue()) : this.computeAsync(key, remappingFunction, metadata));
    }

    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction, Metadata metadata) {
        if (this.flags.contains(Flag.SKIP_CACHE_LOAD)) {
            return super.computeIfAbsentAsync(key, mappingFunction, metadata);
        }
        return ((CompletableFuture)((CompletableFuture)this.lockOnReadCache().getAsync(key).thenApply(oldValue -> new AbstractMap.SimpleImmutableEntry<Object, Object>(oldValue, oldValue == null ? mappingFunction.apply((Object)key) : oldValue))).thenCompose(entry -> entry.getKey() != entry.getValue() ? this.updateAsync(key, entry.getKey(), entry.getValue(), metadata).thenApply(updated -> updated != false ? entry : null) : CompletableFuture.completedStage(entry))).thenCompose(entry -> entry != null ? CompletableFuture.completedStage(entry.getValue()) : this.computeIfAbsentAsync(key, mappingFunction, metadata));
    }

    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        if (this.flags.contains(Flag.SKIP_CACHE_LOAD)) {
            return super.computeIfPresentAsync(key, remappingFunction, metadata);
        }
        return ((CompletableFuture)((CompletableFuture)this.lockOnReadCache().getAsync(key).thenApply(oldValue -> new AbstractMap.SimpleImmutableEntry<Object, Object>(oldValue, oldValue != null ? remappingFunction.apply((Object)key, (Object)oldValue) : oldValue))).thenCompose(entry -> entry.getKey() != entry.getValue() ? this.updateAsync(key, entry.getKey(), entry.getValue(), metadata).thenApply(updated -> updated != false ? entry : null) : CompletableFuture.completedStage(entry))).thenCompose(entry -> entry != null ? CompletableFuture.completedStage(entry.getValue()) : this.computeIfPresentAsync(key, remappingFunction, metadata));
    }

    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, Metadata metadata) {
        if (this.flags.contains(Flag.SKIP_CACHE_LOAD)) {
            return super.mergeAsync(key, value, remappingFunction, metadata);
        }
        return ((CompletableFuture)((CompletableFuture)this.lockOnReadCache().getAsync(key).thenApply(oldValue -> new AbstractMap.SimpleImmutableEntry<Object, Object>(oldValue, oldValue != null ? remappingFunction.apply((Object)oldValue, (Object)value) : value))).thenCompose(entry -> entry.getKey() != entry.getValue() ? this.updateAsync(key, entry.getKey(), entry.getValue(), metadata).thenApply(updated -> updated != false ? entry : null) : CompletableFuture.completedStage(entry))).thenCompose(entry -> entry != null ? CompletableFuture.completedStage(entry.getValue()) : this.mergeAsync(key, value, remappingFunction, metadata));
    }

    public CompletableFuture<V> putAsync(K key, V value, Metadata metadata) {
        if (this.flags.contains(Flag.IGNORE_RETURN_VALUES) || this.flags.contains(Flag.SKIP_CACHE_LOAD)) {
            return super.putAsync(key, value, metadata);
        }
        return ((CompletableFuture)((CompletableFuture)this.lockOnReadCache().getAsync(key).thenApply(oldValue -> new AbstractMap.SimpleImmutableEntry<Object, Object>(oldValue, value))).thenCompose(entry -> this.updateAsync(key, entry.getKey(), entry.getValue(), metadata).thenApply(updated -> updated != false ? entry : null))).thenCompose(entry -> entry != null ? CompletableFuture.completedStage(entry.getKey()) : this.putAsync(key, value, metadata));
    }

    public CompletableFuture<V> putIfAbsentAsync(K key, V newValue, Metadata metadata) {
        if (this.flags.contains(Flag.SKIP_CACHE_LOAD)) {
            return super.putIfAbsentAsync(key, newValue, metadata);
        }
        return ((CompletableFuture)((CompletableFuture)this.lockOnReadCache().getAsync(key).thenApply(oldValue -> new AbstractMap.SimpleImmutableEntry<Object, Object>(oldValue, oldValue == null ? newValue : oldValue))).thenCompose(entry -> entry.getKey() != entry.getValue() ? this.updateAsync(key, entry.getKey(), entry.getValue(), metadata).thenApply(updated -> updated != false ? entry : null) : CompletableFuture.completedStage(entry))).thenCompose(entry -> entry != null ? CompletableFuture.completedStage(entry.getKey()) : this.putIfAbsentAsync(key, newValue, metadata));
    }

    public CompletableFuture<V> removeAsync(Object key) {
        if (this.flags.contains(Flag.SKIP_CACHE_LOAD)) {
            return super.removeAsync(key);
        }
        Object typedKey = key;
        return ((CompletableFuture)this.lockOnReadCache().getAsync(typedKey).thenCompose(value -> value != null ? this.updateAsync(typedKey, value, null, null).thenApply(updated -> updated != false ? Optional.of(value) : null) : CompletableFuture.completedStage(Optional.empty()))).thenCompose(value -> value != null ? CompletableFuture.completedStage(value.orElse(null)) : this.removeAsync(key));
    }

    public CompletableFuture<V> replaceAsync(K key, V newValue, Metadata metadata) {
        if (this.flags.contains(Flag.SKIP_CACHE_LOAD)) {
            return super.replaceAsync(key, newValue, metadata);
        }
        return ((CompletableFuture)((CompletableFuture)this.lockOnReadCache().getAsync(key).thenApply(oldValue -> new AbstractMap.SimpleImmutableEntry<Object, Object>(oldValue, oldValue != null ? newValue : oldValue))).thenCompose(entry -> entry.getKey() != entry.getValue() ? this.updateAsync(key, entry.getKey(), entry.getValue(), metadata).thenApply(updated -> updated != false ? entry : null) : CompletableFuture.completedStage(entry))).thenCompose(entry -> entry != null ? CompletableFuture.completedStage(entry.getKey()) : this.replaceAsync(key, newValue, metadata));
    }

    public AdvancedCache rewrap(AdvancedCache cache) {
        return new InvalidationCache<K, V>(cache, this.flags);
    }

    boolean hasCurrentTransaction() {
        TransactionManager tm = this.getTransactionManager();
        return tm != null && InvalidationCache.hasCurrentTransaction(tm);
    }

    static boolean hasCurrentTransaction(TransactionManager tm) {
        try {
            return tm.getStatus() == 6;
        }
        catch (SystemException e) {
            return false;
        }
    }

    AdvancedCache<K, V> lockOnReadCache() {
        return this.hasCurrentTransaction() ? this.cache.withFlags(Flag.FORCE_WRITE_LOCK) : this.cache;
    }

    private boolean update(K key, V oldValue, V newValue, Metadata metadata) {
        return oldValue != null ? (newValue != null ? this.cache.replace(key, oldValue, newValue, metadata) : this.cache.remove(key, oldValue)) : (newValue != null ? this.cache.putIfAbsent(key, newValue, metadata) == null : true);
    }

    private CompletionStage<Boolean> updateAsync(K key, V oldValue, V newValue, Metadata metadata) {
        return oldValue != null ? (newValue != null ? this.cache.replaceAsync(key, oldValue, newValue, metadata) : this.cache.removeAsync(key, oldValue)) : (newValue != null ? this.cache.putIfAbsentAsync(key, newValue, metadata).thenApply(Objects::isNull) : CompletableFuture.completedStage(true));
    }
}

