/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import io.undertow.client.ClientExchange;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.security.impl.AuthenticationInfoToken;
import io.undertow.security.impl.DigestWWWAuthenticateToken;
import io.undertow.server.session.SecureRandomSessionIdGenerator;
import io.undertow.util.AttachmentKey;
import io.undertow.util.FlexBase64;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HexConverter;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.httpclient.common.HeadersHelper;
import org.wildfly.httpclient.common.HttpClientMessages;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.auth.principal.NamePrincipal;

class PoolAuthenticationContext {
    private static final AttachmentKey<DigestImpl> DIGEST = AttachmentKey.create(DigestImpl.class);
    private static final AuthenticationContextConfigurationClient AUTH_CONTEXT_CLIENT = AccessController.doPrivileged(AuthenticationContextConfigurationClient::new);
    private volatile Type current;
    private static final LinkedBlockingDeque<DigestImpl> digestList = new LinkedBlockingDeque();
    private static final SecureRandomSessionIdGenerator cnonceGenerator = new SecureRandomSessionIdGenerator();

    PoolAuthenticationContext() {
    }

    boolean handleResponse(ClientResponse response) {
        if (response.getResponseCode() != 401) {
            return false;
        }
        String authenticate = HeadersHelper.getResponseHeader(response, Headers.WWW_AUTHENTICATE);
        if (authenticate == null) {
            return false;
        }
        String auth = authenticate.toLowerCase(Locale.ENGLISH);
        if (auth.startsWith("basic ")) {
            this.current = Type.BASIC;
            return true;
        }
        if (auth.startsWith("digest ")) {
            this.current = Type.DIGEST;
            Map result = DigestWWWAuthenticateToken.parseHeader((String)authenticate.substring(7));
            DigestImpl current = new DigestImpl();
            current.domain = (String)result.get(DigestWWWAuthenticateToken.DOMAIN);
            current.nonce = (String)result.get(DigestWWWAuthenticateToken.NONCE);
            current.opaque = (String)result.get(DigestWWWAuthenticateToken.OPAQUE);
            current.algorithm = (String)result.get(DigestWWWAuthenticateToken.ALGORITHM);
            String s = (String)result.get(DigestWWWAuthenticateToken.MESSAGE_QOP);
            current.qop = null;
            if (s != null) {
                for (String p : s.split(",")) {
                    if (!p.equals("auth")) continue;
                    current.qop = p;
                }
                if (current.qop == null) {
                    throw HttpClientMessages.MESSAGES.unsupportedQopInDigest();
                }
            }
            current.realm = (String)result.get(DigestWWWAuthenticateToken.REALM);
            current.nccount = 1;
            if (current.algorithm.startsWith("\"")) {
                current.algorithm = current.algorithm.substring(1, current.algorithm.length() - 1);
            }
            digestList.add(current);
            return true;
        }
        return false;
    }

    static String createTargetUri(URI uri, ClientRequest request) {
        String query;
        String path;
        int pos = request.getPath().indexOf("?");
        if (pos > 0) {
            path = request.getPath().substring(0, pos);
            query = request.getPath().substring(pos + 1);
        } else {
            path = request.getPath();
            query = null;
        }
        String scheme = uri.getScheme();
        String host = uri.getHost();
        int port = uri.getPort();
        StringBuilder uriBuilder = new StringBuilder();
        if (scheme != null) {
            uriBuilder.append(scheme);
            uriBuilder.append(':');
        }
        if (host != null) {
            boolean needBrackets;
            uriBuilder.append("//");
            boolean bl = needBrackets = host.indexOf(58) >= 0 && !host.startsWith("[") && !host.endsWith("]");
            if (needBrackets) {
                uriBuilder.append('[');
            }
            uriBuilder.append(host);
            if (needBrackets) {
                uriBuilder.append(']');
            }
        }
        if (!(port == -1 || "http".equals(scheme) && port == 80 || "https".equals(scheme) && port == 443)) {
            uriBuilder.append(':');
            uriBuilder.append(port);
        }
        uriBuilder.append(path);
        if (query != null && !query.isEmpty()) {
            uriBuilder.append("?");
            uriBuilder.append(query);
        }
        return uriBuilder.toString();
    }

    boolean prepareRequest(URI uri, ClientRequest request, AuthenticationConfiguration authenticationConfiguration) {
        if (this.current == Type.NONE) {
            return false;
        }
        AuthenticationConfiguration config = authenticationConfiguration;
        if (config == null) {
            config = AUTH_CONTEXT_CLIENT.getAuthenticationConfiguration(uri, AuthenticationContext.captureCurrent());
        }
        CallbackHandler callbackHandler = AUTH_CONTEXT_CLIENT.getCallbackHandler(config);
        NameCallback nameCallback = new NameCallback("user name");
        PasswordCallback passwordCallback = new PasswordCallback("password", false);
        try {
            callbackHandler.handle(new Callback[]{nameCallback, passwordCallback});
        }
        catch (IOException | UnsupportedCallbackException e) {
            return false;
        }
        String name = nameCallback.getName();
        if (name == null) {
            return false;
        }
        char[] password = passwordCallback.getPassword();
        if (password == null) {
            return false;
        }
        NamePrincipal principal = new NamePrincipal(name);
        if (this.current == Type.BASIC) {
            String challenge = principal.getName() + ":" + new String(password);
            HeadersHelper.putRequestHeader(request, Headers.AUTHORIZATION, "Basic " + FlexBase64.encodeString((byte[])challenge.getBytes(StandardCharsets.UTF_8), (boolean)false));
            return true;
        }
        if (this.current == Type.DIGEST) {
            DigestImpl current = digestList.poll();
            if (current == null) {
                return false;
            }
            String cnonce = cnonceGenerator.createSessionId();
            String digestUri = PoolAuthenticationContext.createTargetUri(uri, request);
            request.putAttachment(DIGEST, (Object)current);
            StringBuilder sb = new StringBuilder("Digest username=\"");
            sb.append(principal.getName());
            sb.append("\", uri=\"");
            sb.append(digestUri);
            sb.append("\", realm=\"");
            sb.append(current.realm);
            sb.append("\"");
            StringBuilder ncBuilder = new StringBuilder();
            if (current.qop != null) {
                sb.append(", nc=");
                String nonceCountString = Integer.toHexString(current.nccount++);
                for (int i = nonceCountString.length(); i < 8; ++i) {
                    ncBuilder.append("0");
                }
                ncBuilder.append(nonceCountString);
                sb.append(ncBuilder.toString());
                sb.append(", cnonce=\"");
                sb.append(cnonce);
                sb.append("\"");
            }
            sb.append(", algorithm=");
            sb.append(current.algorithm);
            sb.append(", nonce=\"");
            sb.append(current.nonce);
            sb.append("\", opaque=\"");
            sb.append(current.opaque);
            sb.append("\", qop=auth");
            String a1 = principal.getName() + ":" + current.realm + ":" + new String(password);
            String a2 = request.getMethod().toString() + ":" + digestUri;
            try {
                MessageDigest digest = MessageDigest.getInstance(current.algorithm);
                digest.update(a1.getBytes(StandardCharsets.UTF_8));
                byte[] hashedA1 = HexConverter.convertToHexBytes((byte[])digest.digest());
                digest.reset();
                digest.update(a2.getBytes(StandardCharsets.UTF_8));
                String hashedA2 = HexConverter.convertToHexString((byte[])digest.digest());
                digest.reset();
                digest.update(hashedA1);
                digest.update((byte)58);
                digest.update(current.nonce.getBytes(StandardCharsets.UTF_8));
                digest.update((byte)58);
                if (current.qop != null) {
                    digest.update(ncBuilder.toString().getBytes(StandardCharsets.UTF_8));
                    digest.update((byte)58);
                    digest.update(cnonce.getBytes(StandardCharsets.UTF_8));
                    digest.update((byte)58);
                    digest.update("auth".getBytes(StandardCharsets.UTF_8));
                    digest.update((byte)58);
                }
                digest.update(hashedA2.getBytes(StandardCharsets.UTF_8));
                sb.append(", response=\"");
                sb.append(HexConverter.convertToHexString((byte[])digest.digest()));
                sb.append("\"");
                HeadersHelper.putRequestHeader(request, Headers.AUTHORIZATION, sb.toString());
                return true;
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    boolean isStale(ClientExchange exchange) {
        if (this.current != Type.DIGEST) {
            return false;
        }
        ClientResponse response = exchange.getResponse();
        if (response.getResponseCode() != 401) {
            DigestImpl digest = (DigestImpl)exchange.getRequest().getAttachment(DIGEST);
            if (digest != null) {
                String authInfo = HeadersHelper.getResponseHeader(response, Headers.AUTHENTICATION_INFO);
                if (authInfo != null) {
                    try {
                        Map result = AuthenticationInfoToken.parseHeader((String)authInfo);
                        String next = (String)result.get(AuthenticationInfoToken.NEXT_NONCE);
                        if (next != null) {
                            digest.nonce = next;
                        }
                    }
                    catch (Exception e) {
                        HttpClientMessages.MESSAGES.failedToParseAuthenticationInfo(e);
                    }
                }
                digestList.add(digest);
            }
            return false;
        }
        HeaderValues headers = HeadersHelper.getResponseHeaders(response, Headers.WWW_AUTHENTICATE);
        if (headers == null) {
            return false;
        }
        for (String authenticate : headers) {
            Map result;
            String auth = authenticate.toLowerCase(Locale.ENGLISH);
            if (!auth.startsWith("digest ") || !(result = DigestWWWAuthenticateToken.parseHeader((String)authenticate.substring(7))).containsKey(DigestWWWAuthenticateToken.STALE)) continue;
            return true;
        }
        return false;
    }

    private static final class DigestImpl {
        private String realm;
        private String domain;
        private String nonce;
        private String opaque;
        private String algorithm;
        private String qop;
        private int nccount = 1;

        private DigestImpl() {
        }
    }

    static enum Type {
        NONE,
        BASIC,
        DIGEST;

    }
}

