/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.MemoryUsage;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;
import javax.management.openmbean.TabularData;
import org.jboss.as.platform.mbean.AbstractExtendedMBean;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.as.platform.mbean.logging.PlatformMBeanLogger;

class ExtendedGarbageCollectorMBean
extends AbstractExtendedMBean {
    static final String LAST_GC_INFO_ATTRIBUTE = "LastGcInfo";
    private static final String DURATION = "duration";
    private static final String END_TIME = "endTime";
    private static final String ID = "id";
    private static final String INDEX = "index";
    private static final String MEMORY_USAGE_BEFORE_GC = "memoryUsageBeforeGc";
    private static final String MEMORY_USAGE_AFTER_GC = "memoryUsageAfterGc";
    private static final String USAGE_BEFORE_GC = "usageBeforeGc";
    private static final String USAGE_AFTER_GC = "usageAfterGc";
    private static final String START_TIME = "startTime";

    ExtendedGarbageCollectorMBean(String gcName) {
        super(PlatformMBeanUtil.getObjectNameStringWithNameKey("java.lang:type=GarbageCollector", gcName));
    }

    GcInfo getLastGcInfo() {
        GcInfo gcInfo = null;
        CompositeData cd = (CompositeData)this.getAttribute(LAST_GC_INFO_ATTRIBUTE);
        if (cd != null) {
            try {
                long id = cd.containsKey(INDEX) ? ((Long)cd.get(INDEX)).longValue() : ((Long)cd.get(ID)).longValue();
                long endTime = (Long)cd.get(END_TIME);
                long startTime = (Long)cd.get(START_TIME);
                long duration = cd.containsKey(DURATION) ? (Long)cd.get(DURATION) : endTime - startTime;
                TabularData beforeGc = cd.containsKey(USAGE_BEFORE_GC) ? (TabularData)cd.get(USAGE_BEFORE_GC) : (TabularData)cd.get(MEMORY_USAGE_BEFORE_GC);
                HashMap<String, MemoryUsage> beforeGcMap = new HashMap<String, MemoryUsage>();
                for (Object value : beforeGc.values()) {
                    CompositeData cdValue = (CompositeData)value;
                    String key = (String)cdValue.get("key");
                    CompositeData usageCd = (CompositeData)cdValue.get("value");
                    MemoryUsage usage = MemoryUsage.from(usageCd);
                    beforeGcMap.put(key, usage);
                }
                TabularData afterGc = cd.containsKey(USAGE_AFTER_GC) ? (TabularData)cd.get(USAGE_AFTER_GC) : (TabularData)cd.get(MEMORY_USAGE_AFTER_GC);
                HashMap<String, MemoryUsage> afterGcMap = new HashMap<String, MemoryUsage>();
                for (Object value : afterGc.values()) {
                    CompositeData cdValue = (CompositeData)value;
                    String key = (String)cdValue.get("key");
                    CompositeData usageCd = (CompositeData)cdValue.get("value");
                    MemoryUsage usage = MemoryUsage.from(usageCd);
                    afterGcMap.put(key, usage);
                }
                gcInfo = new GcInfo(duration, endTime, id, afterGcMap, beforeGcMap, startTime);
            }
            catch (InvalidKeyException ike) {
                PlatformMBeanLogger.ROOT_LOGGER.debugf(ike, "CompositeData %s has an unexpected structure; unable to create GcInfo", cd);
            }
        }
        return gcInfo;
    }

    static class GcInfo {
        private final long duration;
        private final long endTime;
        private final long id;
        private final Map<String, MemoryUsage> memoryUsageAfterGc;
        private final Map<String, MemoryUsage> memoryUsageBeforeGc;
        private final long startTime;

        GcInfo(long duration, long endTime, long id, Map<String, MemoryUsage> memoryUsageAfterGc, Map<String, MemoryUsage> memoryUsageBeforeGc, long startTime) {
            this.duration = duration;
            this.endTime = endTime;
            this.id = id;
            this.memoryUsageAfterGc = memoryUsageAfterGc;
            this.memoryUsageBeforeGc = memoryUsageBeforeGc;
            this.startTime = startTime;
        }

        long getDuration() {
            return this.duration;
        }

        long getEndTime() {
            return this.endTime;
        }

        long getId() {
            return this.id;
        }

        Map<String, MemoryUsage> getMemoryUsageAfterGc() {
            return this.memoryUsageAfterGc;
        }

        Map<String, MemoryUsage> getMemoryUsageBeforeGc() {
            return this.memoryUsageBeforeGc;
        }

        long getStartTime() {
            return this.startTime;
        }
    }
}

