/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.admin;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.kafka.admin.ClusterDescription;
import io.vertx.kafka.admin.Config;
import io.vertx.kafka.admin.ConsumerGroupDescription;
import io.vertx.kafka.admin.ConsumerGroupListing;
import io.vertx.kafka.admin.DescribeClusterOptions;
import io.vertx.kafka.admin.DescribeConsumerGroupsOptions;
import io.vertx.kafka.admin.DescribeTopicsOptions;
import io.vertx.kafka.admin.ListConsumerGroupOffsetsOptions;
import io.vertx.kafka.admin.ListOffsetsResultInfo;
import io.vertx.kafka.admin.NewPartitions;
import io.vertx.kafka.admin.NewTopic;
import io.vertx.kafka.admin.OffsetSpec;
import io.vertx.kafka.admin.TopicDescription;
import io.vertx.kafka.admin.impl.KafkaAdminClientImpl;
import io.vertx.kafka.client.common.ConfigResource;
import io.vertx.kafka.client.common.TopicPartition;
import io.vertx.kafka.client.consumer.OffsetAndMetadata;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DeletedRecords;
import org.apache.kafka.clients.admin.LogDirDescription;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;

@VertxGen
public interface KafkaAdminClient {
    @GenIgnore
    public static KafkaAdminClient create(Vertx vertx, AdminClient adminClient) {
        return new KafkaAdminClientImpl(vertx, adminClient);
    }

    public static KafkaAdminClient create(Vertx vertx, Map<String, String> config) {
        return KafkaAdminClient.create(vertx, AdminClient.create(new HashMap<String, String>(config)));
    }

    @GenIgnore
    public static KafkaAdminClient create(Vertx vertx, Properties config) {
        return KafkaAdminClient.create(vertx, AdminClient.create((Properties)config));
    }

    public void listTopics(Handler<AsyncResult<Set<String>>> var1);

    public Future<Set<String>> listTopics();

    public void describeTopics(List<String> var1, Handler<AsyncResult<Map<String, TopicDescription>>> var2);

    public void describeTopics(List<String> var1, DescribeTopicsOptions var2, Handler<AsyncResult<Map<String, TopicDescription>>> var3);

    public Future<Map<String, TopicDescription>> describeTopics(List<String> var1);

    public Future<Map<String, TopicDescription>> describeTopics(List<String> var1, DescribeTopicsOptions var2);

    public void createTopics(List<NewTopic> var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> createTopics(List<NewTopic> var1);

    public void deleteTopics(List<String> var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> deleteTopics(List<String> var1);

    public void createPartitions(Map<String, NewPartitions> var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> createPartitions(Map<String, NewPartitions> var1);

    @GenIgnore
    public void describeConfigs(List<ConfigResource> var1, Handler<AsyncResult<Map<ConfigResource, Config>>> var2);

    @GenIgnore
    public Future<Map<ConfigResource, Config>> describeConfigs(List<ConfigResource> var1);

    @GenIgnore
    public void alterConfigs(Map<ConfigResource, Config> var1, Handler<AsyncResult<Void>> var2);

    @GenIgnore
    public Future<Void> alterConfigs(Map<ConfigResource, Config> var1);

    public void listConsumerGroups(Handler<AsyncResult<List<ConsumerGroupListing>>> var1);

    public Future<List<ConsumerGroupListing>> listConsumerGroups();

    public void describeConsumerGroups(List<String> var1, Handler<AsyncResult<Map<String, ConsumerGroupDescription>>> var2);

    public Future<Map<String, ConsumerGroupDescription>> describeConsumerGroups(List<String> var1);

    public void describeConsumerGroups(List<String> var1, DescribeConsumerGroupsOptions var2, Handler<AsyncResult<Map<String, ConsumerGroupDescription>>> var3);

    public Future<Map<String, ConsumerGroupDescription>> describeConsumerGroups(List<String> var1, DescribeConsumerGroupsOptions var2);

    public void describeCluster(Handler<AsyncResult<ClusterDescription>> var1);

    public Future<ClusterDescription> describeCluster();

    public void describeCluster(DescribeClusterOptions var1, Handler<AsyncResult<ClusterDescription>> var2);

    public Future<ClusterDescription> describeCluster(DescribeClusterOptions var1);

    @GenIgnore
    public void describeLogDirs(List<Integer> var1, Handler<AsyncResult<Map<Integer, Map<String, LogDirDescription>>>> var2);

    @GenIgnore
    public Future<Map<Integer, Map<String, LogDirDescription>>> describeLogDirs(List<Integer> var1);

    @GenIgnore
    public void deleteRecords(Map<TopicPartition, RecordsToDelete> var1, Handler<AsyncResult<Map<TopicPartition, DeletedRecords>>> var2);

    @GenIgnore
    public Future<Map<TopicPartition, DeletedRecords>> deleteRecords(Map<TopicPartition, RecordsToDelete> var1);

    public void deleteConsumerGroups(List<String> var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> deleteConsumerGroups(List<String> var1);

    @GenIgnore
    public void listConsumerGroupOffsets(String var1, ListConsumerGroupOffsetsOptions var2, Handler<AsyncResult<Map<TopicPartition, OffsetAndMetadata>>> var3);

    @GenIgnore
    public Future<Map<TopicPartition, OffsetAndMetadata>> listConsumerGroupOffsets(String var1, ListConsumerGroupOffsetsOptions var2);

    @GenIgnore
    default public void listConsumerGroupOffsets(String groupId, Handler<AsyncResult<Map<TopicPartition, OffsetAndMetadata>>> completionHandler) {
        this.listConsumerGroupOffsets(groupId, new ListConsumerGroupOffsetsOptions(), completionHandler);
    }

    @GenIgnore
    default public Future<Map<TopicPartition, OffsetAndMetadata>> listConsumerGroupOffsets(String groupId) {
        return this.listConsumerGroupOffsets(groupId, new ListConsumerGroupOffsetsOptions());
    }

    public void deleteConsumerGroupOffsets(String var1, Set<TopicPartition> var2, Handler<AsyncResult<Void>> var3);

    public Future<Void> deleteConsumerGroupOffsets(String var1, Set<TopicPartition> var2);

    @GenIgnore
    public void alterConsumerGroupOffsets(String var1, Map<TopicPartition, OffsetAndMetadata> var2, Handler<AsyncResult<Void>> var3);

    @GenIgnore
    public Future<Void> alterConsumerGroupOffsets(String var1, Map<TopicPartition, OffsetAndMetadata> var2);

    @GenIgnore
    public void listOffsets(Map<TopicPartition, OffsetSpec> var1, Handler<AsyncResult<Map<TopicPartition, ListOffsetsResultInfo>>> var2);

    @GenIgnore
    public Future<Map<TopicPartition, ListOffsetsResultInfo>> listOffsets(Map<TopicPartition, OffsetSpec> var1);

    @GenIgnore(value={"permitted-type"})
    public void describeAcls(AclBindingFilter var1, Handler<AsyncResult<List<AclBinding>>> var2);

    @GenIgnore(value={"permitted-type"})
    public Future<List<AclBinding>> describeAcls(AclBindingFilter var1);

    @GenIgnore(value={"permitted-type"})
    public void createAcls(List<AclBinding> var1, Handler<AsyncResult<List<AclBinding>>> var2);

    @GenIgnore(value={"permitted-type"})
    public Future<List<AclBinding>> createAcls(List<AclBinding> var1);

    @GenIgnore(value={"permitted-type"})
    public void deleteAcls(List<AclBindingFilter> var1, Handler<AsyncResult<List<AclBinding>>> var2);

    @GenIgnore(value={"permitted-type"})
    public Future<List<AclBinding>> deleteAcls(List<AclBindingFilter> var1);

    public void close(Handler<AsyncResult<Void>> var1);

    public Future<Void> close();

    public void close(long var1, Handler<AsyncResult<Void>> var3);

    public Future<Void> close(long var1);
}

