/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transaction;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.transaction.xa.Xid;
import org.infinispan.client.hotrod.impl.Util;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.operations.ManagerOperationsFactory;
import org.infinispan.client.hotrod.impl.transaction.TransactionTable;
import org.infinispan.client.hotrod.impl.transport.netty.OperationDispatcher;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

abstract class AbstractTransactionTable
implements TransactionTable {
    private static final Log log = LogFactory.getLog(AbstractTransactionTable.class, Log.class);
    private final long timeout;
    private volatile ManagerOperationsFactory operationFactory;
    private volatile OperationDispatcher dispatcher;

    AbstractTransactionTable(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public final void start(ManagerOperationsFactory operationFactory, OperationDispatcher dispatcher) {
        this.operationFactory = operationFactory;
        this.dispatcher = dispatcher;
    }

    ManagerOperationsFactory assertStartedAndReturnFactory() {
        ManagerOperationsFactory tmp = this.operationFactory;
        if (tmp == null) {
            throw log.transactionTableNotStarted();
        }
        return tmp;
    }

    final long getTimeout() {
        return this.timeout;
    }

    int completeTransaction(Xid xid, boolean commit) {
        try {
            ManagerOperationsFactory factory = this.assertStartedAndReturnFactory();
            HotRodOperation<Integer> operation = factory.newCompleteTransactionOperation(xid, commit);
            return Util.await(this.dispatcher.execute(operation));
        }
        catch (Exception e) {
            log.debug("Exception while commit/rollback.", e);
            return 6;
        }
    }

    void forgetTransaction(Xid xid) {
        block2: {
            try {
                ManagerOperationsFactory factory = this.assertStartedAndReturnFactory();
                HotRodOperation<Void> operation = factory.newForgetTransactionOperation(xid);
                this.dispatcher.execute(operation);
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block2;
                log.tracef(e, "Exception in forget transaction xid=%s", xid);
            }
        }
    }

    CompletionStage<Collection<Xid>> fetchPreparedTransactions() {
        try {
            ManagerOperationsFactory factory = this.assertStartedAndReturnFactory();
            HotRodOperation<Collection<Xid>> operation = factory.newRecoveryOperation();
            return this.dispatcher.execute(operation);
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace("Exception while fetching prepared transactions", e);
            }
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
    }
}

