/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchParallelWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexContext;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.query.ElasticsearchSearchQuery;
import org.hibernate.search.backend.elasticsearch.search.query.ElasticsearchSearchRequestTransformer;
import org.hibernate.search.backend.elasticsearch.search.query.ElasticsearchSearchResult;
import org.hibernate.search.backend.elasticsearch.search.query.ElasticsearchSearchScroll;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchLoadableSearchResult;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchRequestTransformerContextImpl;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchResultImpl;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchScrollImpl;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.factory.impl.ElasticsearchWorkFactory;
import org.hibernate.search.backend.elasticsearch.work.impl.AbstractNonBulkableWork;
import org.hibernate.search.backend.elasticsearch.work.impl.CountWork;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchSearchResultExtractor;
import org.hibernate.search.backend.elasticsearch.work.impl.ExplainWork;
import org.hibernate.search.backend.elasticsearch.work.impl.SearchWork;
import org.hibernate.search.backend.elasticsearch.work.result.impl.ExplainResult;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.types.converter.runtime.ToDocumentValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.backend.work.execution.OperationSubmitter;
import org.hibernate.search.engine.common.dsl.spi.DslExtensionState;
import org.hibernate.search.engine.search.loading.spi.SearchLoadingContext;
import org.hibernate.search.engine.search.query.SearchQuery;
import org.hibernate.search.engine.search.query.SearchQueryExtension;
import org.hibernate.search.engine.search.query.spi.AbstractSearchQuery;
import org.hibernate.search.engine.search.timeout.spi.TimeoutManager;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchSearchQueryImpl<H>
extends AbstractSearchQuery<H, ElasticsearchSearchResult<H>>
implements ElasticsearchSearchQuery<H> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ElasticsearchWorkFactory workFactory;
    private final ElasticsearchParallelWorkOrchestrator queryOrchestrator;
    private final ElasticsearchSearchIndexScope<?> scope;
    private final BackendSessionContext sessionContext;
    private final SearchLoadingContext<?> loadingContext;
    private final Set<String> routingKeys;
    private final JsonObject payload;
    private final ElasticsearchSearchRequestTransformer requestTransformer;
    private final ElasticsearchSearchResultExtractor<ElasticsearchLoadableSearchResult<H>> searchResultExtractor;
    private final Integer scrollTimeout;
    private final Long totalHitCountThreshold;
    private final int maxResultWindow;
    private TimeoutManager timeoutManager;

    ElasticsearchSearchQueryImpl(ElasticsearchWorkFactory workFactory, ElasticsearchParallelWorkOrchestrator queryOrchestrator, ElasticsearchSearchIndexScope<?> scope, BackendSessionContext sessionContext, SearchLoadingContext<?> loadingContext, Set<String> routingKeys, JsonObject payload, ElasticsearchSearchRequestTransformer requestTransformer, ElasticsearchSearchResultExtractor<ElasticsearchLoadableSearchResult<H>> searchResultExtractor, TimeoutManager timeoutManager, Integer scrollTimeout, Long totalHitCountThreshold) {
        this.workFactory = workFactory;
        this.queryOrchestrator = queryOrchestrator;
        this.scope = scope;
        this.sessionContext = sessionContext;
        this.loadingContext = loadingContext;
        this.routingKeys = routingKeys;
        this.payload = payload;
        this.requestTransformer = requestTransformer;
        this.searchResultExtractor = searchResultExtractor;
        this.timeoutManager = timeoutManager;
        this.scrollTimeout = scrollTimeout;
        this.totalHitCountThreshold = totalHitCountThreshold;
        this.maxResultWindow = scope.maxResultWindow();
    }

    public String queryString() {
        return this.payload.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.queryString() + "]";
    }

    public <Q> Q extension(SearchQueryExtension<Q, H> extension) {
        return (Q)DslExtensionState.returnIfSupported(extension, (Optional)extension.extendOptional((SearchQuery)this, this.loadingContext));
    }

    public ElasticsearchSearchResult<H> fetch(Integer offset, Integer limit) {
        this.timeoutManager.start();
        Integer defaultedLimit = this.defaultedLimit(limit, offset);
        AbstractNonBulkableWork work = this.searchWorkBuilder().paging(defaultedLimit, offset).totalHitCountThreshold(this.totalHitCountThreshold).build();
        ElasticsearchSearchResultImpl result = ((ElasticsearchLoadableSearchResult)Futures.unwrappedExceptionJoin(this.queryOrchestrator.submit(work, OperationSubmitter.blocking()))).loadBlocking();
        this.timeoutManager.stop();
        if (limit == null && result.total().hitCountLowerBound() > (long)defaultedLimit.intValue()) {
            log.defaultedLimitedHits(defaultedLimit, result.total().hitCountLowerBound());
        }
        return result;
    }

    public List<H> fetchHits(Integer offset, Integer limit) {
        this.timeoutManager.start();
        Integer defaultedLimit = this.defaultedLimit(limit, offset);
        AbstractNonBulkableWork work = this.searchWorkBuilder().paging(defaultedLimit, offset).disableTrackTotalHits().build();
        ElasticsearchSearchResultImpl result = ((ElasticsearchLoadableSearchResult)Futures.unwrappedExceptionJoin(this.queryOrchestrator.submit(work, OperationSubmitter.blocking()))).loadBlocking();
        this.timeoutManager.stop();
        if (limit == null && result.total().hitCountLowerBound() > (long)defaultedLimit.intValue()) {
            log.defaultedLimitedHits(defaultedLimit, result.total().hitCountLowerBound());
        }
        return result.hits();
    }

    public long fetchTotalHitCount() {
        this.timeoutManager.start();
        JsonObject filteredPayload = new JsonObject();
        Optional querySubTree = JsonAccessor.root().property("query").asObject().get(this.payload);
        if (querySubTree.isPresent()) {
            filteredPayload.add("query", (JsonElement)querySubTree.get());
        }
        CountWork.Builder builder = this.workFactory.count();
        for (ElasticsearchSearchIndexContext index : this.scope.indexes()) {
            builder.index(index.names().read());
        }
        builder.query(filteredPayload).routingKeys(this.routingKeys).deadline(this.timeoutManager.hardDeadlineOrNull()).requestTransformer((Function)ElasticsearchSearchRequestTransformerContextImpl.createTransformerFunction(this.requestTransformer));
        CountWork work = builder.build();
        Long result = (Long)Futures.unwrappedExceptionJoin(this.queryOrchestrator.submit(work, OperationSubmitter.blocking()));
        this.timeoutManager.stop();
        return result;
    }

    public ElasticsearchSearchScroll<H> scroll(int chunkSize) {
        String scrollTimeoutString = this.scrollTimeout + "s";
        SearchWork.Builder<ElasticsearchLoadableSearchResult<H>> firstScroll = this.searchWorkBuilder().scrolling(chunkSize, scrollTimeoutString);
        return new ElasticsearchSearchScrollImpl<H>(this.queryOrchestrator, this.workFactory, this.searchResultExtractor, scrollTimeoutString, firstScroll, this.timeoutManager);
    }

    @Override
    public JsonObject explain(Object id) {
        Contracts.assertNotNull((Object)id, (String)"id");
        Map<String, ElasticsearchSearchIndexContext> mappedTypeNameToIndex = this.scope.mappedTypeNameToIndex();
        if (mappedTypeNameToIndex.size() != 1) {
            throw log.explainRequiresTypeName(mappedTypeNameToIndex.keySet());
        }
        return this.doExplain(mappedTypeNameToIndex.values().iterator().next(), id);
    }

    @Override
    public JsonObject explain(String typeName, Object id) {
        Contracts.assertNotNull((Object)typeName, (String)"typeName");
        Contracts.assertNotNull((Object)id, (String)"id");
        Map<String, ElasticsearchSearchIndexContext> mappedTypeNameToIndex = this.scope.mappedTypeNameToIndex();
        ElasticsearchSearchIndexContext index = mappedTypeNameToIndex.get(typeName);
        if (index == null) {
            throw log.explainRequiresTypeTargetedByQuery(mappedTypeNameToIndex.keySet(), typeName);
        }
        return this.doExplain(index, id);
    }

    private SearchWork.Builder<ElasticsearchLoadableSearchResult<H>> searchWorkBuilder() {
        SearchWork.Builder<ElasticsearchLoadableSearchResult<H>> builder = this.workFactory.search(this.payload, this.searchResultExtractor);
        for (ElasticsearchSearchIndexContext index : this.scope.indexes()) {
            builder.index(index.names().read());
        }
        builder.routingKeys(this.routingKeys).deadline(this.timeoutManager.deadlineOrNull(), this.timeoutManager.hasHardTimeout()).requestTransformer((Function)ElasticsearchSearchRequestTransformerContextImpl.createTransformerFunction(this.requestTransformer));
        return builder;
    }

    private Integer defaultedLimit(Integer limit, Integer offset) {
        if (limit != null) {
            return limit;
        }
        int maxLimitThatElasticsearchWillAccept = this.maxResultWindow;
        if (offset != null) {
            maxLimitThatElasticsearchWillAccept -= offset.intValue();
        }
        return maxLimitThatElasticsearchWillAccept;
    }

    private JsonObject doExplain(ElasticsearchSearchIndexContext index, Object id) {
        JsonObject queryOnlyPayload = new JsonObject();
        JsonElement query = this.payload.get("query");
        if (query != null) {
            queryOnlyPayload.add("query", query);
        }
        URLEncodedString elasticsearchId = this.toElasticsearchId(index, id);
        URLEncodedString indexName = index.names().read();
        ExplainWork work = ((ExplainWork.Builder)this.workFactory.explain(indexName, elasticsearchId, queryOnlyPayload).routingKeys(this.routingKeys).requestTransformer((Function)ElasticsearchSearchRequestTransformerContextImpl.createTransformerFunction(this.requestTransformer))).build();
        ExplainResult explainResult = (ExplainResult)Futures.unwrappedExceptionJoin(this.queryOrchestrator.submit(work, OperationSubmitter.blocking()));
        return explainResult.getJsonObject();
    }

    private URLEncodedString toElasticsearchId(ElasticsearchSearchIndexContext index, Object id) {
        DslConverter converter = index.identifier().mappingDslConverter();
        ToDocumentValueConvertContext convertContext = this.scope.toDocumentValueConvertContext();
        String documentId = (String)converter.unknownTypeToDocumentValue(id, convertContext);
        return URLEncodedString.fromString(this.scope.documentIdHelper().toElasticsearchId(this.sessionContext.tenantIdentifier(), documentId));
    }

    public void failAfter(long timeout, TimeUnit timeUnit) {
        this.timeoutManager = this.scope.createTimeoutManager(timeout, timeUnit, true);
    }
}

