/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.reporting.impl.ElasticsearchSearchHints;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.AbstractElasticsearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionExtractionHelper;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionTransformContext;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.projection.spi.ProjectionTypeKeys;

public class ElasticsearchIdProjection<I>
extends AbstractElasticsearchProjection<I>
implements ElasticsearchSearchProjection.Extractor<String, I> {
    private final ProjectionExtractionHelper<String> extractionHelper;
    private final ProjectionConverter<String, ? extends I> converter;

    ElasticsearchIdProjection(ElasticsearchSearchIndexScope<?> scope, ProjectionExtractionHelper<String> extractionHelper, ProjectionConverter<String, ? extends I> converter) {
        super(scope);
        this.extractionHelper = extractionHelper;
        this.converter = converter;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public ElasticsearchSearchProjection.Extractor<?, I> request(JsonObject requestBody, ProjectionRequestContext context) {
        context.checkNotNested(ProjectionTypeKeys.ID, ElasticsearchSearchHints.INSTANCE.idProjectionNestingNotSupportedHint());
        this.extractionHelper.request(requestBody, context);
        return this;
    }

    @Override
    public String extract(ProjectionHitMapper<?> projectionHitMapper, JsonObject hit, JsonObject source, ProjectionExtractContext context) {
        return this.extractionHelper.extract(hit, context);
    }

    @Override
    public I transform(LoadingResult<?> loadingResult, String extractedData, ProjectionTransformContext context) {
        return (I)this.converter.fromDocumentValue((Object)extractedData, context.fromDocumentValueConvertContext());
    }
}

