/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.BeanNameELResolver;
import jakarta.el.BeanNameResolver;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.el.EvaluationListener;
import jakarta.el.ExpressionFactory;
import jakarta.el.StandardELContext;
import jakarta.el.ValueExpression;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

public class ELManager {
    private static final String EL_BC22_PROPERTY = "org.wildfly.el.bc2.2";
    static final Properties properties = new Properties();
    private static volatile ExpressionFactory exprFactory = null;
    private StandardELContext elContext;

    private static void setupProperties() {
        boolean bc22Enabled = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.getBoolean(ELManager.EL_BC22_PROPERTY);
            }
        });
        if (bc22Enabled) {
            properties.setProperty("jakarta.el.bc2.2", "true");
        }
    }

    public static ExpressionFactory getExpressionFactory() {
        if (exprFactory == null) {
            ELManager.createExpessionFactory();
        }
        return exprFactory;
    }

    private static synchronized void createExpessionFactory() {
        if (exprFactory == null) {
            exprFactory = ExpressionFactory.newInstance(properties);
        }
    }

    public StandardELContext getELContext() {
        if (this.elContext == null) {
            this.elContext = new StandardELContext(ELManager.getExpressionFactory());
        }
        return this.elContext;
    }

    public ELContext setELContext(ELContext context) {
        StandardELContext prevELContext = this.elContext;
        this.elContext = new StandardELContext(context);
        return prevELContext;
    }

    public void addBeanNameResolver(BeanNameResolver beanNameResolver) {
        this.getELContext().addELResolver(new BeanNameELResolver(beanNameResolver));
    }

    public void addELResolver(ELResolver elResolver) {
        this.getELContext().addELResolver(elResolver);
    }

    public void mapFunction(String prefix, String function, Method method) {
        this.getELContext().getFunctionMapper().mapFunction(prefix, function, method);
    }

    public void setVariable(String variable, ValueExpression expression) {
        this.getELContext().getVariableMapper().setVariable(variable, expression);
    }

    public void importStatic(String staticMemberName) throws ELException {
        this.getELContext().getImportHandler().importStatic(staticMemberName);
    }

    public void importClass(String className) throws ELException {
        this.getELContext().getImportHandler().importClass(className);
    }

    public void importPackage(String packageName) {
        this.getELContext().getImportHandler().importPackage(packageName);
    }

    public Object defineBean(String name, Object bean) {
        Object previousBean = this.getELContext().getBeans().get(name);
        this.getELContext().getBeans().put(name, bean);
        return previousBean;
    }

    public void addEvaluationListener(EvaluationListener listener) {
        this.getELContext().addEvaluationListener(listener);
    }

    static {
        ELManager.setupProperties();
    }
}

