/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.ErrorManager;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

class SuffixRotator {
    static final SuffixRotator EMPTY = new SuffixRotator(AccessController.getContext(), "", "", "", CompressionType.NONE);
    private final AccessControlContext acc;
    private final String originalSuffix;
    private final String datePattern;
    private final SimpleDateFormat formatter;
    private final String compressionSuffix;
    private final CompressionType compressionType;

    private SuffixRotator(AccessControlContext acc, String originalSuffix, String datePattern, String compressionSuffix, CompressionType compressionType) {
        this.acc = acc;
        this.originalSuffix = originalSuffix;
        this.datePattern = datePattern;
        this.compressionSuffix = compressionSuffix;
        this.compressionType = compressionType;
        this.formatter = datePattern.isEmpty() ? null : new SimpleDateFormat(datePattern);
    }

    static SuffixRotator parse(AccessControlContext acc, String suffix) {
        if (suffix == null || suffix.isEmpty()) {
            return EMPTY;
        }
        String compressionSuffix = "";
        String datePattern = "";
        CompressionType compressionType = CompressionType.NONE;
        String lSuffix = suffix.toLowerCase(Locale.ROOT);
        int compressionIndex = lSuffix.indexOf(".gz");
        if (compressionIndex != -1) {
            compressionSuffix = suffix.substring(compressionIndex);
            datePattern = suffix.substring(0, compressionIndex);
            compressionType = CompressionType.GZIP;
        } else {
            compressionIndex = lSuffix.indexOf(".zip");
            if (compressionIndex != -1) {
                compressionSuffix = suffix.substring(compressionIndex);
                datePattern = suffix.substring(0, compressionIndex);
                compressionType = CompressionType.ZIP;
            }
        }
        if (compressionSuffix.isEmpty() && datePattern.isEmpty()) {
            return new SuffixRotator(acc, suffix, suffix, "", CompressionType.NONE);
        }
        return new SuffixRotator(acc, suffix, datePattern, compressionSuffix, compressionType);
    }

    String getDatePattern() {
        return this.datePattern;
    }

    String getCompressionSuffix() {
        return this.compressionSuffix;
    }

    CompressionType getCompressionType() {
        return this.compressionType;
    }

    void rotate(ErrorManager errorManager, Path source, String suffix) {
        Path target = Paths.get(source + suffix + this.compressionSuffix, new String[0]);
        if (this.compressionType == CompressionType.GZIP) {
            try {
                this.archiveGzip(source, target);
                this.deleteFile(source);
            }
            catch (Exception e) {
                errorManager.error(String.format("Failed to compress %s to %s. Compressed file may be left on the filesystem corrupted.", source, target), e, 1);
            }
        } else if (this.compressionType == CompressionType.ZIP) {
            try {
                this.archiveZip(source, target);
                this.deleteFile(source);
            }
            catch (Exception e) {
                errorManager.error(String.format("Failed to compress %s to %s. Compressed file may be left on the filesystem corrupted.", source, target), e, 1);
            }
        } else {
            this.move(errorManager, source, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rotate(ErrorManager errorManager, Path source, int maxBackupIndex) {
        if (this.formatter == null) {
            this.rotate(errorManager, source, "", maxBackupIndex);
        } else {
            String suffix;
            SimpleDateFormat simpleDateFormat = this.formatter;
            synchronized (simpleDateFormat) {
                suffix = this.formatter.format(new Date());
            }
            this.rotate(errorManager, source, suffix, maxBackupIndex);
        }
    }

    void rotate(ErrorManager errorManager, Path source, String suffix, int maxBackupIndex) {
        if (maxBackupIndex > 0) {
            String rotationSuffix = suffix == null ? "" : suffix;
            String fileWithSuffix = source.toAbsolutePath() + rotationSuffix;
            Path lastFile = Paths.get(fileWithSuffix + "." + maxBackupIndex + this.compressionSuffix, new String[0]);
            try {
                this.deleteFile(lastFile);
            }
            catch (Exception e) {
                errorManager.error(String.format("Failed to delete file %s", lastFile), e, 0);
            }
            for (int i = maxBackupIndex - 1; i >= 1; --i) {
                Path src = Paths.get(fileWithSuffix + "." + i + this.compressionSuffix, new String[0]);
                if (!this.fileExists(src)) continue;
                Path target = Paths.get(fileWithSuffix + "." + (i + 1) + this.compressionSuffix, new String[0]);
                this.move(errorManager, src, target);
            }
            this.rotate(errorManager, source, rotationSuffix + ".1");
        } else if (suffix != null && !suffix.isEmpty()) {
            this.rotate(errorManager, source, suffix);
        }
    }

    public String toString() {
        return this.originalSuffix;
    }

    private void move(ErrorManager errorManager, Path src, Path target) {
        if (System.getSecurityManager() == null) {
            try {
                Files.move(src, target, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception e) {
                errorManager.error(String.format("Failed to move file %s to %s.", src, target), e, 0);
            }
        } else {
            AccessController.doPrivileged(new MoveFileAction(errorManager, src, target), this.acc);
        }
    }

    private void archiveGzip(Path source, Path target) throws IOException {
        byte[] buff = new byte[512];
        try (GZIPOutputStream out = new GZIPOutputStream(this.newOutputStream(target), true);){
            try (InputStream in = this.newInputStream(source);){
                int len;
                while ((len = in.read(buff)) != -1) {
                    out.write(buff, 0, len);
                }
            }
            out.finish();
        }
    }

    private void archiveZip(Path source, Path target) throws IOException {
        byte[] buff = new byte[512];
        try (ZipOutputStream out = new ZipOutputStream(this.newOutputStream(target), StandardCharsets.UTF_8);){
            ZipEntry entry = new ZipEntry(source.getFileName().toString());
            out.putNextEntry(entry);
            try (InputStream in = this.newInputStream(source);){
                int len;
                while ((len = in.read(buff)) != -1) {
                    out.write(buff, 0, len);
                }
            }
            out.closeEntry();
        }
    }

    private boolean deleteFile(Path path) throws IOException {
        if (System.getSecurityManager() == null) {
            return Files.deleteIfExists(path);
        }
        return AccessController.doPrivileged(new DeleteFileAction(path), this.acc);
    }

    private boolean fileExists(Path file) {
        if (System.getSecurityManager() == null) {
            return Files.exists(file, new LinkOption[0]);
        }
        return AccessController.doPrivileged(new FileExistsAction(file), this.acc);
    }

    private InputStream newInputStream(Path file) throws IOException {
        if (System.getSecurityManager() == null) {
            return Files.newInputStream(file, new OpenOption[0]);
        }
        return AccessController.doPrivileged(new InputStreamAction(file), this.acc);
    }

    private OutputStream newOutputStream(Path file) throws IOException {
        if (System.getSecurityManager() == null) {
            return Files.newOutputStream(file, new OpenOption[0]);
        }
        return AccessController.doPrivileged(new OutputStreamAction(file), this.acc);
    }

    private static class OutputStreamAction
    implements PrivilegedAction<OutputStream> {
        private final Path file;

        private OutputStreamAction(Path file) {
            this.file = file;
        }

        @Override
        public OutputStream run() {
            try {
                return Files.newOutputStream(this.file, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static class InputStreamAction
    implements PrivilegedAction<InputStream> {
        private final Path file;

        private InputStreamAction(Path file) {
            this.file = file;
        }

        @Override
        public InputStream run() {
            try {
                return Files.newInputStream(this.file, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static class FileExistsAction
    implements PrivilegedAction<Boolean> {
        private final Path file;

        private FileExistsAction(Path file) {
            this.file = file;
        }

        @Override
        public Boolean run() {
            return Files.exists(this.file, new LinkOption[0]);
        }
    }

    private static class MoveFileAction
    implements PrivilegedAction<Path> {
        private final ErrorManager errorManager;
        private final Path source;
        private final Path target;

        private MoveFileAction(ErrorManager errorManager, Path source, Path target) {
            this.errorManager = errorManager;
            this.source = source;
            this.target = target;
        }

        @Override
        public Path run() {
            try {
                return Files.move(this.source, this.target, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception e) {
                this.errorManager.error(String.format("Failed to move file %s to %s.", this.source, this.target), e, 0);
                return null;
            }
        }
    }

    private static class DeleteFileAction
    implements PrivilegedAction<Boolean> {
        private final Path file;

        private DeleteFileAction(Path file) {
            this.file = file;
        }

        @Override
        public Boolean run() {
            try {
                return Files.deleteIfExists(this.file);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public static enum CompressionType {
        NONE,
        GZIP,
        ZIP;

    }
}

