/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.mirror;

import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.mirror.MirrorController;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorControllerSource;

public class AMQPMirrorControllerAggregation
implements MirrorController,
ActiveMQComponent {
    List<AMQPMirrorControllerSource> partitions = new ArrayList<AMQPMirrorControllerSource>();

    public void addPartition(AMQPMirrorControllerSource partition) {
        this.partitions.add(partition);
    }

    public void removeParition(AMQPMirrorControllerSource partition) {
        this.partitions.remove(partition);
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public String getRemoteMirrorId() {
        if (this.partitions != null && this.partitions.size() > 0) {
            return this.partitions.get(0).getRemoteMirrorId();
        }
        throw new IllegalStateException();
    }

    public boolean isStarted() {
        return false;
    }

    public List<AMQPMirrorControllerSource> getPartitions() {
        return this.partitions;
    }

    public void preAcknowledge(Transaction tx, MessageReference ref, AckReason reason) throws Exception {
        for (MirrorController mirrorController : this.partitions) {
            mirrorController.preAcknowledge(tx, ref, reason);
        }
    }

    public void addAddress(AddressInfo addressInfo) throws Exception {
        for (MirrorController mirrorController : this.partitions) {
            mirrorController.addAddress(addressInfo);
        }
    }

    public void deleteAddress(AddressInfo addressInfo) throws Exception {
        for (MirrorController mirrorController : this.partitions) {
            mirrorController.deleteAddress(addressInfo);
        }
    }

    public void createQueue(QueueConfiguration queueConfiguration) throws Exception {
        for (MirrorController mirrorController : this.partitions) {
            mirrorController.createQueue(queueConfiguration);
        }
    }

    public void deleteQueue(SimpleString addressName, SimpleString queueName) throws Exception {
        for (MirrorController mirrorController : this.partitions) {
            mirrorController.deleteQueue(addressName, queueName);
        }
    }

    public void sendMessage(Transaction tx, Message message, RoutingContext context) {
        for (MirrorController mirrorController : this.partitions) {
            mirrorController.sendMessage(tx, message, context);
        }
    }

    public void postAcknowledge(MessageReference ref, AckReason reason) throws Exception {
        for (MirrorController mirrorController : this.partitions) {
            mirrorController.postAcknowledge(ref, reason);
        }
    }
}

