/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.api.configuration;

import jakarta.xml.ws.BindingProvider;
import org.jboss.ws.api.configuration.AbstractClientFeature;
import org.jboss.ws.api.configuration.ClientConfigUtil;
import org.jboss.ws.api.configuration.ClientConfigurer;

public final class ClientConfigFeature
extends AbstractClientFeature {
    private ClientConfigurer configurer = ClientConfigUtil.resolveClientConfigurer();
    private String configFile;
    private String configName;
    private boolean configureProperties;

    public ClientConfigFeature() {
        super(ClientConfigFeature.class.getName());
    }

    public ClientConfigFeature(String configFile, String configName) {
        this(configFile, configName, false);
    }

    public ClientConfigFeature(String configFile, String configName, boolean configureProperties) {
        this();
        this.configFile = configFile;
        this.configName = configName;
        this.configureProperties = configureProperties;
    }

    @Override
    public void initialize(Object obj) {
        super.initialize(obj);
        if (this.configureProperties) {
            this.configurer.setConfigProperties(obj, this.configFile, this.configName);
        }
    }

    @Override
    protected void initializeBindingProvider(BindingProvider bp) {
        this.configurer.setConfigHandlers(bp, this.configFile, this.configName);
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public String getConfigName() {
        return this.configName;
    }

    public void setConfigName(String configName) {
        this.configName = configName;
    }

    public boolean isConfigureProperties() {
        return this.configureProperties;
    }

    public void setConfigureProperties(boolean configureProperties) {
        this.configureProperties = configureProperties;
    }
}

