/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.ra;

import jakarta.jms.Connection;
import jakarta.resource.spi.ResourceAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.ra.ActiveMQRAManagedConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQResourceAdapter;
import org.apache.activemq.artemis.ra.ConnectionFactoryProperties;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivation;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivationSpec;
import org.apache.activemq.artemis.tests.unit.ra.BootstrapContext;
import org.apache.activemq.artemis.tests.unit.ra.MessageEndpointFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ResourceAdapterTest
extends ActiveMQTestBase {
    @Test
    public void testDefaultConnectionFactory() throws Exception {
        ActiveMQResourceAdapter ra = new ActiveMQResourceAdapter();
        ra.setConnectorClassName(InVMConnectorFactory.class.getName());
        ActiveMQConnectionFactory factory = ra.getDefaultActiveMQConnectionFactory();
        Assertions.assertEquals((long)factory.getCallTimeout(), (long)30000L);
        Assertions.assertEquals((long)factory.getClientFailureCheckPeriod(), (long)ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD);
        Assertions.assertEquals((Object)factory.getClientID(), null);
        Assertions.assertEquals((Object)factory.getConnectionLoadBalancingPolicyClassName(), (Object)ActiveMQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME);
        Assertions.assertEquals((long)factory.getConnectionTTL(), (long)ActiveMQClient.DEFAULT_CONNECTION_TTL);
        Assertions.assertEquals((int)factory.getConsumerMaxRate(), (int)-1);
        Assertions.assertEquals((int)factory.getConsumerWindowSize(), (int)0x100000);
        Assertions.assertEquals((int)factory.getDupsOKBatchSize(), (int)0x100000);
        Assertions.assertEquals((int)factory.getMinLargeMessageSize(), (int)102400);
        Assertions.assertEquals((int)factory.getProducerMaxRate(), (int)-1);
        Assertions.assertEquals((int)factory.getConfirmationWindowSize(), (int)-1);
        Assertions.assertEquals((int)-1, (int)factory.getReconnectAttempts());
        Assertions.assertEquals((long)factory.getRetryInterval(), (long)2000L);
        Assertions.assertEquals((double)factory.getRetryIntervalMultiplier(), (double)ActiveMQClient.DEFAULT_RETRY_INTERVAL_MULTIPLIER, (double)1.0E-5);
        Assertions.assertEquals((int)factory.getScheduledThreadPoolMaxSize(), (int)5);
        Assertions.assertEquals((int)factory.getThreadPoolMaxSize(), (int)-1);
        Assertions.assertEquals((int)factory.getTransactionBatchSize(), (int)0x100000);
        Assertions.assertEquals((Object)factory.isAutoGroup(), (Object)false);
        Assertions.assertEquals((Object)factory.isBlockOnAcknowledge(), (Object)false);
        Assertions.assertEquals((Object)factory.isBlockOnNonDurableSend(), (Object)false);
        Assertions.assertEquals((Object)factory.isBlockOnDurableSend(), (Object)true);
        Assertions.assertEquals((Object)factory.isPreAcknowledge(), (Object)false);
        Assertions.assertEquals((Object)factory.isUseGlobalPools(), (Object)true);
    }

    @Test
    public void test2DefaultConnectionFactorySame() throws Exception {
        ActiveMQResourceAdapter ra = new ActiveMQResourceAdapter();
        ra.setConnectorClassName(InVMConnectorFactory.class.getName());
        ActiveMQConnectionFactory factory = ra.getDefaultActiveMQConnectionFactory();
        ActiveMQConnectionFactory factory2 = ra.getDefaultActiveMQConnectionFactory();
        Assertions.assertEquals((Object)factory, (Object)factory2);
    }

    @Test
    public void testCreateConnectionFactoryNoOverrides() throws Exception {
        ActiveMQResourceAdapter ra = new ActiveMQResourceAdapter();
        ra.setConnectorClassName(InVMConnectorFactory.class.getName());
        ActiveMQConnectionFactory factory = ra.getConnectionFactory(new ConnectionFactoryProperties());
        Assertions.assertEquals((long)factory.getCallTimeout(), (long)30000L);
        Assertions.assertEquals((long)factory.getClientFailureCheckPeriod(), (long)ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD);
        Assertions.assertEquals((Object)factory.getClientID(), null);
        Assertions.assertEquals((Object)factory.getConnectionLoadBalancingPolicyClassName(), (Object)ActiveMQClient.DEFAULT_CONNECTION_LOAD_BALANCING_POLICY_CLASS_NAME);
        Assertions.assertEquals((long)factory.getConnectionTTL(), (long)ActiveMQClient.DEFAULT_CONNECTION_TTL);
        Assertions.assertEquals((int)factory.getConsumerMaxRate(), (int)-1);
        Assertions.assertEquals((int)factory.getConsumerWindowSize(), (int)0x100000);
        Assertions.assertEquals((int)factory.getDupsOKBatchSize(), (int)0x100000);
        Assertions.assertEquals((int)factory.getMinLargeMessageSize(), (int)102400);
        Assertions.assertEquals((int)factory.getProducerMaxRate(), (int)-1);
        Assertions.assertEquals((int)factory.getConfirmationWindowSize(), (int)-1);
        Assertions.assertEquals((int)-1, (int)factory.getReconnectAttempts());
        Assertions.assertEquals((long)factory.getRetryInterval(), (long)2000L);
        Assertions.assertEquals((double)factory.getRetryIntervalMultiplier(), (double)ActiveMQClient.DEFAULT_RETRY_INTERVAL_MULTIPLIER, (double)1.0E-6);
        Assertions.assertEquals((int)factory.getScheduledThreadPoolMaxSize(), (int)5);
        Assertions.assertEquals((int)factory.getThreadPoolMaxSize(), (int)-1);
        Assertions.assertEquals((int)factory.getTransactionBatchSize(), (int)0x100000);
        Assertions.assertEquals((Object)factory.isAutoGroup(), (Object)false);
        Assertions.assertEquals((Object)factory.isBlockOnAcknowledge(), (Object)false);
        Assertions.assertEquals((Object)factory.isBlockOnNonDurableSend(), (Object)false);
        Assertions.assertEquals((Object)factory.isBlockOnDurableSend(), (Object)true);
        Assertions.assertEquals((Object)factory.isPreAcknowledge(), (Object)false);
        Assertions.assertEquals((Object)factory.isUseGlobalPools(), (Object)true);
    }

    @Test
    public void testDefaultConnectionFactoryOverrides() throws Exception {
        ActiveMQResourceAdapter ra = new ActiveMQResourceAdapter();
        ra.setConnectorClassName(InVMConnectorFactory.class.getName());
        ra.setAutoGroup(Boolean.valueOf(true));
        ra.setBlockOnAcknowledge(Boolean.valueOf(true));
        ra.setBlockOnNonDurableSend(Boolean.valueOf(true));
        ra.setBlockOnDurableSend(Boolean.valueOf(false));
        ra.setCallTimeout(Long.valueOf(1L));
        ra.setClientFailureCheckPeriod(Long.valueOf(2L));
        ra.setClientID("myid");
        ra.setConnectionLoadBalancingPolicyClassName("mlbcn");
        ra.setConnectionTTL(Long.valueOf(3L));
        ra.setConsumerMaxRate(Integer.valueOf(4));
        ra.setConsumerWindowSize(Integer.valueOf(5));
        ra.setDiscoveryInitialWaitTimeout(Long.valueOf(6L));
        ra.setDiscoveryRefreshTimeout(Long.valueOf(7L));
        ra.setDupsOKBatchSize(Integer.valueOf(8));
        ra.setMinLargeMessageSize(Integer.valueOf(10));
        ra.setPreAcknowledge(Boolean.valueOf(true));
        ra.setProducerMaxRate(Integer.valueOf(11));
        ra.setConfirmationWindowSize(Integer.valueOf(12));
        ra.setReconnectAttempts(Integer.valueOf(13));
        ra.setRetryInterval(Long.valueOf(14L));
        ra.setRetryIntervalMultiplier(Double.valueOf(15.0));
        ra.setScheduledThreadPoolMaxSize(Integer.valueOf(16));
        ra.setThreadPoolMaxSize(Integer.valueOf(17));
        ra.setTransactionBatchSize(Integer.valueOf(18));
        ra.setUseGlobalPools(Boolean.valueOf(false));
        ActiveMQConnectionFactory factory = ra.getDefaultActiveMQConnectionFactory();
        Assertions.assertEquals((long)factory.getCallTimeout(), (long)1L);
        Assertions.assertEquals((long)factory.getClientFailureCheckPeriod(), (long)2L);
        Assertions.assertEquals((Object)factory.getClientID(), (Object)"myid");
        Assertions.assertEquals((Object)factory.getConnectionLoadBalancingPolicyClassName(), (Object)"mlbcn");
        Assertions.assertEquals((long)factory.getConnectionTTL(), (long)3L);
        Assertions.assertEquals((int)factory.getConsumerMaxRate(), (int)4);
        Assertions.assertEquals((int)factory.getConsumerWindowSize(), (int)5);
        Assertions.assertEquals((int)factory.getDupsOKBatchSize(), (int)8);
        Assertions.assertEquals((int)factory.getMinLargeMessageSize(), (int)10);
        Assertions.assertEquals((int)factory.getProducerMaxRate(), (int)11);
        Assertions.assertEquals((int)factory.getConfirmationWindowSize(), (int)12);
        Assertions.assertEquals((int)factory.getReconnectAttempts(), (int)13);
        Assertions.assertEquals((long)factory.getRetryInterval(), (long)14L);
        Assertions.assertEquals((double)factory.getRetryIntervalMultiplier(), (double)15.0, (double)1.0E-5);
        Assertions.assertEquals((int)factory.getScheduledThreadPoolMaxSize(), (int)16);
        Assertions.assertEquals((int)factory.getThreadPoolMaxSize(), (int)17);
        Assertions.assertEquals((int)factory.getTransactionBatchSize(), (int)18);
        Assertions.assertEquals((Object)factory.isAutoGroup(), (Object)true);
        Assertions.assertEquals((Object)factory.isBlockOnAcknowledge(), (Object)true);
        Assertions.assertEquals((Object)factory.isBlockOnNonDurableSend(), (Object)true);
        Assertions.assertEquals((Object)factory.isBlockOnDurableSend(), (Object)false);
        Assertions.assertEquals((Object)factory.isPreAcknowledge(), (Object)true);
        Assertions.assertEquals((Object)factory.isUseGlobalPools(), (Object)false);
    }

    @Test
    public void testCreateConnectionFactoryOverrides() throws Exception {
        ActiveMQResourceAdapter ra = new ActiveMQResourceAdapter();
        ra.setConnectorClassName(InVMConnectorFactory.class.getName());
        ConnectionFactoryProperties connectionFactoryProperties = new ConnectionFactoryProperties();
        connectionFactoryProperties.setAutoGroup(Boolean.valueOf(true));
        connectionFactoryProperties.setBlockOnAcknowledge(Boolean.valueOf(true));
        connectionFactoryProperties.setBlockOnNonDurableSend(Boolean.valueOf(true));
        connectionFactoryProperties.setBlockOnDurableSend(Boolean.valueOf(false));
        connectionFactoryProperties.setCallTimeout(Long.valueOf(1L));
        connectionFactoryProperties.setClientFailureCheckPeriod(Long.valueOf(2L));
        connectionFactoryProperties.setClientID("myid");
        connectionFactoryProperties.setConnectionLoadBalancingPolicyClassName("mlbcn");
        connectionFactoryProperties.setConnectionTTL(Long.valueOf(3L));
        connectionFactoryProperties.setConsumerMaxRate(Integer.valueOf(4));
        connectionFactoryProperties.setConsumerWindowSize(Integer.valueOf(5));
        connectionFactoryProperties.setDiscoveryInitialWaitTimeout(Long.valueOf(6L));
        connectionFactoryProperties.setDiscoveryRefreshTimeout(Long.valueOf(7L));
        connectionFactoryProperties.setDupsOKBatchSize(Integer.valueOf(8));
        connectionFactoryProperties.setMinLargeMessageSize(Integer.valueOf(10));
        connectionFactoryProperties.setPreAcknowledge(Boolean.valueOf(true));
        connectionFactoryProperties.setProducerMaxRate(Integer.valueOf(11));
        connectionFactoryProperties.setConfirmationWindowSize(Integer.valueOf(12));
        connectionFactoryProperties.setReconnectAttempts(Integer.valueOf(13));
        connectionFactoryProperties.setRetryInterval(Long.valueOf(14L));
        connectionFactoryProperties.setRetryIntervalMultiplier(Double.valueOf(15.0));
        connectionFactoryProperties.setScheduledThreadPoolMaxSize(Integer.valueOf(16));
        connectionFactoryProperties.setThreadPoolMaxSize(Integer.valueOf(17));
        connectionFactoryProperties.setTransactionBatchSize(Integer.valueOf(18));
        connectionFactoryProperties.setUseGlobalPools(Boolean.valueOf(false));
        ActiveMQConnectionFactory factory = ra.getConnectionFactory(connectionFactoryProperties);
        Assertions.assertEquals((long)factory.getCallTimeout(), (long)1L);
        Assertions.assertEquals((long)factory.getClientFailureCheckPeriod(), (long)2L);
        Assertions.assertEquals((Object)factory.getClientID(), (Object)"myid");
        Assertions.assertEquals((Object)factory.getConnectionLoadBalancingPolicyClassName(), (Object)"mlbcn");
        Assertions.assertEquals((long)factory.getConnectionTTL(), (long)3L);
        Assertions.assertEquals((int)factory.getConsumerMaxRate(), (int)4);
        Assertions.assertEquals((int)factory.getConsumerWindowSize(), (int)5);
        Assertions.assertEquals((int)factory.getDupsOKBatchSize(), (int)8);
        Assertions.assertEquals((int)factory.getMinLargeMessageSize(), (int)10);
        Assertions.assertEquals((int)factory.getProducerMaxRate(), (int)11);
        Assertions.assertEquals((int)factory.getConfirmationWindowSize(), (int)12);
        Assertions.assertEquals((int)factory.getReconnectAttempts(), (int)13);
        Assertions.assertEquals((long)factory.getRetryInterval(), (long)14L);
        Assertions.assertEquals((double)factory.getRetryIntervalMultiplier(), (double)15.0, (double)1.0E-6);
        Assertions.assertEquals((int)factory.getScheduledThreadPoolMaxSize(), (int)16);
        Assertions.assertEquals((int)factory.getThreadPoolMaxSize(), (int)17);
        Assertions.assertEquals((int)factory.getTransactionBatchSize(), (int)18);
        Assertions.assertEquals((Object)factory.isAutoGroup(), (Object)true);
        Assertions.assertEquals((Object)factory.isBlockOnAcknowledge(), (Object)true);
        Assertions.assertEquals((Object)factory.isBlockOnNonDurableSend(), (Object)true);
        Assertions.assertEquals((Object)factory.isBlockOnDurableSend(), (Object)false);
        Assertions.assertEquals((Object)factory.isPreAcknowledge(), (Object)true);
        Assertions.assertEquals((Object)factory.isUseGlobalPools(), (Object)false);
    }

    @Test
    public void testCreateConnectionFactoryOverrideConnector() throws Exception {
        ActiveMQResourceAdapter ra = new ActiveMQResourceAdapter();
        ra.setConnectorClassName(InVMConnectorFactory.class.getName());
        ConnectionFactoryProperties connectionFactoryProperties = new ConnectionFactoryProperties();
        ArrayList<String> value = new ArrayList<String>();
        value.add(NettyConnectorFactory.class.getName());
        connectionFactoryProperties.setParsedConnectorClassNames(value);
        ActiveMQConnectionFactory factory = ra.getConnectionFactory(connectionFactoryProperties);
        ActiveMQConnectionFactory defaultFactory = ra.getDefaultActiveMQConnectionFactory();
        Assertions.assertNotSame((Object)factory, (Object)defaultFactory);
    }

    @Test
    public void testCreateConnectionFactoryOverrideDiscovery() throws Exception {
        ActiveMQResourceAdapter ra = new ActiveMQResourceAdapter();
        ra.setConnectorClassName(InVMConnectorFactory.class.getName());
        ConnectionFactoryProperties connectionFactoryProperties = new ConnectionFactoryProperties();
        connectionFactoryProperties.setDiscoveryAddress("myhost");
        connectionFactoryProperties.setDiscoveryPort(Integer.valueOf(5678));
        connectionFactoryProperties.setDiscoveryLocalBindAddress("newAddress");
        ActiveMQConnectionFactory factory = ra.getConnectionFactory(connectionFactoryProperties);
        ActiveMQConnectionFactory defaultFactory = ra.getDefaultActiveMQConnectionFactory();
        Assertions.assertNotSame((Object)factory, (Object)defaultFactory);
        DiscoveryGroupConfiguration dc = factory.getServerLocator().getDiscoveryGroupConfiguration();
        UDPBroadcastEndpointFactory udpDg = (UDPBroadcastEndpointFactory)dc.getBroadcastEndpointFactory();
        Assertions.assertEquals((Object)udpDg.getLocalBindAddress(), (Object)"newAddress");
        Assertions.assertEquals((Object)udpDg.getGroupAddress(), (Object)"myhost");
        Assertions.assertEquals((int)udpDg.getGroupPort(), (int)5678);
    }

    @Test
    public void testCreateConnectionFactoryMultipleConnectors() {
        ActiveMQResourceAdapter ra = new ActiveMQResourceAdapter();
        ra.setConnectorClassName(NETTY_CONNECTOR_FACTORY + "," + INVM_CONNECTOR_FACTORY + "," + NETTY_CONNECTOR_FACTORY);
        ActiveMQConnectionFactory factory = ra.getConnectionFactory(new ConnectionFactoryProperties());
        TransportConfiguration[] configurations = factory.getServerLocator().getStaticTransportConfigurations();
        Assertions.assertNotNull((Object)configurations);
        Assertions.assertEquals((int)3, (int)configurations.length);
        Assertions.assertEquals((Object)NETTY_CONNECTOR_FACTORY, (Object)configurations[0].getFactoryClassName());
        Assertions.assertEquals((int)2, (int)configurations[0].getParams().size());
        Assertions.assertEquals((Object)INVM_CONNECTOR_FACTORY, (Object)configurations[1].getFactoryClassName());
        Assertions.assertEquals((int)1, (int)configurations[1].getParams().size());
        Assertions.assertEquals((Object)NETTY_CONNECTOR_FACTORY, (Object)configurations[2].getFactoryClassName());
        Assertions.assertEquals((int)2, (int)configurations[2].getParams().size());
    }

    @Test
    public void testCreateConnectionFactoryMultipleConnectorsAndParams() {
        ActiveMQResourceAdapter ra = new ActiveMQResourceAdapter();
        ra.setConnectorClassName(NETTY_CONNECTOR_FACTORY + "," + INVM_CONNECTOR_FACTORY + "," + NETTY_CONNECTOR_FACTORY);
        ra.setConnectionParameters("host=host1;port=61616, serverid=0, host=host2;port=61617");
        ActiveMQConnectionFactory factory = ra.getConnectionFactory(new ConnectionFactoryProperties());
        TransportConfiguration[] configurations = factory.getServerLocator().getStaticTransportConfigurations();
        Assertions.assertNotNull((Object)configurations);
        Assertions.assertEquals((int)3, (int)configurations.length);
        Assertions.assertEquals((Object)NETTY_CONNECTOR_FACTORY, (Object)configurations[0].getFactoryClassName());
        Assertions.assertEquals((int)2, (int)configurations[0].getParams().size());
        Assertions.assertEquals((Object)"host1", configurations[0].getParams().get("host"));
        Assertions.assertEquals((Object)"61616", configurations[0].getParams().get("port"));
        Assertions.assertEquals((Object)INVM_CONNECTOR_FACTORY, (Object)configurations[1].getFactoryClassName());
        Assertions.assertEquals((int)1, (int)configurations[1].getParams().size());
        Assertions.assertEquals((Object)"0", configurations[1].getParams().get("serverid"));
        Assertions.assertEquals((Object)NETTY_CONNECTOR_FACTORY, (Object)configurations[2].getFactoryClassName());
        Assertions.assertEquals((int)2, (int)configurations[2].getParams().size());
        Assertions.assertEquals((Object)"host2", configurations[2].getParams().get("host"));
        Assertions.assertEquals((Object)"61617", configurations[2].getParams().get("port"));
    }

    @Test
    public void testCreateConnectionFactoryMultipleConnectorsOverride() {
        ActiveMQResourceAdapter ra = new ActiveMQResourceAdapter();
        ra.setConnectorClassName(NETTY_CONNECTOR_FACTORY + "," + INVM_CONNECTOR_FACTORY + "," + NETTY_CONNECTOR_FACTORY);
        ConnectionFactoryProperties overrideProperties = new ConnectionFactoryProperties();
        ArrayList<String> value = new ArrayList<String>();
        value.add(INVM_CONNECTOR_FACTORY);
        value.add(NETTY_CONNECTOR_FACTORY);
        value.add(INVM_CONNECTOR_FACTORY);
        overrideProperties.setParsedConnectorClassNames(value);
        ActiveMQConnectionFactory factory = ra.getConnectionFactory(overrideProperties);
        TransportConfiguration[] configurations = factory.getServerLocator().getStaticTransportConfigurations();
        Assertions.assertNotNull((Object)configurations);
        Assertions.assertEquals((int)3, (int)configurations.length);
        Assertions.assertEquals((Object)INVM_CONNECTOR_FACTORY, (Object)configurations[0].getFactoryClassName());
        Assertions.assertEquals((int)1, (int)configurations[0].getParams().size());
        Assertions.assertEquals((Object)NETTY_CONNECTOR_FACTORY, (Object)configurations[1].getFactoryClassName());
        Assertions.assertEquals((int)2, (int)configurations[1].getParams().size());
        Assertions.assertEquals((Object)INVM_CONNECTOR_FACTORY, (Object)configurations[2].getFactoryClassName());
        Assertions.assertEquals((int)1, (int)configurations[2].getParams().size());
    }

    @Test
    public void testCreateConnectionFactoryMultipleConnectorsOverrideAndParams() {
        ActiveMQResourceAdapter ra = new ActiveMQResourceAdapter();
        ra.setConnectorClassName(NETTY_CONNECTOR_FACTORY + "," + INVM_CONNECTOR_FACTORY + "," + NETTY_CONNECTOR_FACTORY);
        ra.setConnectionParameters("host=host1;port=61616, serverid=0, host=host2;port=61617");
        ConnectionFactoryProperties overrideProperties = new ConnectionFactoryProperties();
        ArrayList<String> value = new ArrayList<String>();
        value.add(INVM_CONNECTOR_FACTORY);
        value.add(NETTY_CONNECTOR_FACTORY);
        value.add(INVM_CONNECTOR_FACTORY);
        overrideProperties.setParsedConnectorClassNames(value);
        ArrayList connectionParameters = new ArrayList();
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("serverid", "0");
        connectionParameters.add(map1);
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("host", "myhost");
        map2.put("port", "61616");
        connectionParameters.add(map2);
        HashMap<String, String> map3 = new HashMap<String, String>();
        map3.put("serverid", "1");
        connectionParameters.add(map3);
        overrideProperties.setParsedConnectionParameters(connectionParameters);
        ActiveMQConnectionFactory factory = ra.getConnectionFactory(overrideProperties);
        TransportConfiguration[] configurations = factory.getServerLocator().getStaticTransportConfigurations();
        Assertions.assertNotNull((Object)configurations);
        Assertions.assertEquals((int)3, (int)configurations.length);
        Assertions.assertEquals((Object)INVM_CONNECTOR_FACTORY, (Object)configurations[0].getFactoryClassName());
        Assertions.assertEquals((int)1, (int)configurations[0].getParams().size());
        Assertions.assertEquals((Object)"0", configurations[0].getParams().get("serverid"));
        Assertions.assertEquals((Object)NETTY_CONNECTOR_FACTORY, (Object)configurations[1].getFactoryClassName());
        Assertions.assertEquals((int)2, (int)configurations[1].getParams().size());
        Assertions.assertEquals((Object)"myhost", configurations[1].getParams().get("host"));
        Assertions.assertEquals((Object)"61616", configurations[1].getParams().get("port"));
        Assertions.assertEquals((Object)INVM_CONNECTOR_FACTORY, (Object)configurations[2].getFactoryClassName());
        Assertions.assertEquals((int)1, (int)configurations[2].getParams().size());
        Assertions.assertEquals((Object)"1", configurations[2].getParams().get("serverid"));
    }

    @Test
    public void testCreateConnectionFactoryThrowsException() throws Exception {
        ActiveMQResourceAdapter ra = new ActiveMQResourceAdapter();
        ConnectionFactoryProperties connectionFactoryProperties = new ConnectionFactoryProperties();
        try {
            ra.getConnectionFactory(connectionFactoryProperties);
            Assertions.fail((String)"should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testValidateProperties() throws Exception {
        this.validateGettersAndSetters(new ActiveMQResourceAdapter(), "backupTransportConfiguration", "connectionParameters", "jndiParams");
        this.validateGettersAndSetters(new ActiveMQRAManagedConnectionFactory(), "connectionParameters", "sessionDefaultType", "backupConnectionParameters", "jndiParams");
        this.validateGettersAndSetters(new ActiveMQActivationSpec(), "connectionParameters", "acknowledgeMode", "subscriptionDurability", "jndiParams", "maxSession");
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setAcknowledgeMode("DUPS_OK_ACKNOWLEDGE");
        Assertions.assertEquals((Object)"Dups-ok-acknowledge", (Object)spec.getAcknowledgeMode());
        spec.setSubscriptionDurability("Durable");
        Assertions.assertEquals((Object)"Durable", (Object)spec.getSubscriptionDurability());
        spec.setSubscriptionDurability("NonDurable");
        Assertions.assertEquals((Object)"NonDurable", (Object)spec.getSubscriptionDurability());
        int validMaxSessionValue = 110;
        spec.setMaxSession(Integer.valueOf(110));
        Assertions.assertTrue((110 == spec.getMaxSession() ? (byte)1 : 0) != 0);
        spec.setMaxSession(Integer.valueOf(-3));
        Assertions.assertTrue((spec.getMaxSession() == 1 ? (byte)1 : 0) != 0);
        spec = new ActiveMQActivationSpec();
        ActiveMQResourceAdapter adapter = new ActiveMQResourceAdapter();
        adapter.setUserName("us1");
        adapter.setPassword("ps1");
        adapter.setClientID("cl1");
        spec.setResourceAdapter((ResourceAdapter)adapter);
        Assertions.assertEquals((Object)"us1", (Object)spec.getUser());
        Assertions.assertEquals((Object)"ps1", (Object)spec.getPassword());
        spec.setUser("us2");
        spec.setPassword("ps2");
        spec.setClientID("cl2");
        Assertions.assertEquals((Object)"us2", (Object)spec.getUser());
        Assertions.assertEquals((Object)"ps2", (Object)spec.getPassword());
        Assertions.assertEquals((Object)"cl2", (Object)spec.getClientID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartActivation() throws Exception {
        ActiveMQServer server = this.createServer(false);
        try {
            server.start();
            ServerLocator locator = this.createInVMNonHALocator();
            ClientSessionFactory factory = this.createSessionFactory(locator);
            ClientSession session = factory.createSession(false, false, false);
            ActiveMQDestination queue = (ActiveMQDestination)ActiveMQJMSClient.createQueue((String)"test");
            session.createQueue(QueueConfiguration.of((SimpleString)queue.getSimpleAddress()));
            session.close();
            ActiveMQResourceAdapter ra = new ActiveMQResourceAdapter();
            ra.setConnectorClassName(INVM_CONNECTOR_FACTORY);
            ra.setUserName("userGlobal");
            ra.setPassword("passwordGlobal");
            ra.start((jakarta.resource.spi.BootstrapContext)new BootstrapContext());
            Connection conn = ra.getDefaultActiveMQConnectionFactory().createConnection();
            conn.close();
            ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
            spec.setResourceAdapter((ResourceAdapter)ra);
            spec.setUseJNDI(Boolean.valueOf(false));
            spec.setUser("user");
            spec.setPassword("password");
            spec.setDestinationType("jakarta.jms.Topic");
            spec.setDestination("test");
            spec.setMinSession(Integer.valueOf(10));
            spec.setMaxSession(Integer.valueOf(10));
            ActiveMQActivation activation = new ActiveMQActivation(ra, (jakarta.resource.spi.endpoint.MessageEndpointFactory)new MessageEndpointFactory(), spec);
            activation.start();
            Assertions.assertEquals((int)server.getConnectionCount(), (int)11, (String)"wrong connection count ");
            activation.stop();
            ra.stop();
            locator.close();
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartActivationSingleConnection() throws Exception {
        ActiveMQServer server = this.createServer(false);
        try {
            server.start();
            ServerLocator locator = this.createInVMNonHALocator();
            ClientSessionFactory factory = this.createSessionFactory(locator);
            ClientSession session = factory.createSession(false, false, false);
            ActiveMQDestination queue = (ActiveMQDestination)ActiveMQJMSClient.createQueue((String)"test");
            session.createQueue(QueueConfiguration.of((SimpleString)queue.getSimpleAddress()));
            session.close();
            ActiveMQResourceAdapter ra = new ActiveMQResourceAdapter();
            ra.setConnectorClassName(INVM_CONNECTOR_FACTORY);
            ra.setUserName("userGlobal");
            ra.setPassword("passwordGlobal");
            ra.start((jakarta.resource.spi.BootstrapContext)new BootstrapContext());
            Connection conn = ra.getDefaultActiveMQConnectionFactory().createConnection();
            conn.close();
            ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
            spec.setResourceAdapter((ResourceAdapter)ra);
            spec.setUseJNDI(Boolean.valueOf(false));
            spec.setUser("user");
            spec.setPassword("password");
            spec.setDestinationType("jakarta.jms.Topic");
            spec.setDestination("test");
            spec.setMinSession(Integer.valueOf(1));
            spec.setMaxSession(Integer.valueOf(10));
            spec.setSingleConnection(Boolean.valueOf(true));
            ActiveMQActivation activation = new ActiveMQActivation(ra, (jakarta.resource.spi.endpoint.MessageEndpointFactory)new MessageEndpointFactory(), spec);
            activation.start();
            Assertions.assertEquals((int)server.getConnectionCount(), (int)2, (String)"wrong connection count ");
            activation.stop();
            ra.stop();
            locator.close();
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeprecatedActivationDeserializationParameters() throws Exception {
        ActiveMQServer server = this.createServer(false);
        try {
            server.start();
            ActiveMQResourceAdapter ra = new ActiveMQResourceAdapter();
            ra.setConnectorClassName(INVM_CONNECTOR_FACTORY);
            ra.setUserName("userGlobal");
            ra.setPassword("passwordGlobal");
            ra.setDeserializationWhiteList("a.b.c.d.e");
            ra.setDeserializationBlackList("f.g.h.i.j");
            ra.start((jakarta.resource.spi.BootstrapContext)new BootstrapContext());
            ActiveMQConnectionFactory factory = ra.getDefaultActiveMQConnectionFactory();
            Assertions.assertEquals((Object)"a.b.c.d.e", (Object)factory.getDeserializationWhiteList());
            Assertions.assertEquals((Object)"f.g.h.i.j", (Object)factory.getDeserializationBlackList());
            ConnectionFactoryProperties overrides = new ConnectionFactoryProperties();
            overrides.setDeserializationWhiteList("k.l.m.n");
            overrides.setDeserializationBlackList("o.p.q.r");
            factory = ra.newConnectionFactory(overrides);
            Assertions.assertEquals((Object)"k.l.m.n", (Object)factory.getDeserializationWhiteList());
            Assertions.assertEquals((Object)"o.p.q.r", (Object)factory.getDeserializationBlackList());
            ra.stop();
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testActivationDeserializationParameters() throws Exception {
        ActiveMQServer server = this.createServer(false);
        try {
            server.start();
            ActiveMQResourceAdapter ra = new ActiveMQResourceAdapter();
            ra.setConnectorClassName(INVM_CONNECTOR_FACTORY);
            ra.setUserName("userGlobal");
            ra.setPassword("passwordGlobal");
            ra.setDeserializationAllowList("a.b.c.d.e");
            ra.setDeserializationDenyList("f.g.h.i.j");
            ra.start((jakarta.resource.spi.BootstrapContext)new BootstrapContext());
            ActiveMQConnectionFactory factory = ra.getDefaultActiveMQConnectionFactory();
            Assertions.assertEquals((Object)"a.b.c.d.e", (Object)factory.getDeserializationAllowList());
            Assertions.assertEquals((Object)"f.g.h.i.j", (Object)factory.getDeserializationDenyList());
            ConnectionFactoryProperties overrides = new ConnectionFactoryProperties();
            overrides.setDeserializationAllowList("k.l.m.n");
            overrides.setDeserializationDenyList("o.p.q.r");
            factory = ra.newConnectionFactory(overrides);
            Assertions.assertEquals((Object)"k.l.m.n", (Object)factory.getDeserializationAllowList());
            Assertions.assertEquals((Object)"o.p.q.r", (Object)factory.getDeserializationDenyList());
            ra.stop();
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testForConnectionLeakDuringActivationWhenSessionCreationFails() throws Exception {
        ActiveMQServer server = this.createServer(false);
        ActiveMQResourceAdapter ra = null;
        ActiveMQActivation activation = null;
        try {
            server.getConfiguration().setSecurityEnabled(true);
            server.start();
            ra = new ActiveMQResourceAdapter();
            ra.setConnectorClassName(INVM_CONNECTOR_FACTORY);
            ra.setUserName("badUser");
            ra.setPassword("badPassword");
            ra.start((jakarta.resource.spi.BootstrapContext)new BootstrapContext());
            ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
            spec.setResourceAdapter((ResourceAdapter)ra);
            spec.setUseJNDI(Boolean.valueOf(false));
            spec.setUser("user");
            spec.setPassword("password");
            spec.setDestinationType("jakarta.jms.Topic");
            spec.setDestination("test");
            spec.setMinSession(Integer.valueOf(1));
            spec.setMaxSession(Integer.valueOf(1));
            spec.setSetupAttempts(Integer.valueOf(1));
            activation = new ActiveMQActivation(ra, (jakarta.resource.spi.endpoint.MessageEndpointFactory)new MessageEndpointFactory(), spec);
            try {
                activation.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Assertions.assertEquals((int)0, (int)server.getRemotingService().getConnections().size());
        }
        finally {
            if (activation != null) {
                activation.stop();
            }
            if (ra != null) {
                ra.stop();
            }
            server.stop();
        }
    }
}

