/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.impl.XidImpl;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LVQRecoveryTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ClientSession clientSession;
    private final SimpleString address = SimpleString.of((String)"LVQTestAddress");
    private final SimpleString qName1 = SimpleString.of((String)"LVQTestQ1");
    private ClientSession clientSessionXa;
    private Configuration configuration;
    private AddressSettings qs;
    private ServerLocator locator;

    @Test
    public void testMultipleMessagesAfterRecovery() throws Exception {
        XidImpl xid = new XidImpl("bq1".getBytes(), 4, "gtid1".getBytes());
        ClientProducer producer = this.clientSessionXa.createProducer(this.address);
        SimpleString messageId1 = SimpleString.of((String)"SMID1");
        SimpleString messageId2 = SimpleString.of((String)"SMID2");
        this.clientSessionXa.start((Xid)xid, 0);
        ClientMessage m1 = this.createTextMessage(this.clientSession, "m1");
        m1.putStringProperty(Message.HDR_LAST_VALUE_NAME, messageId1);
        ClientMessage m2 = this.createTextMessage(this.clientSession, "m2");
        m2.putStringProperty(Message.HDR_LAST_VALUE_NAME, messageId2);
        ClientMessage m3 = this.createTextMessage(this.clientSession, "m3");
        m3.putStringProperty(Message.HDR_LAST_VALUE_NAME, messageId1);
        ClientMessage m4 = this.createTextMessage(this.clientSession, "m4");
        m4.putStringProperty(Message.HDR_LAST_VALUE_NAME, messageId2);
        producer.send((Message)m1);
        producer.send((Message)m2);
        producer.send((Message)m3);
        producer.send((Message)m4);
        this.clientSessionXa.end((Xid)xid, 0x4000000);
        this.clientSessionXa.prepare((Xid)xid);
        this.clientSession.close();
        this.clientSessionXa.close();
        this.restartServer();
        this.clientSessionXa.commit((Xid)xid, false);
        ClientConsumer consumer = this.clientSession.createConsumer(this.qName1);
        this.clientSession.start();
        ClientMessage m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m3");
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m4");
    }

    @Test
    public void testManyMessagesReceivedWithRollback() throws Exception {
        XidImpl xid = new XidImpl("bq1".getBytes(), 4, "gtid1".getBytes());
        ClientProducer producer = this.clientSession.createProducer(this.address);
        ClientConsumer consumer = this.clientSessionXa.createConsumer(this.qName1);
        SimpleString rh = SimpleString.of((String)"SMID1");
        ClientMessage m1 = this.createTextMessage(this.clientSession, "m1");
        m1.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m1.setDurable(true);
        ClientMessage m2 = this.createTextMessage(this.clientSession, "m2");
        m2.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m2.setDurable(true);
        ClientMessage m3 = this.createTextMessage(this.clientSession, "m3");
        m3.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m3.setDurable(true);
        ClientMessage m4 = this.createTextMessage(this.clientSession, "m4");
        m4.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m4.setDurable(true);
        ClientMessage m5 = this.createTextMessage(this.clientSession, "m5");
        m5.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m5.setDurable(true);
        ClientMessage m6 = this.createTextMessage(this.clientSession, "m6");
        m6.putStringProperty(Message.HDR_LAST_VALUE_NAME, rh);
        m6.setDurable(true);
        this.clientSessionXa.start((Xid)xid, 0);
        this.clientSessionXa.start();
        producer.send((Message)m1);
        ClientMessage m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m1");
        producer.send((Message)m2);
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m2");
        producer.send((Message)m3);
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m3");
        producer.send((Message)m4);
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m4");
        producer.send((Message)m5);
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m5");
        producer.send((Message)m6);
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)"m6");
        this.clientSessionXa.end((Xid)xid, 0x4000000);
        this.clientSessionXa.prepare((Xid)xid);
        this.clientSession.close();
        this.clientSessionXa.close();
        this.restartServer();
        this.clientSessionXa.rollback((Xid)xid);
        consumer = this.clientSession.createConsumer(this.qName1);
        this.clientSession.start();
        m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m.acknowledge();
        Assertions.assertEquals((Object)"m6", (Object)m.getBodyBuffer().readString());
        m = consumer.receiveImmediate();
        Assertions.assertNull((Object)m);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.configuration = this.createDefaultInVMConfig();
        this.server = this.createServer(true, this.configuration);
        this.server.start();
        this.qs = new AddressSettings().setDefaultLastValueQueue(true);
        this.server.getAddressSettingsRepository().addMatch(this.address.toString(), (Object)this.qs);
        this.locator = this.createInVMNonHALocator().setBlockOnAcknowledge(true).setAckBatchSize(0);
        ClientSessionFactory sessionFactory = this.createSessionFactory(this.locator);
        this.clientSession = sessionFactory.createSession(false, true, true);
        this.clientSessionXa = sessionFactory.createSession(true, false, false);
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)this.qName1).setAddress(this.address));
    }

    private void restartServer() throws Exception {
        this.server.stop();
        this.server = null;
        this.server = this.createServer(true, this.configuration);
        this.server.getAddressSettingsRepository().addMatch(this.address.toString(), (Object)this.qs);
        this.server.start();
        this.server.getAddressSettingsRepository().addMatch(this.address.toString(), (Object)new AddressSettings().setDefaultLastValueQueue(true));
        this.locator.close();
        this.locator = this.createInVMNonHALocator().setBlockOnAcknowledge(true).setAckBatchSize(0);
        ClientSessionFactory sessionFactory = this.createSessionFactory(this.locator);
        this.clientSession = sessionFactory.createSession(false, true, true);
        this.clientSessionXa = sessionFactory.createSession(true, false, false);
    }
}

