/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.server.ActivateCallback;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ActivationCallbackTest
extends ActiveMQTestBase {
    protected ActiveMQServer server;

    @Test
    public void callbackOnShutdown() throws Exception {
        this.server = this.createServer(false, this.createDefaultNettyConfig());
        final CountDownLatch latch = new CountDownLatch(1);
        this.server.registerActivateCallback(new ActivateCallback(){

            public void shutdown(ActiveMQServer server) {
                latch.countDown();
            }
        });
        this.server.start();
        Assertions.assertEquals((long)1L, (long)latch.getCount());
        this.server.stop();
        Assertions.assertTrue((boolean)latch.await(30L, TimeUnit.SECONDS));
    }
}

