/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.scheduling;

import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipliedDelayedMessageTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ActiveMQServer server;
    private static final long DELAY = 100L;
    private static final double MULTIPLIER = 2.0;
    private static final long MAX_DELAY = 1000L;
    private final String queueName = "MultipliedDelayedMessageTestQueue";
    private ServerLocator locator;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.initServer();
    }

    protected void initServer() throws Exception {
        this.server = this.createServer(true, this.createDefaultInVMConfig());
        this.server.start();
        AddressSettings addressSettings = (AddressSettings)this.server.getAddressSettingsRepository().getMatch("*");
        AddressSettings newAddressSettings = new AddressSettings().setRedeliveryDelay(100L).setRedeliveryMultiplier(2.0).setMaxRedeliveryDelay(1000L);
        newAddressSettings.merge(addressSettings);
        this.server.getAddressSettingsRepository().addMatch("MultipliedDelayedMessageTestQueue", (Object)newAddressSettings);
        this.locator = this.createInVMNonHALocator();
    }

    @Test
    public void testMultipliedDelayedRedeliveryOnClose() throws Exception {
        ClientSessionFactory sessionFactory = this.createSessionFactory(this.locator);
        ClientSession session = sessionFactory.createSession(false, false, false);
        session.createQueue(QueueConfiguration.of((String)"MultipliedDelayedMessageTestQueue"));
        session.close();
        session = sessionFactory.createSession(false, true, true);
        ClientProducer producer = session.createProducer("MultipliedDelayedMessageTestQueue");
        ActiveMQTestBase.forceGC();
        ClientMessage tm = this.createDurableMessage(session, "message");
        producer.send((Message)tm);
        session.close();
        session = sessionFactory.createSession(false, false, false);
        ClientConsumer consumer = session.createConsumer("MultipliedDelayedMessageTestQueue");
        session.start();
        tm = consumer.receive(500L);
        Assertions.assertNotNull((Object)tm);
        for (int i = 1; i <= 6; ++i) {
            long start = System.currentTimeMillis();
            tm.acknowledge();
            session.rollback();
            long expectedDelay = this.calculateExpectedDelay(100L, 1000L, 2.0, i);
            logger.debug("\nExpected delay: {}", (Object)expectedDelay);
            tm = consumer.receive(expectedDelay + 500L);
            long stop = System.currentTimeMillis();
            Assertions.assertNotNull((Object)tm);
            logger.debug("Actual delay: {}", (Object)(stop - start));
            Assertions.assertTrue((stop - start >= expectedDelay ? (byte)1 : 0) != 0);
        }
        tm.acknowledge();
        session.commit();
        session.close();
    }

    private ClientMessage createDurableMessage(ClientSession session, String body) {
        ClientMessage message = session.createMessage((byte)3, true, 0L, System.currentTimeMillis(), (byte)1);
        message.getBodyBuffer().writeString(body);
        return message;
    }

    private long calculateExpectedDelay(long redeliveryDelay, long maxRedeliveryDelay, double redeliveryMultiplier, int deliveryCount) {
        int tmpDeliveryCount = deliveryCount > 0 ? deliveryCount - 1 : 0;
        long delay = (long)((double)redeliveryDelay * Math.pow(redeliveryMultiplier, tmpDeliveryCount));
        if (delay > maxRedeliveryDelay) {
            delay = maxRedeliveryDelay;
        }
        return delay;
    }
}

