/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.management;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.management.ActiveMQServerControl;
import org.apache.activemq.artemis.api.core.management.ObjectNameBuilder;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.integration.openwire.OpenWireTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.transport.TransportListener;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class OpenWireDeleteQueueTest
extends OpenWireTestBase {
    private ActiveMQServerControl serverControl;
    private SimpleString queueName1 = SimpleString.of((String)"queue1");
    private ConnectionFactory factory;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.serverControl = (ActiveMQServerControl)ManagementControlHelper.createProxy(ObjectNameBuilder.DEFAULT.getActiveMQServerObjectName(), ActiveMQServerControl.class, this.mbeanServer);
        this.factory = new ActiveMQConnectionFactory("failover:(tcp://localhost:61616?wireFormat.cacheEnabled=true)");
    }

    @Override
    protected void configureAddressSettings(Map<String, AddressSettings> addressSettingsMap) {
        addressSettingsMap.put("#", new AddressSettings().setAutoCreateQueues(Boolean.valueOf(false)).setAutoCreateAddresses(Boolean.valueOf(false)).setDeadLetterAddress(SimpleString.of((String)"ActiveMQ.DLQ")));
        addressSettingsMap.put(this.queueName1.toString(), new AddressSettings().setAutoCreateQueues(Boolean.valueOf(true)).setAutoCreateAddresses(Boolean.valueOf(true)).setDeadLetterAddress(SimpleString.of((String)"ActiveMQ.DLQ")));
    }

    @Override
    protected void extraServerConfig(Configuration serverConfig) {
        serverConfig.setJMXManagementEnabled(true);
        Set acceptorConfigs = serverConfig.getAcceptorConfigurations();
        for (TransportConfiguration tconfig : acceptorConfigs) {
            if (!"netty".equals(tconfig.getName())) continue;
            Map params = tconfig.getExtraParams();
            params.put("supportAdvisory", false);
            params.put("suppressInternalManagementObjects", false);
        }
    }

    @Test
    public void testDestroyQueueClosingConsumers() throws Exception {
        try (Connection connection = this.factory.createConnection();){
            connection.start();
            Session session = connection.createSession(false, 1);
            Queue destination = session.createQueue(this.queueName1.toString());
            MessageProducer producer = session.createProducer((Destination)destination);
            CountDownLatch one = new CountDownLatch(1);
            CountDownLatch two = new CountDownLatch(2);
            CountDownLatch three = new CountDownLatch(3);
            MessageConsumer messageConsumer = session.createConsumer((Destination)destination);
            messageConsumer.setMessageListener(message -> {
                one.countDown();
                two.countDown();
                three.countDown();
            });
            producer.send((Message)session.createTextMessage("one"));
            Assertions.assertTrue((boolean)one.await(5L, TimeUnit.SECONDS));
            Assertions.assertTrue((boolean)Wait.waitFor(() -> {
                String bindings = this.serverControl.listBindingsForAddress(this.queueName1.toString());
                return bindings.contains((CharSequence)this.queueName1);
            }));
            final CountDownLatch failoverStart = new CountDownLatch(1);
            final CountDownLatch failoverEnd = new CountDownLatch(1);
            ((ActiveMQConnection)connection).addTransportListener(new TransportListener(){

                public void onCommand(Object command) {
                }

                public void onException(IOException error) {
                }

                public void transportInterupted() {
                    failoverStart.countDown();
                }

                public void transportResumed() {
                    failoverEnd.countDown();
                }
            });
            this.serverControl.destroyQueue(this.queueName1.toString(), true);
            Assertions.assertTrue((boolean)Wait.waitFor(() -> {
                String bindings = this.serverControl.listBindingsForAddress(this.queueName1.toString());
                return !bindings.contains((CharSequence)this.queueName1);
            }), (String)"Binding gone!");
            Assertions.assertTrue((boolean)failoverStart.await(5L, TimeUnit.SECONDS));
            Assertions.assertTrue((boolean)failoverEnd.await(5L, TimeUnit.SECONDS));
            producer.send((Message)session.createTextMessage("two"));
            Assertions.assertTrue((boolean)two.await(5L, TimeUnit.SECONDS));
            Assertions.assertTrue((boolean)Wait.waitFor(() -> {
                String bindings = this.serverControl.listBindingsForAddress(this.queueName1.toString());
                return bindings.contains((CharSequence)this.queueName1);
            }, (long)5000L), (String)"binding auto created for message two");
            producer.send((Message)session.createTextMessage("three"));
            Assertions.assertTrue((boolean)three.await(5L, TimeUnit.SECONDS));
        }
    }
}

