/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSSecurityException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.util.Set;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=20L)
public class SecurityOpenWireTest
extends BasicOpenWireTest {
    private final String FQQN_USER1 = "fqqnUser1";
    private final String FQQN_USER2 = "fqqnUser2";
    private final String FQQN_ROLE1 = "fqqnRole1";
    private final String FQQN_ROLE2 = "fqqnRole2";
    private final String FQQN_ADDRESS = "fqqnAddress";
    private final String FQQN_QUEUE1 = "fqqnQueue1";
    private final String FQQN_QUEUE2 = "fqqnQueue2";
    private final String FQQN_FOR_USER1 = CompositeAddress.toFullyQualified((String)"fqqnAddress", (String)"fqqnQueue1");
    private final String FQQN_FOR_USER2 = CompositeAddress.toFullyQualified((String)"fqqnAddress", (String)"fqqnQueue2");
    private final String ALLOWED_USER = "allowedUser";
    private final String ALLOWED_ROLE = "allowedRole";
    private final String ALLOWED_USER_ALTERNATE = "allowedUserAlternate";
    private final String ALLOWED_ROLE_ALTERNATE = "allowedRoleAlternate";
    private final String DENIED_USER = "deniedUser";
    private final String DENIED_ROLE = "deniedRole";
    private final String PASS = RandomUtil.randomString();
    private final String ADDRESS = "myAddress";
    private final String ALTERNATE_ADDRESS = "myOtherAddress";
    private final String ALTERNATE_QUEUE = "myOtherQueue";
    private final String QUEUE = "myQueue";
    private final String FQQN = CompositeAddress.toFullyQualified((String)"myAddress", (String)"myQueue");
    private final String FQQN_ALTERNATE = CompositeAddress.toFullyQualified((String)"myOtherAddress", (String)"myOtherQueue");

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        System.setProperty("org.apache.activemq.transport.AbstractInactivityMonitor.keepAliveTime", "2");
        this.realStore = true;
        this.enableSecurity = true;
        super.setUp();
    }

    @Override
    protected void extraServerConfig(Configuration configuration) {
        super.extraServerConfig(configuration);
        Role allowed = new Role("allowedRole", true, false, false, false, false, false, false, false, true, false, false, false);
        Role denied = new Role("deniedRole", false, false, false, false, false, false, false, false, false, false, false, false);
        Role alternate = new Role("allowedRoleAlternate", true, false, false, false, false, false, false, false, true, false, false, false);
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)this.server.getSecurityManager();
        securityManager.getConfiguration().addUser("allowedUser", this.PASS);
        securityManager.getConfiguration().addRole("allowedUser", "allowedRole");
        securityManager.getConfiguration().addUser("allowedUserAlternate", this.PASS);
        securityManager.getConfiguration().addRole("allowedUserAlternate", "allowedRoleAlternate");
        securityManager.getConfiguration().addUser("deniedUser", this.PASS);
        securityManager.getConfiguration().addRole("deniedUser", "deniedRole");
        securityManager.getConfiguration().addRole("allowedUser", "advisoryReceiver");
        securityManager.getConfiguration().addRole("allowedUserAlternate", "advisoryReceiver");
        securityManager.getConfiguration().addRole("deniedUser", "advisoryReceiver");
        configuration.putSecurityRoles(this.FQQN, Set.of(allowed, denied));
        configuration.putSecurityRoles("myAddress", Set.of(allowed, denied));
        configuration.putSecurityRoles(this.FQQN_ALTERNATE, Set.of(alternate, denied));
        configuration.putSecurityRoles("myOtherAddress", Set.of(alternate, denied));
        configuration.addQueueConfiguration(QueueConfiguration.of((String)"myQueue").setAddress("myAddress").setRoutingType(RoutingType.ANYCAST));
        configuration.addQueueConfiguration(QueueConfiguration.of((String)"myOtherQueue").setAddress("myOtherAddress").setRoutingType(RoutingType.ANYCAST));
        Role fqqn1 = new Role("fqqnRole1", true, false, false, false, false, false, false, false, false, false, false, false);
        Role fqqn2 = new Role("fqqnRole2", true, false, false, false, false, false, false, false, false, false, false, false);
        securityManager.getConfiguration().addUser("fqqnUser1", this.PASS);
        securityManager.getConfiguration().addRole("fqqnUser1", "fqqnRole1");
        securityManager.getConfiguration().addRole("fqqnUser1", "advisoryReceiver");
        securityManager.getConfiguration().addUser("fqqnUser2", this.PASS);
        securityManager.getConfiguration().addRole("fqqnUser2", "fqqnRole2");
        securityManager.getConfiguration().addRole("fqqnUser2", "advisoryReceiver");
        configuration.putSecurityRoles(this.FQQN_FOR_USER1, Set.of(fqqn1));
        configuration.putSecurityRoles(this.FQQN_FOR_USER2, Set.of(fqqn2));
        configuration.addQueueConfiguration(QueueConfiguration.of((String)this.FQQN_FOR_USER1).setAddress("fqqnAddress").setRoutingType(RoutingType.ANYCAST));
        configuration.addQueueConfiguration(QueueConfiguration.of((String)this.FQQN_FOR_USER2).setAddress("fqqnAddress").setRoutingType(RoutingType.ANYCAST));
    }

    @Test
    public void testAnonymousSendNoAuthToQueue() throws Exception {
        this.doTestAnonymousSendNoAuth(false);
    }

    @Test
    public void testAnonymousSendNoAuthToTopic() throws Exception {
        this.doTestAnonymousSendNoAuth(true);
    }

    private void doTestAnonymousSendNoAuth(boolean topic) throws Exception {
        try (Connection connection = this.factory.createConnection("deniedUser", this.PASS);){
            Session session = connection.createSession(false, 1);
            Object destination = topic ? session.createTopic("myAddress") : session.createQueue("myAddress");
            MessageProducer producer = session.createProducer(null);
            producer.setDeliveryMode(2);
            try {
                producer.send((Destination)destination, (Message)session.createTextMessage());
                Assertions.fail((String)"Should not be able to send to this destination");
            }
            catch (JMSSecurityException jMSSecurityException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testAnonymousSendWithAuthToQueue() throws Exception {
        this.doTestAnonymousSendWithAuth(false);
    }

    @Test
    public void testAnonymousSendWithAuthToTopic() throws Exception {
        this.doTestAnonymousSendWithAuth(true);
    }

    private void doTestAnonymousSendWithAuth(boolean topic) throws Exception {
        try (Connection connection = this.factory.createConnection("allowedUser", this.PASS);){
            Session session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer(null);
            Object destination = topic ? session.createTopic("myAddress") : session.createQueue("myAddress");
            producer.setDeliveryMode(2);
            try {
                producer.send((Destination)destination, session.createMessage());
            }
            catch (JMSSecurityException e) {
                Assertions.fail((String)("unexpected error: " + e.getMessage()));
            }
        }
    }

    @Test
    public void testSendWithAuthToQueue() throws Exception {
        this.doTestSendWithAuth(false);
    }

    @Test
    public void testSendWithAuthToTopic() throws Exception {
        this.doTestSendWithAuth(true);
    }

    private void doTestSendWithAuth(boolean topic) throws Exception {
        try (Connection connection = this.factory.createConnection("allowedUser", this.PASS);){
            Session session = connection.createSession(false, 1);
            Object destination = topic ? session.createTopic("myAddress") : session.createQueue("myAddress");
            MessageProducer producer = session.createProducer((Destination)destination);
            producer.setDeliveryMode(2);
            try {
                producer.send(session.createMessage());
            }
            catch (JMSSecurityException e) {
                Assertions.fail((String)("unexpected error: " + e.getMessage()));
            }
        }
    }

    @Test
    public void testCreateSenderNoAuthToQueue() throws Exception {
        this.doTestCreateSenderNoAuth(false);
    }

    @Test
    public void testCreateSenderNoAuthToTopic() throws Exception {
        this.doTestCreateSenderNoAuth(true);
    }

    private void doTestCreateSenderNoAuth(boolean topic) throws Exception {
        try (Connection connection = this.factory.createConnection("deniedUser", this.PASS);){
            Session session = connection.createSession(false, 1);
            Object destination = topic ? session.createTopic("myAddress") : session.createQueue("myAddress");
            try {
                session.createProducer((Destination)destination);
                Assertions.fail((String)"Should not be able to create producer on restricted destination");
            }
            catch (JMSSecurityException jMSSecurityException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testCreateSenderWithAuthToFQQNAsQueue() throws Exception {
        this.doTestCreateSenderWithAuthToFQQN(false);
    }

    @Test
    public void testCreateSenderWithAuthToFQQNAsTopic() throws Exception {
        this.doTestCreateSenderWithAuthToFQQN(true);
    }

    private void doTestCreateSenderWithAuthToFQQN(boolean topic) throws Exception {
        try (Connection connection = this.factory.createConnection("allowedUser", this.PASS);){
            Topic otherDestination;
            Topic destination;
            Session session = connection.createSession(false, 1);
            if (topic) {
                destination = session.createTopic(this.FQQN);
                otherDestination = session.createTopic(this.FQQN_ALTERNATE);
            } else {
                destination = session.createQueue(this.FQQN);
                otherDestination = session.createQueue(this.FQQN_ALTERNATE);
            }
            try {
                session.createProducer((Destination)destination);
            }
            catch (JMSSecurityException e) {
                Assertions.fail((String)("Should be able to send to given FQQN: " + e.getMessage()));
            }
            try {
                session.createProducer((Destination)otherDestination);
                Assertions.fail((String)"Should not be able to send to given alternate FQQN");
            }
            catch (JMSSecurityException jMSSecurityException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testCreateSenderNoAuthToFQQNAsQueue() throws Exception {
        this.doTestCreateSenderNoAuthToFQQN(false);
    }

    @Test
    public void testCreateSenderNoAuthToFQQNAsTopic() throws Exception {
        this.doTestCreateSenderNoAuthToFQQN(true);
    }

    private void doTestCreateSenderNoAuthToFQQN(boolean topic) throws Exception {
        try (Connection connection = this.factory.createConnection("deniedUser", this.PASS);){
            Session session = connection.createSession(false, 1);
            Object destination = topic ? session.createTopic(this.FQQN) : session.createQueue(this.FQQN);
            try {
                session.createProducer((Destination)destination);
                Assertions.fail((String)"Should not be able to send to given FQQN");
            }
            catch (JMSSecurityException jMSSecurityException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testAnonymousSenderWithAuthToFQQNAsQueue() throws Exception {
        this.doTestAnonymousSenderWithAuthToFQQN(false);
    }

    @Test
    public void testAnonymousSenderWithAuthToFQQNAsTopic() throws Exception {
        this.doTestAnonymousSenderWithAuthToFQQN(true);
    }

    private void doTestAnonymousSenderWithAuthToFQQN(boolean topic) throws Exception {
        try (Connection connection = this.factory.createConnection("allowedUser", this.PASS);){
            Topic otherDestination;
            Topic destination;
            Session session = connection.createSession(false, 1);
            if (topic) {
                destination = session.createTopic(this.FQQN);
                otherDestination = session.createTopic(this.FQQN_ALTERNATE);
            } else {
                destination = session.createQueue(this.FQQN);
                otherDestination = session.createQueue(this.FQQN_ALTERNATE);
            }
            MessageProducer producer = session.createProducer(null);
            producer.setDeliveryMode(2);
            try {
                producer.send((Destination)destination, session.createMessage());
            }
            catch (JMSSecurityException e) {
                Assertions.fail((String)("Should be able to send to given FQQN: " + e.getMessage()));
            }
            try {
                producer.send((Destination)otherDestination, session.createMessage());
                Assertions.fail((String)"Should not be able to send to given alternate FQQN");
            }
            catch (JMSSecurityException jMSSecurityException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testAnonymousSenderNoAuthToFQQNAsQueue() throws Exception {
        this.doTestAnonymousSenderNoAuthToFQQN(false);
    }

    @Test
    public void testAnonymousSenderNoAuthToFQQNAsTopic() throws Exception {
        this.doTestAnonymousSenderNoAuthToFQQN(true);
    }

    private void doTestAnonymousSenderNoAuthToFQQN(boolean topic) throws Exception {
        try (Connection connection = this.factory.createConnection("deniedUser", this.PASS);){
            Session session = connection.createSession(false, 1);
            Object destination = topic ? session.createTopic(this.FQQN) : session.createQueue(this.FQQN);
            MessageProducer producer = session.createProducer(null);
            producer.setDeliveryMode(2);
            try {
                producer.send((Destination)destination, session.createMessage());
                Assertions.fail((String)"Should not be able to send to given FQQN");
            }
            catch (JMSSecurityException jMSSecurityException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testCreateSendersWithFineGrainedAuthToFQQNAsQueues() throws Exception {
        this.doTestCreateSenderWithFineGrainedAuthToFQQNs(false);
    }

    @Test
    public void testCreateSendersWithFineGrainedAuthToFQQNAsTopics() throws Exception {
        this.doTestCreateSenderWithFineGrainedAuthToFQQNs(true);
    }

    private void doTestCreateSenderWithFineGrainedAuthToFQQNs(boolean topic) throws Exception {
        try (Connection connection1 = this.factory.createConnection("allowedUser", this.PASS);
             Connection connection2 = this.factory.createConnection("allowedUserAlternate", this.PASS);){
            Topic destination2;
            Topic destination1;
            Session session1 = connection1.createSession(false, 1);
            Session session2 = connection2.createSession(false, 1);
            if (topic) {
                destination1 = session1.createTopic(this.FQQN);
                destination2 = session2.createTopic(this.FQQN_ALTERNATE);
            } else {
                destination1 = session1.createQueue(this.FQQN);
                destination2 = session2.createQueue(this.FQQN_ALTERNATE);
            }
            try {
                session1.createProducer((Destination)destination1);
            }
            catch (JMSSecurityException e) {
                Assertions.fail((String)("Should be able to create sender to given FQQN: " + e.getMessage()));
            }
            try {
                session1.createProducer((Destination)destination2);
                Assertions.fail((String)"Should not be able to create sender to given FQQN");
            }
            catch (JMSSecurityException e) {
                // empty catch block
            }
            try {
                session2.createProducer((Destination)destination2);
            }
            catch (JMSSecurityException e) {
                Assertions.fail((String)("Should be able to create sender to given FQQN: " + e.getMessage()));
            }
            try {
                session2.createProducer((Destination)destination1);
                Assertions.fail((String)"Should not be able to create sender to given FQQN");
            }
            catch (JMSSecurityException jMSSecurityException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testAnonymousSendersWithFineGrainedAuthToFQQNAsQueues() throws Exception {
        this.doTestAnonymousSenderWithFineGrainedAuthToFQQNs(false);
    }

    @Test
    public void testAnonymousSendersWithFineGrainedAuthToFQQNAsTopics() throws Exception {
        this.doTestAnonymousSenderWithFineGrainedAuthToFQQNs(true);
    }

    private void doTestAnonymousSenderWithFineGrainedAuthToFQQNs(boolean topic) throws Exception {
        try (Connection connection1 = this.factory.createConnection("allowedUser", this.PASS);
             Connection connection2 = this.factory.createConnection("allowedUserAlternate", this.PASS);){
            Topic destination2;
            Topic destination1;
            Session session1 = connection1.createSession(false, 1);
            Session session2 = connection2.createSession(false, 1);
            if (topic) {
                destination1 = session1.createTopic(this.FQQN);
                destination2 = session2.createTopic(this.FQQN_ALTERNATE);
            } else {
                destination1 = session1.createQueue(this.FQQN);
                destination2 = session2.createQueue(this.FQQN_ALTERNATE);
            }
            MessageProducer producer1 = session1.createProducer(null);
            MessageProducer producer2 = session2.createProducer(null);
            producer1.setDeliveryMode(2);
            producer2.setDeliveryMode(2);
            try {
                producer1.send((Destination)destination1, session1.createMessage());
            }
            catch (JMSSecurityException e) {
                Assertions.fail((String)("Should be able to send to given FQQN: " + e.getMessage()));
            }
            try {
                producer1.send((Destination)destination2, session1.createMessage());
                Assertions.fail((String)"Should not be able to send to given FQQN");
            }
            catch (JMSSecurityException e) {
                // empty catch block
            }
            try {
                producer2.send((Destination)destination2, session2.createMessage());
            }
            catch (JMSSecurityException e) {
                Assertions.fail((String)("Should be able to send to given FQQN: " + e.getMessage()));
            }
            try {
                producer2.send((Destination)destination1, session2.createMessage());
                Assertions.fail((String)"Should not be able to send to given FQQN");
            }
            catch (JMSSecurityException jMSSecurityException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testCreateSenderNoAuthToCompositeAsQueue() throws Exception {
        this.doTestCreateSenderNoAuthToComposite(false);
    }

    @Test
    public void testCreateSenderNoAuthToCompositeAsTopic() throws Exception {
        this.doTestCreateSenderNoAuthToComposite(true);
    }

    private void doTestCreateSenderNoAuthToComposite(boolean topic) throws Exception {
        try (Connection connection = this.factory.createConnection("deniedUser", this.PASS);){
            Session session = connection.createSession(false, 1);
            Object destination = topic ? session.createTopic("myAddress,myOtherAddress") : session.createQueue("myAddress,myOtherAddress");
            try {
                session.createProducer((Destination)destination);
                Assertions.fail((String)"Should not be able to create a producer to given composite destination");
            }
            catch (JMSSecurityException jMSSecurityException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testAnonymousSenderNoAuthToCompositeAsQueue() throws Exception {
        this.doTestAnonymousSenderNoAuthToComposite(false);
    }

    @Test
    public void testAnonymousSenderNoAuthToCompositeAsTopic() throws Exception {
        this.doTestAnonymousSenderNoAuthToComposite(true);
    }

    private void doTestAnonymousSenderNoAuthToComposite(boolean topic) throws Exception {
        try (Connection connection = this.factory.createConnection("deniedUser", this.PASS);){
            Session session = connection.createSession(false, 1);
            Object destination = topic ? session.createTopic("myAddress,myOtherAddress") : session.createQueue("myAddress,myOtherAddress");
            MessageProducer producer = session.createProducer(null);
            producer.setDeliveryMode(2);
            try {
                producer.send((Destination)destination, session.createMessage());
                Assertions.fail((String)"Should not be able to send to given composite destination");
            }
            catch (JMSSecurityException jMSSecurityException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testFQQNUserIsolationUnderSameAddressOnSenderCreate() throws Exception {
        try (Connection connection1 = this.factory.createConnection("fqqnUser1", this.PASS);
             Connection connection2 = this.factory.createConnection("fqqnUser2", this.PASS);){
            Session session1 = connection1.createSession(false, 1);
            Session session2 = connection2.createSession(false, 1);
            Queue destination1 = session1.createQueue(this.FQQN_FOR_USER1);
            Queue destination2 = session2.createQueue(this.FQQN_FOR_USER2);
            try {
                session1.createProducer((Destination)destination1);
            }
            catch (JMSSecurityException e) {
                Assertions.fail((String)("Should be able to create sender to given FQQN: " + e.getMessage()));
            }
            try {
                session1.createProducer((Destination)destination2);
                Assertions.fail((String)"Should not be able to create sender to given FQQN");
            }
            catch (JMSSecurityException e) {
                // empty catch block
            }
            try {
                session2.createProducer((Destination)destination2);
            }
            catch (JMSSecurityException e) {
                Assertions.fail((String)("Should be able to create sender to given FQQN: " + e.getMessage()));
            }
            try {
                session2.createProducer((Destination)destination1);
                Assertions.fail((String)"Should not be able to create sender to given FQQN");
            }
            catch (JMSSecurityException jMSSecurityException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testFQQNUserIsolationUnderSameAddressWithAnonymousSends() throws Exception {
        try (Connection connection1 = this.factory.createConnection("fqqnUser1", this.PASS);
             Connection connection2 = this.factory.createConnection("fqqnUser2", this.PASS);){
            Session session1 = connection1.createSession(false, 1);
            Session session2 = connection2.createSession(false, 1);
            Queue destination1 = session1.createQueue(this.FQQN_FOR_USER1);
            Queue destination2 = session2.createQueue(this.FQQN_FOR_USER2);
            MessageProducer producer1 = session1.createProducer(null);
            MessageProducer producer2 = session2.createProducer(null);
            try {
                producer1.send((Destination)destination1, session1.createMessage());
            }
            catch (JMSSecurityException e) {
                Assertions.fail((String)("Should be able to send to given FQQN: " + e.getMessage()));
            }
            try {
                producer1.send((Destination)destination2, session1.createMessage());
                Assertions.fail((String)"Should not be able to send to given FQQN");
            }
            catch (JMSSecurityException e) {
                // empty catch block
            }
            try {
                producer2.send((Destination)destination2, session1.createMessage());
            }
            catch (JMSSecurityException e) {
                Assertions.fail((String)("Should be able to send to given FQQN: " + e.getMessage()));
            }
            try {
                producer2.send((Destination)destination1, session1.createMessage());
                Assertions.fail((String)"Should not be able to send to given FQQN");
            }
            catch (JMSSecurityException jMSSecurityException) {
                // empty catch block
            }
        }
    }
}

