/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.openwire.OpenWireTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={ParameterizedTestExtension.class})
public class FQQNOpenWireTest
extends OpenWireTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private SimpleString anycastAddress = SimpleString.of((String)"address.anycast");
    private SimpleString multicastAddress = SimpleString.of((String)"address.multicast");
    private SimpleString anycastQ1 = SimpleString.of((String)"q1");
    private SimpleString anycastQ2 = SimpleString.of((String)"q2");
    private SimpleString anycastQ3 = SimpleString.of((String)"q3");
    private ConnectionFactory factory;
    private ServerLocator locator;

    @Parameters(name="{0}")
    public static Collection<Object[]> params() {
        return Arrays.asList({"OpenWire"}, {"Artemis"});
    }

    public FQQNOpenWireTest(String factoryType) {
        if ("OpenWire".equals(factoryType)) {
            this.factory = new ActiveMQConnectionFactory("tcp://localhost:61616?wireFormat.cacheEnabled=true");
        } else if ("Artemis".equals(factoryType)) {
            this.factory = new org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory("tcp://localhost:61616?wireFormat.cacheEnabled=true");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testTopic() throws Exception {
        try (Connection connection = this.factory.createConnection();){
            connection.setClientID("FQQNconn");
            connection.start();
            Session session = connection.createSession(false, 1);
            Topic topic = session.createTopic(this.multicastAddress.toString());
            MessageConsumer consumer1 = session.createConsumer((Destination)topic);
            MessageConsumer consumer2 = session.createConsumer((Destination)topic);
            MessageConsumer consumer3 = session.createConsumer((Destination)topic);
            MessageProducer producer = session.createProducer((Destination)topic);
            producer.send(session.createMessage());
            Message m = consumer1.receive(2000L);
            Assertions.assertNotNull((Object)m);
            m = consumer2.receive(2000L);
            Assertions.assertNotNull((Object)m);
            m = consumer3.receive(2000L);
            Assertions.assertNotNull((Object)m);
            Bindings bindings = this.server.getPostOffice().getBindingsForAddress(this.multicastAddress);
            for (Binding b : bindings.getBindings()) {
                logger.debug("checking binidng {} {}", (Object)b.getUniqueName(), (Object)((LocalQueueBinding)b).getQueue().getDeliveringMessages());
                SimpleString qName = b.getUniqueName();
                QueueQueryResult result = this.server.queueQuery(CompositeAddress.toFullyQualified((SimpleString)this.multicastAddress, (SimpleString)qName));
                Assertions.assertTrue((boolean)result.isExists());
                Assertions.assertEquals((Object)result.getName(), (Object)qName);
                result = this.server.queueQuery(qName);
                Assertions.assertTrue((boolean)result.isExists());
                Assertions.assertEquals((Object)result.getName(), (Object)qName);
            }
        }
    }

    @TestTemplate
    public void testTopicFQQNSendAndConsumeAutoCreate() throws Exception {
        this.internalTopicFQQNSendAndConsume(true);
    }

    @TestTemplate
    public void testTopicFQQNSendAndConsumeManualCreate() throws Exception {
        this.internalTopicFQQNSendAndConsume(false);
    }

    private void internalTopicFQQNSendAndConsume(boolean autocreate) throws Exception {
        if (autocreate) {
            this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(true)).setAutoCreateQueues(Boolean.valueOf(true)));
        } else {
            this.server.createQueue(QueueConfiguration.of((SimpleString)this.anycastQ1).setAddress(this.multicastAddress).setDurable(Boolean.valueOf(false)));
        }
        try (Connection connection = this.factory.createConnection();){
            connection.setClientID("FQQNconn");
            connection.start();
            Session session = connection.createSession(false, 1);
            Topic topic = session.createTopic(CompositeAddress.toFullyQualified((SimpleString)this.multicastAddress, (SimpleString)this.anycastQ1).toString());
            MessageConsumer consumer1 = session.createConsumer((Destination)topic);
            MessageConsumer consumer2 = session.createConsumer((Destination)topic);
            MessageConsumer consumer3 = session.createConsumer((Destination)topic);
            MessageProducer producer = session.createProducer((Destination)topic);
            producer.send(session.createMessage());
            Message m = consumer1.receive(2000L);
            Assertions.assertNotNull((Object)m);
            m = consumer2.receiveNoWait();
            Assertions.assertNull((Object)m);
            m = consumer3.receiveNoWait();
            Assertions.assertNull((Object)m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testQueueConsumerReceiveTopicUsingFQQN() throws Exception {
        SimpleString queueName1 = SimpleString.of((String)"sub.queue1");
        SimpleString queueName2 = SimpleString.of((String)"sub.queue2");
        this.server.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(this.multicastAddress).setDurable(Boolean.valueOf(false)));
        this.server.createQueue(QueueConfiguration.of((SimpleString)queueName2).setAddress(this.multicastAddress).setDurable(Boolean.valueOf(false)));
        try (Connection connection = this.factory.createConnection();){
            connection.start();
            Session session = connection.createSession(false, 1);
            Queue fqqn1 = session.createQueue(this.multicastAddress.toString() + "::" + queueName1);
            Queue fqqn2 = session.createQueue(this.multicastAddress.toString() + "::" + queueName2);
            MessageConsumer consumer1 = session.createConsumer((Destination)fqqn1);
            MessageConsumer consumer2 = session.createConsumer((Destination)fqqn2);
            Topic topic = session.createTopic(this.multicastAddress.toString());
            MessageProducer producer = session.createProducer((Destination)topic);
            producer.send(session.createMessage());
            Message m = consumer1.receive(2000L);
            Assertions.assertNotNull((Object)m);
            m = consumer2.receive(2000L);
            Assertions.assertNotNull((Object)m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testQueue() throws Exception {
        this.server.getAddressSettingsRepository().addMatch("#", (Object)new AddressSettings().setAutoCreateQueues(Boolean.valueOf(true)).setAutoCreateAddresses(Boolean.valueOf(true)));
        Connection connection = this.factory.createConnection();
        try {
            connection.start();
            Session session = connection.createSession(false, 1);
            Queue q1 = session.createQueue(CompositeAddress.toFullyQualified((SimpleString)this.anycastAddress, (SimpleString)this.anycastQ1).toString());
            Queue q2 = session.createQueue(CompositeAddress.toFullyQualified((SimpleString)this.anycastAddress, (SimpleString)this.anycastQ2).toString());
            Queue q3 = session.createQueue(CompositeAddress.toFullyQualified((SimpleString)this.anycastAddress, (SimpleString)this.anycastQ3).toString());
            MessageProducer producer1 = session.createProducer((Destination)q1);
            producer1.send(session.createMessage());
            producer1.send(session.createMessage());
            Assertions.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(this.anycastQ1).getMessageCount() == 2L, (long)2000L, (long)200L));
            MessageProducer producer2 = session.createProducer((Destination)q2);
            producer2.send(session.createMessage());
            producer2.send(session.createMessage());
            producer2.send(session.createMessage());
            Assertions.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(this.anycastQ2).getMessageCount() == 3L, (long)2000L, (long)200L));
            MessageProducer producer3 = session.createProducer((Destination)q3);
            producer3.send(session.createMessage());
            producer3.send(session.createMessage());
            producer3.send(session.createMessage());
            producer3.send(session.createMessage());
            producer3.send(session.createMessage());
            Assertions.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(this.anycastQ3).getMessageCount() == 5L, (long)2000L, (long)200L));
            MessageConsumer consumer1 = session.createConsumer((Destination)q1);
            MessageConsumer consumer2 = session.createConsumer((Destination)q2);
            MessageConsumer consumer3 = session.createConsumer((Destination)q3);
            Assertions.assertNotNull((Object)consumer1.receive(2000L));
            Assertions.assertNotNull((Object)consumer1.receive(2000L));
            Assertions.assertNotNull((Object)consumer2.receive(2000L));
            Assertions.assertNotNull((Object)consumer2.receive(2000L));
            Assertions.assertNotNull((Object)consumer2.receive(2000L));
            Assertions.assertNotNull((Object)consumer3.receive(2000L));
            Assertions.assertNotNull((Object)consumer3.receive(2000L));
            Assertions.assertNotNull((Object)consumer3.receive(2000L));
            Assertions.assertNotNull((Object)consumer3.receive(2000L));
            Assertions.assertNotNull((Object)consumer3.receive(2000L));
            connection.close();
            for (SimpleString q : new SimpleString[]{this.anycastQ1, this.anycastQ2, this.anycastQ3}) {
                QueueQueryResult query = this.server.queueQuery(CompositeAddress.toFullyQualified((SimpleString)this.anycastAddress, (SimpleString)q));
                Assertions.assertTrue((query.isExists() || query.isAutoCreateQueues() ? (byte)1 : 0) != 0);
                Assertions.assertEquals((Object)this.anycastAddress, (Object)query.getAddress());
                Assertions.assertEquals((Object)q, (Object)query.getName());
                Assertions.assertEquals((long)0L, (long)query.getMessageCount());
                query = this.server.queueQuery(q);
                Assertions.assertEquals((Object)q, (Object)query.getName());
            }
        }
        finally {
            connection.close();
            if (this.locator != null) {
                this.locator.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testFQNConsumer() throws Exception {
        Connection exConn = null;
        SimpleString durableQueue = SimpleString.of((String)"myqueue");
        this.server.createQueue(QueueConfiguration.of((SimpleString)durableQueue).setRoutingType(RoutingType.ANYCAST));
        try {
            ActiveMQConnectionFactory exFact = new ActiveMQConnectionFactory();
            exConn = exFact.createConnection();
            exConn.start();
            Session session = exConn.createSession(false, 1);
            Queue destination = session.createQueue(durableQueue.toString());
            MessageProducer producer = session.createProducer((Destination)destination);
            TextMessage message = session.createTextMessage("This is a text message");
            producer.send((Message)message);
            Queue destinationFQN = session.createQueue(CompositeAddress.toFullyQualified((SimpleString)durableQueue, (SimpleString)durableQueue).toString());
            MessageConsumer messageConsumer = session.createConsumer((Destination)destinationFQN);
            TextMessage messageReceived = (TextMessage)messageConsumer.receive(5000L);
            Assertions.assertEquals((Object)"This is a text message", (Object)messageReceived.getText());
        }
        finally {
            if (exConn != null) {
                exConn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testSpecialFQQNCase() throws Exception {
        Connection exConn = null;
        SimpleString durableQueue = SimpleString.of((String)"myqueue");
        this.server.createQueue(QueueConfiguration.of((SimpleString)durableQueue).setRoutingType(RoutingType.ANYCAST));
        try {
            ActiveMQConnectionFactory exFact = new ActiveMQConnectionFactory();
            exConn = exFact.createConnection();
            exConn.start();
            Session session = exConn.createSession(false, 1);
            Queue destination = session.createQueue(durableQueue.toString());
            MessageProducer producer = session.createProducer((Destination)destination);
            TextMessage message = session.createTextMessage("This is a text message");
            producer.send((Message)message);
            Queue destinationFQN = session.createQueue("::" + durableQueue);
            MessageConsumer messageConsumer = session.createConsumer((Destination)destinationFQN);
            TextMessage messageReceived = (TextMessage)messageConsumer.receive(5000L);
            Assertions.assertEquals((Object)"This is a text message", (Object)messageReceived.getText());
            messageConsumer.close();
            destinationFQN = session.createQueue(durableQueue + "::");
            try {
                session.createConsumer((Destination)destinationFQN);
                Assertions.fail((String)"should get exception");
            }
            catch (InvalidDestinationException invalidDestinationException) {
                // empty catch block
            }
            destinationFQN = session.createQueue("::");
            try {
                session.createConsumer((Destination)destinationFQN);
                Assertions.fail((String)"should get exception");
            }
            catch (InvalidDestinationException invalidDestinationException) {
                // empty catch block
            }
        }
        finally {
            if (exConn != null) {
                exConn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testVirtualTopicFQQN() throws Exception {
        Connection exConn = null;
        SimpleString topic = SimpleString.of((String)"VirtualTopic.Orders");
        SimpleString subscriptionQ = SimpleString.of((String)"Consumer.A");
        this.server.addAddressInfo(new AddressInfo(topic, RoutingType.MULTICAST));
        this.server.createQueue(QueueConfiguration.of((SimpleString)subscriptionQ).setAddress(topic));
        try {
            ActiveMQConnectionFactory exFact = new ActiveMQConnectionFactory();
            exFact.setWatchTopicAdvisories(false);
            exConn = exFact.createConnection();
            exConn.start();
            Session session = exConn.createSession(false, 1);
            Topic destination = session.createTopic(topic.toString());
            MessageProducer producer = session.createProducer((Destination)destination);
            Queue destinationFQN = session.createQueue(CompositeAddress.toFullyQualified((SimpleString)topic, (SimpleString)subscriptionQ).toString());
            MessageConsumer messageConsumerA = session.createConsumer((Destination)destinationFQN);
            MessageConsumer messageConsumerB = session.createConsumer((Destination)destinationFQN);
            TextMessage message = session.createTextMessage("This is a text message");
            producer.send((Message)message);
            TextMessage messageReceivedA = (TextMessage)messageConsumerA.receive(2000L);
            TextMessage messageReceivedB = (TextMessage)messageConsumerB.receive(2000L);
            Assertions.assertTrue((messageReceivedA == null || messageReceivedB == null ? (byte)1 : 0) != 0);
            String text = messageReceivedA != null ? messageReceivedA.getText() : messageReceivedB.getText();
            Assertions.assertEquals((Object)"This is a text message", (Object)text);
            messageConsumerA.close();
            messageConsumerB.close();
        }
        finally {
            if (exConn != null) {
                exConn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testVirtualTopicFQQNAutoCreateQueue() throws Exception {
        Connection exConn = null;
        SimpleString topic = SimpleString.of((String)"VirtualTopic.Orders");
        SimpleString subscriptionQ = SimpleString.of((String)"Consumer.A");
        this.server.addAddressInfo(new AddressInfo(topic, RoutingType.MULTICAST));
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("VirtualTopic.#")).setAutoCreateQueues(Boolean.valueOf(true));
        try {
            ActiveMQConnectionFactory exFact = new ActiveMQConnectionFactory();
            exFact.setWatchTopicAdvisories(false);
            exConn = exFact.createConnection();
            exConn.start();
            Session session = exConn.createSession(false, 1);
            Topic destination = session.createTopic(topic.toString());
            MessageProducer producer = session.createProducer((Destination)destination);
            Queue destinationFQN = session.createQueue(CompositeAddress.toFullyQualified((SimpleString)topic, (SimpleString)subscriptionQ).toString());
            MessageConsumer messageConsumerA = session.createConsumer((Destination)destinationFQN);
            MessageConsumer messageConsumerB = session.createConsumer((Destination)destinationFQN);
            TextMessage message = session.createTextMessage("This is a text message");
            producer.send((Message)message);
            TextMessage messageReceivedA = (TextMessage)messageConsumerA.receive(2000L);
            TextMessage messageReceivedB = (TextMessage)messageConsumerB.receive(2000L);
            Assertions.assertTrue((messageReceivedA == null || messageReceivedB == null ? (byte)1 : 0) != 0);
            String text = messageReceivedA != null ? messageReceivedA.getText() : messageReceivedB.getText();
            Assertions.assertEquals((Object)"This is a text message", (Object)text);
            messageConsumerA.close();
            messageConsumerB.close();
        }
        finally {
            if (exConn != null) {
                exConn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testVirtualTopicFQQNAutoCreateQAndAddress() throws Exception {
        Connection exConn = null;
        SimpleString topic = SimpleString.of((String)"VirtualTopic.Orders");
        SimpleString subscriptionQ = SimpleString.of((String)"Consumer.A");
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("VirtualTopic.#")).setAutoCreateQueues(Boolean.valueOf(true));
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("VirtualTopic.#")).setAutoCreateAddresses(Boolean.valueOf(true));
        try {
            ActiveMQConnectionFactory exFact = new ActiveMQConnectionFactory();
            exFact.setWatchTopicAdvisories(false);
            exConn = exFact.createConnection();
            exConn.start();
            Session session = exConn.createSession(false, 1);
            Topic destination = session.createTopic(topic.toString());
            MessageProducer producer = session.createProducer((Destination)destination);
            Queue destinationFQN = session.createQueue(CompositeAddress.toFullyQualified((SimpleString)topic, (SimpleString)subscriptionQ).toString());
            MessageConsumer messageConsumerA = session.createConsumer((Destination)destinationFQN);
            MessageConsumer messageConsumerB = session.createConsumer((Destination)destinationFQN);
            TextMessage message = session.createTextMessage("This is a text message");
            producer.send((Message)message);
            TextMessage messageReceivedA = (TextMessage)messageConsumerA.receive(2000L);
            TextMessage messageReceivedB = (TextMessage)messageConsumerB.receive(2000L);
            Assertions.assertTrue((messageReceivedA == null || messageReceivedB == null ? (byte)1 : 0) != 0);
            String text = messageReceivedA != null ? messageReceivedA.getText() : messageReceivedB.getText();
            Assertions.assertEquals((Object)"This is a text message", (Object)text);
            messageConsumerA.close();
            messageConsumerB.close();
        }
        finally {
            if (exConn != null) {
                exConn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testVirtualTopicFQQNConsumerAutoCreateQAndAddress() throws Exception {
        Connection exConn = null;
        SimpleString topic = SimpleString.of((String)"VirtualTopic.Orders");
        SimpleString subscriptionQ = SimpleString.of((String)"Consumer.A");
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("VirtualTopic.#")).setAutoCreateQueues(Boolean.valueOf(true));
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("VirtualTopic.#")).setAutoCreateAddresses(Boolean.valueOf(true));
        try {
            ActiveMQConnectionFactory exFact = new ActiveMQConnectionFactory();
            exFact.setWatchTopicAdvisories(false);
            exConn = exFact.createConnection();
            exConn.start();
            Session session = exConn.createSession(false, 1);
            Topic destination = session.createTopic(topic.toString());
            Queue destinationFQN = session.createQueue(CompositeAddress.toFullyQualified((SimpleString)topic, (SimpleString)subscriptionQ).toString());
            MessageConsumer messageConsumerA = session.createConsumer((Destination)destinationFQN);
            MessageConsumer messageConsumerB = session.createConsumer((Destination)destinationFQN);
            MessageProducer producer = session.createProducer((Destination)destination);
            TextMessage message = session.createTextMessage("This is a text message");
            producer.send((Message)message);
            TextMessage messageReceivedA = (TextMessage)messageConsumerA.receive(2000L);
            TextMessage messageReceivedB = (TextMessage)messageConsumerB.receive(2000L);
            Assertions.assertTrue((messageReceivedA == null || messageReceivedB == null ? (byte)1 : 0) != 0);
            String text = messageReceivedA != null ? messageReceivedA.getText() : messageReceivedB.getText();
            Assertions.assertEquals((Object)"This is a text message", (Object)text);
            messageConsumerA.close();
            messageConsumerB.close();
        }
        finally {
            if (exConn != null) {
                exConn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testVirtualTopicFQQNAutoCreateQWithExistingAddressWithAnyCastDefault() throws Exception {
        Connection exConn = null;
        SimpleString topic = SimpleString.of((String)"VirtualTopic.Orders");
        SimpleString subscriptionQ = SimpleString.of((String)"Consumer.A");
        this.server.addAddressInfo(new AddressInfo(topic, RoutingType.MULTICAST));
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("VirtualTopic.#")).setAutoCreateQueues(Boolean.valueOf(true));
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("VirtualTopic.#")).setAutoCreateAddresses(Boolean.valueOf(false));
        ((AddressSettings)this.server.getAddressSettingsRepository().getMatch("VirtualTopic.#")).setDefaultAddressRoutingType(RoutingType.ANYCAST);
        try {
            ActiveMQConnectionFactory exFact = new ActiveMQConnectionFactory();
            exFact.setWatchTopicAdvisories(false);
            exConn = exFact.createConnection();
            exConn.start();
            Session session = exConn.createSession(false, 1);
            Topic destination = session.createTopic(topic.toString());
            MessageProducer producer = session.createProducer((Destination)destination);
            Queue destinationFQN = session.createQueue(CompositeAddress.toFullyQualified((SimpleString)topic, (SimpleString)subscriptionQ).toString());
            MessageConsumer messageConsumerA = session.createConsumer((Destination)destinationFQN);
            MessageConsumer messageConsumerB = session.createConsumer((Destination)destinationFQN);
            TextMessage message = session.createTextMessage("This is a text message");
            producer.send((Message)message);
            TextMessage messageReceivedA = (TextMessage)messageConsumerA.receive(2000L);
            TextMessage messageReceivedB = (TextMessage)messageConsumerB.receive(2000L);
            Assertions.assertTrue((messageReceivedA == null || messageReceivedB == null ? (byte)1 : 0) != 0);
            String text = messageReceivedA != null ? messageReceivedA.getText() : messageReceivedB.getText();
            Assertions.assertEquals((Object)"This is a text message", (Object)text);
            messageConsumerA.close();
            messageConsumerB.close();
        }
        finally {
            if (exConn != null) {
                exConn.close();
            }
        }
    }
}

