/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt5.spec.controlpackets;

import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPubReplyMessageVariableHeader;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTInterceptor;
import org.apache.activemq.artemis.tests.integration.mqtt5.MQTT5TestSupport;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class PubRelTests
extends MQTT5TestSupport {
    @Test
    @Timeout(value=60L)
    public void testPubRelReasonCode() throws Exception {
        String TOPIC = RandomUtil.randomString();
        CountDownLatch latch = new CountDownLatch(2);
        MQTTInterceptor outgoingInterceptor = (packet, connection) -> {
            if (packet.fixedHeader().messageType() == MqttMessageType.PUBREL) {
                Assertions.assertEquals((byte)0, (byte)((MqttPubReplyMessageVariableHeader)packet.variableHeader()).reasonCode());
                latch.countDown();
            }
            return true;
        };
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)outgoingInterceptor);
        MqttClient consumer = this.createPahoClient("consumer");
        consumer.connect();
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(this, latch));
        consumer.subscribe(TOPIC, 2);
        MqttClient publisher = this.createPahoClient("publisher");
        publisher.connect();
        publisher.publish(TOPIC, new byte[0], 2, false);
        Assertions.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        publisher.disconnect();
        publisher.close();
    }
}

