/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import java.util.Set;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.integration.management.SecurityManagementTestBase;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class SecurityManagementWithConfiguredAdminUserTest
extends SecurityManagementTestBase {
    private final String validAdminUser = "validAdminUser";
    private final String validAdminPassword = "validAdminPassword";
    private final String invalidAdminUser = "invalidAdminUser";
    private final String invalidAdminPassword = "invalidAdminPassword";

    @TestTemplate
    public void testSendManagementMessageWithClusterAdminUser() throws Exception {
        this.doSendBrokerManagementMessage(ActiveMQDefaultConfiguration.getDefaultClusterUser(), "UnitTestsClusterPassword", true);
    }

    @TestTemplate
    public void testSendManagementMessageWithAdminRole() throws Exception {
        this.doSendBrokerManagementMessage("validAdminUser", "validAdminPassword", true);
    }

    @TestTemplate
    public void testSendManagementMessageWithoutAdminRole() throws Exception {
        this.doSendBrokerManagementMessage("invalidAdminUser", "invalidAdminPassword", false);
    }

    @TestTemplate
    public void testSendManagementMessageWithoutUserCredentials() throws Exception {
        this.doSendBrokerManagementMessage(null, null, false);
    }

    @Override
    protected ActiveMQServer setupAndStartActiveMQServer() throws Exception {
        Configuration config = this.createDefaultInVMConfig().setSecurityEnabled(true);
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)config, (boolean)false));
        server.start();
        HierarchicalRepository securityRepository = server.getSecurityRepository();
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
        securityManager.getConfiguration().addUser("validAdminUser", "validAdminPassword");
        securityManager.getConfiguration().addUser("invalidAdminUser", "invalidAdminPassword");
        securityManager.getConfiguration().addRole("validAdminUser", "admin");
        securityManager.getConfiguration().addRole("validAdminUser", "guest");
        securityManager.getConfiguration().addRole("invalidAdminUser", "guest");
        Set adminRole = (Set)securityRepository.getMatch(ActiveMQDefaultConfiguration.getDefaultManagementAddress().toString());
        adminRole.add(new Role("admin", true, true, true, true, true, true, true, true, true, true, this.managementRbac, this.managementRbac));
        securityRepository.addMatch(ActiveMQDefaultConfiguration.getDefaultManagementAddress().toString(), (Object)adminRole);
        Set guestRole = (Set)securityRepository.getMatch("*");
        guestRole.add(new Role("guest", true, true, true, true, true, true, false, true, true, true, false, false));
        securityRepository.addMatch("*", (Object)guestRole);
        return server;
    }
}

