/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.server.plugin.impl.BrokerMessageAuthorizationPlugin;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.tests.integration.security.SecurityTest;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MessageAuthorizationTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private SimpleString QUEUE = SimpleString.of((String)"TestQueue");
    private SimpleString TOPIC = SimpleString.of((String)"TestTopic");

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        ActiveMQJAASSecurityManager securityManager = new ActiveMQJAASSecurityManager("PropertiesLogin");
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultNettyConfig().setSecurityEnabled(true), (MBeanServer)ManagementFactory.getPlatformMBeanServer(), (ActiveMQSecurityManager)securityManager, (boolean)true));
        this.server.getConfiguration().setPopulateValidatedUser(true);
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(new Role("programmers", true, true, true, true, true, true, true, true, true, true, false, false));
        roles.add(new Role("a", false, true, true, true, true, false, false, false, true, true, false, false));
        roles.add(new Role("b", false, true, true, true, true, false, false, false, true, true, false, false));
        this.server.getConfiguration().putSecurityRoles("#", roles);
        BrokerMessageAuthorizationPlugin plugin = new BrokerMessageAuthorizationPlugin();
        plugin.init(Collections.emptyMap());
        this.server.registerBrokerPlugin((ActiveMQServerBasePlugin)plugin);
        this.server.start();
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.QUEUE).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(true)));
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.TOPIC).setRoutingType(RoutingType.MULTICAST).setDurable(Boolean.valueOf(true)));
    }

    @Test
    public void testMessageAuthorizationQueue() throws Exception {
        JmsConnectionFactory factory = new JmsConnectionFactory("amqp://127.0.0.1:61616");
        Connection connection = factory.createConnection("first", "secret");
        Session session = connection.createSession(false, 1);
        Queue queue = session.createQueue(this.QUEUE.toString());
        MessageProducer producer = session.createProducer((Destination)queue);
        TextMessage aMessage = session.createTextMessage();
        aMessage.setStringProperty("requiredRole", "a");
        TextMessage bMessage = session.createTextMessage();
        bMessage.setStringProperty("requiredRole", "b");
        Connection aConnection = factory.createConnection("a", "a");
        Session aSession = aConnection.createSession(false, 1);
        aConnection.start();
        Connection bConnection = factory.createConnection("b", "b");
        Session bSession = bConnection.createSession(false, 1);
        bConnection.start();
        MessageConsumer aConsumer = aSession.createConsumer((Destination)queue);
        MessageConsumer bConsumer = bSession.createConsumer((Destination)queue);
        producer.send((Message)aMessage);
        producer.send((Message)bMessage);
        connection.close();
        Message aMsg = aConsumer.receiveNoWait();
        Assertions.assertNotNull((Object)aMsg);
        Assertions.assertEquals((Object)"a", (Object)aMsg.getStringProperty("requiredRole"));
        Message bMsg = bConsumer.receiveNoWait();
        Assertions.assertNotNull((Object)bMsg);
        Assertions.assertEquals((Object)"b", (Object)bMsg.getStringProperty("requiredRole"));
        aConnection.close();
        bConnection.close();
    }

    @Test
    public void testMessageAuthorizationQueueNotAuthorized() throws Exception {
        JmsConnectionFactory factory = new JmsConnectionFactory("amqp://127.0.0.1:61616");
        Connection connection = factory.createConnection("first", "secret");
        Session session = connection.createSession(false, 1);
        Queue queue = session.createQueue("TestQueueNotAuth");
        MessageProducer producer = session.createProducer((Destination)queue);
        TextMessage bMessage = session.createTextMessage();
        bMessage.setStringProperty("requiredRole", "b");
        Connection aConnection = factory.createConnection("a", "a");
        Session aSession = aConnection.createSession(false, 1);
        aConnection.start();
        MessageConsumer aConsumer = aSession.createConsumer((Destination)queue);
        producer.send((Message)bMessage);
        connection.close();
        Assertions.assertNull((Object)aConsumer.receiveNoWait());
        aConnection.close();
    }

    @Test
    public void testMessageAuthorizationTopic() throws Exception {
        JmsConnectionFactory factory = new JmsConnectionFactory("amqp://127.0.0.1:61616");
        Connection connection = factory.createConnection("first", "secret");
        Session session = connection.createSession(false, 1);
        Topic topic = session.createTopic(this.TOPIC.toString());
        MessageProducer producer = session.createProducer((Destination)topic);
        TextMessage aMessage = session.createTextMessage();
        aMessage.setStringProperty("requiredRole", "a");
        TextMessage bMessage = session.createTextMessage();
        bMessage.setStringProperty("requiredRole", "b");
        Connection aConnection = factory.createConnection("a", "a");
        Session aSession = aConnection.createSession(false, 1);
        aConnection.start();
        Connection bConnection = factory.createConnection("b", "b");
        Session bSession = bConnection.createSession(false, 1);
        bConnection.start();
        MessageConsumer aConsumer = aSession.createConsumer((Destination)topic);
        MessageConsumer bConsumer = bSession.createConsumer((Destination)topic);
        producer.send((Message)aMessage);
        producer.send((Message)bMessage);
        connection.close();
        Message bMsg = bConsumer.receiveNoWait();
        Assertions.assertNotNull((Object)bMsg);
        Assertions.assertEquals((Object)"b", (Object)bMsg.getStringProperty("requiredRole"));
        Assertions.assertNull((Object)bConsumer.receiveNoWait());
        Message aMsg = aConsumer.receiveNoWait();
        Assertions.assertNotNull((Object)aMsg);
        Assertions.assertEquals((Object)"a", (Object)aMsg.getStringProperty("requiredRole"));
        Assertions.assertNull((Object)aConsumer.receiveNoWait());
        aConnection.close();
        bConnection.close();
    }

    @Test
    public void testMessageAuthorizationTopicNotAuthorized() throws Exception {
        JmsConnectionFactory factory = new JmsConnectionFactory("amqp://127.0.0.1:61616");
        Connection connection = factory.createConnection("first", "secret");
        Session session = connection.createSession(false, 1);
        Topic topic = session.createTopic("TestTopicNotAuth");
        MessageProducer producer = session.createProducer((Destination)topic);
        TextMessage bMessage = session.createTextMessage();
        bMessage.setStringProperty("requiredRole", "b");
        Connection aConnection = factory.createConnection("a", "a");
        Session aSession = aConnection.createSession(false, 1);
        aConnection.start();
        MessageConsumer aConsumer = aSession.createConsumer((Destination)topic);
        producer.send((Message)bMessage);
        connection.close();
        Assertions.assertNull((Object)aConsumer.receiveNoWait());
        aConnection.close();
    }

    static {
        URL resource;
        String path = System.getProperty("java.security.auth.login.config");
        if (path == null && (resource = SecurityTest.class.getClassLoader().getResource("login.config")) != null) {
            path = resource.getFile();
            System.setProperty("java.security.auth.login.config", path);
        }
    }
}

