/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.server.config;

import io.netty.buffer.ByteBuf;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Queue;
import jakarta.jms.Topic;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.naming.Context;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.registry.JndiBindingRegistry;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.jms.server.config.ConnectionFactoryConfiguration;
import org.apache.activemq.artemis.jms.server.config.JMSConfiguration;
import org.apache.activemq.artemis.jms.server.config.impl.ConnectionFactoryConfigurationImpl;
import org.apache.activemq.artemis.jms.server.config.impl.JMSConfigurationImpl;
import org.apache.activemq.artemis.jms.server.config.impl.JMSQueueConfigurationImpl;
import org.apache.activemq.artemis.jms.server.config.impl.TopicConfigurationImpl;
import org.apache.activemq.artemis.jms.server.impl.JMSServerManagerImpl;
import org.apache.activemq.artemis.spi.core.naming.BindingRegistry;
import org.apache.activemq.artemis.tests.unit.util.InVMNamingContext;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.transport.netty.NettyTransport;
import org.apache.activemq.transport.netty.NettyTransportFactory;
import org.apache.activemq.transport.netty.NettyTransportListener;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JMSConfigurationTest
extends ActiveMQTestBase {
    @Test
    public void testSetupJMSConfiguration() throws Exception {
        Object o;
        InVMNamingContext context = new InVMNamingContext();
        ActiveMQServerImpl coreServer = new ActiveMQServerImpl(this.createDefaultInVMConfig());
        JMSConfigurationImpl jmsConfiguration = new JMSConfigurationImpl();
        TransportConfiguration connectorConfig = new TransportConfiguration(InVMConnectorFactory.class.getName());
        ArrayList<TransportConfiguration> transportConfigs = new ArrayList<TransportConfiguration>();
        transportConfigs.add(connectorConfig);
        ConnectionFactoryConfiguration cfConfig = new ConnectionFactoryConfigurationImpl().setName(RandomUtil.randomString()).setConnectorNames(this.registerConnectors((ActiveMQServer)coreServer, transportConfigs)).setBindings(new String[]{"/cf/binding1", "/cf/binding2"});
        jmsConfiguration.getConnectionFactoryConfigurations().add(cfConfig);
        JMSQueueConfigurationImpl queueConfig = new JMSQueueConfigurationImpl().setName(RandomUtil.randomString()).setDurable(false).setBindings(new String[]{"/queue/binding1", "/queue/binding2"});
        jmsConfiguration.getQueueConfigurations().add(queueConfig);
        TopicConfigurationImpl topicConfig = new TopicConfigurationImpl().setName(RandomUtil.randomString()).setBindings(new String[]{"/topic/binding1", "/topic/binding2"});
        jmsConfiguration.getTopicConfigurations().add(topicConfig);
        JMSServerManagerImpl server = new JMSServerManagerImpl((ActiveMQServer)coreServer, (JMSConfiguration)jmsConfiguration);
        server.setRegistry((BindingRegistry)new JndiBindingRegistry((Context)context));
        server.start();
        for (String binding : cfConfig.getBindings()) {
            o = context.lookup(binding);
            Assertions.assertNotNull((Object)o);
            Assertions.assertTrue((boolean)(o instanceof ConnectionFactory));
            ConnectionFactory cf = (ConnectionFactory)o;
            Connection connection = cf.createConnection();
            connection.close();
        }
        for (String binding : queueConfig.getBindings()) {
            o = context.lookup(binding);
            Assertions.assertNotNull((Object)o);
            Assertions.assertTrue((boolean)(o instanceof Queue));
            Queue queue = (Queue)o;
            Assertions.assertEquals((Object)queueConfig.getName(), (Object)queue.getQueueName());
        }
        for (String binding : topicConfig.getBindings()) {
            o = context.lookup(binding);
            Assertions.assertNotNull((Object)o);
            Assertions.assertTrue((boolean)(o instanceof Topic));
            Topic topic = (Topic)o;
            Assertions.assertEquals((Object)topicConfig.getName(), (Object)topic.getTopicName());
        }
        server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHandshakeTimeoutWithValueSet() throws Exception {
        int HANDSHAKE_TIMEOUT = 5;
        ActiveMQServer server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultConfig(false).clearAcceptorConfigurations().addAcceptorConfiguration("netty", "tcp://localhost:61616?handshake-timeout=5")));
        server.start();
        TransportConfiguration tc = (TransportConfiguration)server.getConfiguration().getAcceptorConfigurations().iterator().next();
        String host = (String)tc.getParams().get("host");
        String port = (String)tc.getParams().get("port");
        Object handshakeTimeout = tc.getParams().get("handshake-timeout");
        Assertions.assertNotNull(handshakeTimeout);
        Assertions.assertEquals((int)5, (int)Integer.parseInt(handshakeTimeout.toString()));
        NettyTransport transport = NettyTransportFactory.createTransport(new URI("tcp://" + host + ":" + port));
        transport.setTransportListener(new NettyTransportListener(){

            @Override
            public void onData(ByteBuf incoming) {
            }

            @Override
            public void onTransportClosed() {
            }

            @Override
            public void onTransportError(Throwable cause) {
            }
        });
        try {
            transport.connect();
            Assertions.assertTrue((boolean)Wait.waitFor(() -> !transport.isConnected(), (long)TimeUnit.SECONDS.toMillis(6L)), (String)"Connection should be closed now");
        }
        finally {
            transport.close();
            server.stop();
        }
    }
}

