/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.consumer;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.MessageConsumer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class CreateSubscriptionTest
extends JMSTestBase {
    private final String protocol;

    @Parameters(name="persistenceEnabled = {0}")
    public static Iterable<? extends Object> persistenceEnabled() {
        return Arrays.asList({"AMQP"}, {"CORE"});
    }

    public CreateSubscriptionTest(String protocol) {
        this.protocol = protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testSharedConsumer() throws Exception {
        this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"myTopic")).addRoutingType(RoutingType.MULTICAST));
        ConnectionFactory cf = CFUtil.createConnectionFactory(this.protocol, "tcp://localhost:61616");
        Connection connection = cf.createConnection();
        Session session = connection.createSession();
        Connection connecton2 = cf.createConnection();
        Session session2 = connecton2.createSession();
        try {
            Topic topic = session.createTopic("myTopic");
            MessageConsumer messageConsumer = session.createSharedConsumer(topic, "consumer1");
            MessageConsumer messageConsumer2 = session2.createSharedConsumer(topic, "consumer1");
            connection.close();
        }
        finally {
            connection.close();
            connecton2.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testSharedDurableConsumer() throws Exception {
        this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"myTopic")).addRoutingType(RoutingType.MULTICAST));
        ConnectionFactory cf = CFUtil.createConnectionFactory(this.protocol, "tcp://localhost:61616");
        Connection connection = cf.createConnection();
        Session session = connection.createSession();
        Connection connecton2 = cf.createConnection();
        Session session2 = connecton2.createSession();
        try {
            Topic topic = session.createTopic("myTopic");
            MessageConsumer messageConsumer = session.createSharedDurableConsumer(topic, "consumer1");
            MessageConsumer messageConsumer2 = session2.createSharedDurableConsumer(topic, "consumer1");
            connection.close();
        }
        finally {
            connection.close();
            connecton2.close();
        }
    }

    @TestTemplate
    public void testCreateManyConsumersDurable() throws Exception {
        this.testCreateManyConsumers("createSharedDurableConsumer");
    }

    @TestTemplate
    public void testCreateManyConsumersNonDurable() throws Exception {
        this.testCreateManyConsumers("createSharedConsumer");
    }

    @TestTemplate
    public void testDurableSubscriber() throws Exception {
        this.testCreateManyConsumers("createDurableSubscriber");
    }

    @TestTemplate
    public void testNonDurableSubscriber() throws Exception {
        this.testCreateManyConsumers("createConsumer");
    }

    public void testCreateManyConsumers(String queueType) throws Exception {
        try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
            int i;
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"myTopic")).addRoutingType(RoutingType.MULTICAST));
            ConnectionFactory cf = CFUtil.createConnectionFactory(this.protocol, "tcp://localhost:61616");
            AtomicInteger errors = new AtomicInteger(0);
            Thread[] threads = new Thread[10];
            CyclicBarrier startBarrier = new CyclicBarrier(threads.length);
            CyclicBarrier closeBarrier = new CyclicBarrier(threads.length);
            Runnable runnable = () -> {
                Connection connection = null;
                try {
                    connection = cf.createConnection();
                    if (queueType.equals("createDurableSubscriber")) {
                        connection.setClientID(UUID.randomUUID().toString());
                    }
                    Session session = connection.createSession();
                    Topic topic = session.createTopic("myTopic");
                    startBarrier.await(10L, TimeUnit.SECONDS);
                    if (queueType.equals("createSharedDurableConsumer")) {
                        MessageConsumer messageConsumer = session.createSharedDurableConsumer(topic, "consumer1");
                    } else if (queueType.equals("createSharedConsumer")) {
                        MessageConsumer messageConsumer = session.createSharedConsumer(topic, "consumer1");
                    } else if (queueType.equals("createDurableSubscriber")) {
                        session.createDurableSubscriber(topic, "name", null, false);
                    } else if (queueType.equals("createDurableSubscriber")) {
                        session.createConsumer((Destination)topic);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
                finally {
                    try {
                        closeBarrier.await(10L, TimeUnit.SECONDS);
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            };
            for (i = 0; i < threads.length; ++i) {
                threads[i] = new Thread(null, runnable, "test " + i);
                threads[i].start();
            }
            for (i = 0; i < threads.length; ++i) {
                threads[i].join();
            }
            Assertions.assertEquals((int)0, (int)errors.get());
            Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ229018"}));
        }
    }
}

