/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.group.GroupingHandler;
import org.apache.activemq.artemis.core.server.group.UnproposalListener;
import org.apache.activemq.artemis.core.server.group.impl.GroupBinding;
import org.apache.activemq.artemis.core.server.group.impl.GroupingHandlerConfiguration;
import org.apache.activemq.artemis.core.server.group.impl.Proposal;
import org.apache.activemq.artemis.core.server.group.impl.Response;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusteredGroupingTest
extends ClusterTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    public void testGroupingGroupTimeoutWithUnproposal() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupServer(2, this.isFileStorage(), this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0, 2);
        this.setupClusterConnection("cluster2", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 2, 0, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.LOCAL, 0, 2000, 1000L, 100L);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 1, 2000, 1000L, 100L);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 2, 2000, 1000L, 100L);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.waitForBindings(1, "queues.testaddress", 1, 0, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 1, false);
        this.waitForBindings(1, "queues.testaddress", 2, 1, false);
        this.waitForBindings(2, "queues.testaddress", 2, 0, false);
        CountDownLatch latch = new CountDownLatch(4);
        this.getServer(1).getManagementService().addNotificationListener(notification -> {
            if (!(notification.getType() instanceof CoreNotificationType)) {
                return;
            }
            if (notification.getType() == CoreNotificationType.UNPROPOSAL) {
                latch.countDown();
            }
        });
        this.getServer(2).getManagementService().addNotificationListener(notification -> {
            if (!(notification.getType() instanceof CoreNotificationType)) {
                return;
            }
            if (notification.getType() == CoreNotificationType.UNPROPOSAL) {
                latch.countDown();
            }
        });
        this.sendWithProperty(0, "queues.testaddress", 10, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.verifyReceiveAll(10, 0);
        this.sendWithProperty(0, "queues.testaddress", 10, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id2"));
        this.verifyReceiveAll(10, 0);
        QueueImpl queue0Server2 = (QueueImpl)this.servers[2].locateQueue(SimpleString.of((String)"queue0"));
        Assertions.assertEquals((int)2, (int)queue0Server2.getGroupCount());
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        long timeLimit = System.currentTimeMillis() + 5000L;
        while (timeLimit > System.currentTimeMillis() && queue0Server2.getGroupCount() != 0) {
            Thread.sleep(10L);
        }
        Assertions.assertEquals((int)0, (int)queue0Server2.getGroupCount(), (String)"Unproposal should cleanup the queue group as well");
        this.removeConsumer(0);
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        this.addConsumer(0, 0, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 0, true);
        this.waitForBindings(2, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 2, 0, false);
        this.waitForBindings(1, "queues.testaddress", 2, 1, false);
        this.waitForBindings(2, "queues.testaddress", 2, 1, false);
        this.sendWithProperty(0, "queues.testaddress", 10, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.verifyReceiveAll(10, 0);
        this.sendWithProperty(0, "queues.testaddress", 10, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id2"));
        this.verifyReceiveAll(10, 0);
    }

    @Test
    public void testGroupingGroupTimeoutSendRemote() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupServer(2, this.isFileStorage(), this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0, 2);
        this.setupClusterConnection("cluster2", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 2, 0, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.LOCAL, 0, -1, 2000L, 500L);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 2);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.waitForBindings(1, "queues.testaddress", 1, 0, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 1, false);
        this.waitForBindings(1, "queues.testaddress", 2, 1, false);
        this.waitForBindings(2, "queues.testaddress", 2, 0, false);
        CountDownLatch latch = new CountDownLatch(4);
        this.getServer(1).getManagementService().addNotificationListener(notification -> {
            if (!(notification.getType() instanceof CoreNotificationType)) {
                return;
            }
            if (notification.getType() == CoreNotificationType.UNPROPOSAL) {
                latch.countDown();
            }
        });
        this.getServer(2).getManagementService().addNotificationListener(notification -> {
            if (!(notification.getType() instanceof CoreNotificationType)) {
                return;
            }
            if (notification.getType() == CoreNotificationType.UNPROPOSAL) {
                latch.countDown();
            }
        });
        this.sendWithProperty(2, "queues.testaddress", 10, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.verifyReceiveAll(10, 0);
        this.sendWithProperty(1, "queues.testaddress", 10, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id2"));
        this.verifyReceiveAll(10, 0);
        this.removeConsumer(0);
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        this.addConsumer(0, 1, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 2, 1, false);
        this.waitForBindings(1, "queues.testaddress", 2, 0, false);
        this.waitForBindings(2, "queues.testaddress", 2, 1, false);
        this.sendWithProperty(2, "queues.testaddress", 10, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.verifyReceiveAll(10, 0);
        this.sendWithProperty(1, "queues.testaddress", 10, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id2"));
        this.verifyReceiveAll(10, 0);
    }

    @Test
    public void testGroupingSimple() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupServer(2, this.isFileStorage(), this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0, 2);
        this.setupClusterConnection("cluster2", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 2, 0, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.LOCAL, 0);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 2);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
        this.sendWithProperty(0, "queues.testaddress", 10, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.verifyReceiveAll(10, 0);
    }

    @Test
    public void testGroupingSimpleWithNoAddress() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupServer(2, this.isFileStorage(), this.isNetty());
        this.setupClusterConnection("cluster0", "", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", "", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0, 2);
        this.setupClusterConnection("cluster2", "", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 2, 0, 1);
        this.servers[0].getConfiguration().setGroupingHandlerConfiguration(new GroupingHandlerConfiguration().setName(SimpleString.of((String)"grouparbitrator")).setType(GroupingHandlerConfiguration.TYPE.LOCAL).setTimeout(5000L).setGroupTimeout(-1L).setReaperPeriod(ActiveMQDefaultConfiguration.getDefaultGroupingHandlerReaperPeriod()));
        this.servers[1].getConfiguration().setGroupingHandlerConfiguration(new GroupingHandlerConfiguration().setName(SimpleString.of((String)"grouparbitrator")).setType(GroupingHandlerConfiguration.TYPE.REMOTE).setTimeout(5000L).setGroupTimeout(-1L).setReaperPeriod(ActiveMQDefaultConfiguration.getDefaultGroupingHandlerReaperPeriod()));
        this.servers[2].getConfiguration().setGroupingHandlerConfiguration(new GroupingHandlerConfiguration().setName(SimpleString.of((String)"grouparbitrator")).setType(GroupingHandlerConfiguration.TYPE.REMOTE).setTimeout(5000L).setGroupTimeout(-1L).setReaperPeriod(ActiveMQDefaultConfiguration.getDefaultGroupingHandlerReaperPeriod()));
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
        this.sendWithProperty(0, "queues.testaddress", 10, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.verifyReceiveAll(10, 0);
    }

    @Test
    public void testGroupingSimpleFail2nd() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupServer(2, this.isFileStorage(), this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0, 2);
        this.setupClusterConnection("cluster2", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 2, 0, 1);
        int TIMEOUT_GROUPS = 5000;
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.LOCAL, 0, 5000, -1L, -1L);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 1, 5000, -1L, -1L);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 2, 5000, -1L, -1L);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, true);
        this.createQueue(1, "queues.testaddress", "queue0", null, true);
        this.createQueue(2, "queues.testaddress", "queue0", null, true);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
        this.sendWithProperty(0, "queues.testaddress", 1, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.sendWithProperty(0, "queues.testaddress", 1, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id2"));
        this.sendWithProperty(0, "queues.testaddress", 1, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id3"));
        ClientMessage msg = this.consumers[0].getConsumer().receive(1000L);
        Assertions.assertNotNull((Object)msg);
        msg.acknowledge();
        Assertions.assertNull((Object)this.consumers[0].getConsumer().receiveImmediate());
        msg = this.consumers[1].getConsumer().receive(1000L);
        Assertions.assertNotNull((Object)msg);
        msg.acknowledge();
        SimpleString groupIDOnConsumer1 = msg.getSimpleStringProperty(Message.HDR_GROUP_ID);
        Assertions.assertNull((Object)this.consumers[1].getConsumer().receiveImmediate());
        msg = this.consumers[2].getConsumer().receive(1000L);
        Assertions.assertNotNull((Object)msg);
        msg.acknowledge();
        Assertions.assertNull((Object)this.consumers[2].getConsumer().receiveImmediate());
        this.sendWithProperty(2, "queues.testaddress", 1, false, Message.HDR_GROUP_ID, groupIDOnConsumer1);
        msg = this.consumers[1].getConsumer().receive(1000L);
        Assertions.assertNotNull((Object)msg);
        msg.acknowledge();
        this.closeAllConsumers();
        this.closeAllSessionFactories();
        SimpleString node1ID = this.servers[1].getNodeID();
        Response response = this.servers[0].getGroupingHandler().getProposal(groupIDOnConsumer1.concat(".").concat("queue0"), false);
        Assertions.assertTrue((boolean)response.getClusterName().toString().equals("queue0" + node1ID));
        this.stopServers(0, 1, 2);
        long time = System.currentTimeMillis();
        this.startServers(2, 0);
        Assertions.assertTrue((System.currentTimeMillis() >= time + 5000L ? 1 : 0) != 0, (String)"The group start should have waited the timeout on groups");
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, false);
        this.waitForBindings(2, "queues.testaddress", 1, 1, false);
        this.sendWithProperty(2, "queues.testaddress", 1, false, Message.HDR_GROUP_ID, groupIDOnConsumer1);
        msg = this.consumers[0].getConsumer().receive(500L);
        if (msg == null) {
            msg = this.consumers[2].getConsumer().receive(500L);
        }
        response = this.servers[0].getGroupingHandler().getProposal(groupIDOnConsumer1.concat(".").concat("queue0"), false);
        Assertions.assertFalse((boolean)response.getClusterName().toString().equals("queue0" + node1ID), (String)"group should have been reassigned since server is not up yet");
        Assertions.assertNotNull((Object)msg);
        msg.acknowledge();
    }

    @Test
    public void testGroupTimeout() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupServer(2, this.isFileStorage(), this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0, 2);
        this.setupClusterConnection("cluster2", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 2, 0, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.LOCAL, 0, 1000, 1000L, 100L);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 1, 1000, 100L, 100L);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 2, 1000, 100L, 100L);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, true);
        this.createQueue(1, "queues.testaddress", "queue0", null, true);
        this.createQueue(2, "queues.testaddress", "queue0", null, true);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
        this.sendWithProperty(0, "queues.testaddress", 1, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.sendWithProperty(0, "queues.testaddress", 1, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id2"));
        this.sendWithProperty(0, "queues.testaddress", 1, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id3"));
        Assertions.assertNotNull((Object)this.servers[0].getGroupingHandler().getProposal(SimpleString.of((String)"id1.queue0"), false));
        Thread.sleep(1000L);
        long timeLimit = System.currentTimeMillis() + 5000L;
        while (timeLimit > System.currentTimeMillis() && this.servers[0].getGroupingHandler().getProposal(SimpleString.of((String)"id1.queue0"), false) != null) {
            Thread.sleep(10L);
        }
        Thread.sleep(1000L);
        Assertions.assertNull((Object)this.servers[0].getGroupingHandler().getProposal(SimpleString.of((String)"id1.queue0"), false), (String)"Group should have timed out");
        this.sendWithProperty(0, "queues.testaddress", 1, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.sendWithProperty(1, "queues.testaddress", 1, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        Assertions.assertNotNull((Object)this.servers[0].getGroupingHandler().getProposal(SimpleString.of((String)"id1.queue0"), false));
        Assertions.assertNotNull((Object)this.servers[1].getGroupingHandler().getProposal(SimpleString.of((String)"id1.queue0"), false));
        timeLimit = System.currentTimeMillis() + 1500L;
        while (timeLimit > System.currentTimeMillis() && this.servers[1].getGroupingHandler().getProposal(SimpleString.of((String)"id1.queue0"), true) != null) {
            Assertions.assertNotNull((Object)this.servers[0].getGroupingHandler().getProposal(SimpleString.of((String)"id1.queue0"), false));
            Thread.sleep(10L);
        }
        Thread.sleep(1000L);
        timeLimit = System.currentTimeMillis() + 5000L;
        while (timeLimit > System.currentTimeMillis() && this.servers[0].getGroupingHandler().getProposal(SimpleString.of((String)"id1.queue0"), false) != null) {
            Thread.sleep(10L);
        }
        Assertions.assertNull((Object)this.servers[0].getGroupingHandler().getProposal(SimpleString.of((String)"id1.queue0"), false), (String)"Group should have timed out");
    }

    @Test
    public void testGroupingWith3Nodes() throws Exception {
        String ADDRESS = "queues.testaddress";
        String QUEUE = "queue0";
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupServer(2, this.isFileStorage(), this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0, 2);
        this.setupClusterConnection("cluster2", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 2, 0, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.LOCAL, 0, 10000, 500L, 750L);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 1, 10000, 500L, 750L);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 2, 10000, 500L, 750L);
        this.startServers(0, 1, 2);
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        this.servers[0].getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
        this.servers[1].getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
        this.servers[2].getAddressSettingsRepository().addMatch("#", (Object)addressSettings);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty(), 15);
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, true);
        this.createQueue(1, "queues.testaddress", "queue0", null, true);
        this.createQueue(2, "queues.testaddress", "queue0", null, true);
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.waitForBindings(1, "queues.testaddress", 1, 0, true);
        this.waitForBindings(2, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 2, 0, false);
        this.waitForBindings(1, "queues.testaddress", 2, 0, false);
        this.waitForBindings(2, "queues.testaddress", 2, 0, false);
        ClientSessionFactory sf0 = this.sfs[0];
        ClientSessionFactory sf1 = this.sfs[1];
        ClientSessionFactory sf2 = this.sfs[2];
        ClientSession session = this.addClientSession(sf1.createSession(false, false, false));
        ClientProducer producer = this.addClientProducer(session.createProducer("queues.testaddress"));
        ArrayList<String> groups = new ArrayList<String>();
        AtomicInteger totalMessageProduced = new AtomicInteger(0);
        for (int i = 0; i < 500; ++i) {
            ClientMessage message = session.createMessage(true);
            String group = UUID.randomUUID().toString();
            message.putStringProperty(Message.HDR_GROUP_ID, SimpleString.of((String)group));
            SimpleString dupID = SimpleString.of((String)UUID.randomUUID().toString());
            message.putStringProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID);
            if (i % 100 == 0) {
                groups.add(group);
            }
            producer.send((Message)message);
            logger.trace("Sent message to server 1 with dupID: {}", (Object)dupID);
        }
        session.commit();
        totalMessageProduced.addAndGet(500);
        logger.trace("Sent block of 500 messages to server 1. Total sent: {}", (Object)totalMessageProduced.get());
        session.close();
        ExecutorService executorService = Executors.newFixedThreadPool(groups.size() * 2 + 1, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName()));
        AtomicInteger producerCounter = new AtomicInteger(0);
        CountDownLatch okToConsume = new CountDownLatch(groups.size() + 1);
        AtomicInteger errors = new AtomicInteger(0);
        long timeToRun = System.currentTimeMillis() + 5000L;
        for (String groupx : groups) {
            Runnable r = () -> {
                Object group = groupx;
                String basicID = UUID.randomUUID().toString();
                logger.debug("Starting producer thread...");
                ClientSession session12 = null;
                ClientProducer producer1 = null;
                int targetServer = 0;
                try {
                    ClientSessionFactory factory;
                    int count = producerCounter.incrementAndGet();
                    if (count % 3 == 0) {
                        factory = sf2;
                        targetServer = 2;
                    } else if (count % 2 == 0) {
                        factory = sf1;
                        targetServer = 1;
                    } else {
                        factory = sf0;
                    }
                    logger.debug("Creating producer session factory to node {}", (Object)targetServer);
                    session12 = this.addClientSession(factory.createSession(false, true, true));
                    producer1 = this.addClientProducer(session12.createProducer("queues.testaddress"));
                }
                catch (Exception e) {
                    errors.incrementAndGet();
                    logger.warn("Producer thread couldn't establish connection", (Throwable)e);
                    return;
                }
                int messageCount = 0;
                while (timeToRun > System.currentTimeMillis()) {
                    ClientMessage message = session12.createMessage(true);
                    message.putStringProperty(Message.HDR_GROUP_ID, SimpleString.of((String)group));
                    SimpleString dupID = SimpleString.of((String)(basicID + ":" + messageCount));
                    message.putStringProperty(Message.HDR_DUPLICATE_DETECTION_ID, dupID);
                    try {
                        producer1.send((Message)message);
                        totalMessageProduced.incrementAndGet();
                        ++messageCount;
                    }
                    catch (ActiveMQException e) {
                        logger.warn("Producer thread threw exception while sending messages to {}: {}", (Object)targetServer, (Object)e.getMessage());
                        group = (String)group + "afterFail";
                    }
                    catch (Exception e) {
                        logger.warn("Producer thread threw unexpected exception while sending messages to {}: {}", (Object)targetServer, (Object)e.getMessage());
                        group = (String)group + "afterFail";
                        break;
                    }
                }
                okToConsume.countDown();
            };
            executorService.execute(r);
        }
        Runnable r = () -> {
            try {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.cycleServer(1);
            }
            finally {
                okToConsume.countDown();
            }
        };
        executorService.execute(r);
        AtomicInteger consumerCounter = new AtomicInteger(0);
        AtomicInteger totalMessagesConsumed = new AtomicInteger(0);
        CountDownLatch okToEndTest = new CountDownLatch(groups.size());
        for (String group : groups) {
            r = () -> {
                try {
                    logger.debug("Waiting to start consumer thread...");
                    okToConsume.await(20L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
                logger.debug("Starting consumer thread...");
                ClientSession session1 = null;
                ClientConsumer consumer = null;
                int targetServer = 0;
                try {
                    AtomicInteger atomicInteger = consumerCounter;
                    synchronized (atomicInteger) {
                        ClientSessionFactory factory;
                        if (consumerCounter.get() % 3 == 0) {
                            factory = sf2;
                            targetServer = 2;
                        } else if (consumerCounter.get() % 2 == 0) {
                            factory = sf1;
                            targetServer = 1;
                        } else {
                            factory = sf0;
                        }
                        logger.debug("Creating consumer session factory to node {}", (Object)targetServer);
                        session1 = this.addClientSession(factory.createSession(false, false, true));
                        consumer = this.addClientConsumer(session1.createConsumer("queue0"));
                        session1.start();
                        consumerCounter.incrementAndGet();
                    }
                }
                catch (Exception e) {
                    logger.debug("Consumer thread couldn't establish connection", (Throwable)e);
                    errors.incrementAndGet();
                    return;
                }
                while (true) {
                    try {
                        while (true) {
                            ClientMessage m;
                            if ((m = consumer.receive(1000L)) == null) {
                                okToEndTest.countDown();
                                return;
                            }
                            m.acknowledge();
                            logger.trace("Consumed message {} from server {}. Total consumed: {}", new Object[]{m.getStringProperty(Message.HDR_DUPLICATE_DETECTION_ID), targetServer, totalMessagesConsumed.incrementAndGet()});
                        }
                    }
                    catch (ActiveMQException e) {
                        errors.incrementAndGet();
                        logger.warn("Consumer thread threw exception while receiving messages from server {}.: {}", (Object)targetServer, (Object)e.getMessage());
                        continue;
                    }
                    catch (Exception e) {
                        errors.incrementAndGet();
                        logger.warn("Consumer thread threw unexpected exception while receiving messages from server {}.: {}", (Object)targetServer, (Object)e.getMessage());
                        return;
                    }
                    break;
                }
            };
            executorService.execute(r);
        }
        okToEndTest.await(20L, TimeUnit.SECONDS);
        executorService.shutdownNow();
        executorService.awaitTermination(10L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)0, (int)errors.get());
        Assertions.assertEquals((long)totalMessageProduced.longValue(), (long)totalMessagesConsumed.longValue());
    }

    private void cycleServer(int node) {
        try {
            this.stopServers(node);
            this.startServers(node);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testGroupingBindingNotPresentAtStart() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupServer(2, this.isFileStorage(), this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0, 2);
        this.setupClusterConnection("cluster2", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 2, 0, 1);
        int TIMEOUT = 50000;
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.LOCAL, 0, TIMEOUT);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 2);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, true);
        this.createQueue(1, "queues.testaddress", "queue0", null, true);
        this.createQueue(2, "queues.testaddress", "queue0", null, true);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
        this.sendWithProperty(0, "queues.testaddress", 1, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.sendWithProperty(0, "queues.testaddress", 1, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id2"));
        this.sendWithProperty(0, "queues.testaddress", 1, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id3"));
        this.verifyReceiveAll(1, 0, 1, 2);
        this.closeAllConsumers();
        this.closeSessionFactory(0);
        this.closeSessionFactory(1);
        this.closeSessionFactory(2);
        this.stopServers(0, 1, 2);
        long time = System.currentTimeMillis();
        this.startServers(1, 2, 0);
        Assertions.assertTrue((System.currentTimeMillis() - time < (long)TIMEOUT ? 1 : 0) != 0, (String)"Server restart took a long wait even though it wasn't required as the server already had all the bindings");
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
        this.sendWithProperty(0, "queues.testaddress", 1, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.sendWithProperty(0, "queues.testaddress", 1, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id2"));
        this.sendWithProperty(0, "queues.testaddress", 1, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id3"));
        this.verifyReceiveAll(1, 0, 1, 2);
    }

    @Test
    public void testGroupingBindingsRemoved() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupServer(2, this.isFileStorage(), this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0, 2);
        this.setupClusterConnection("cluster2", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 2, 0, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.LOCAL, 0);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 2);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, true);
        this.createQueue(1, "queues.testaddress", "queue0", null, true);
        this.createQueue(2, "queues.testaddress", "queue0", null, true);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
        this.sendWithProperty(0, "queues.testaddress", 1, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.sendWithProperty(0, "queues.testaddress", 1, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id2"));
        this.sendWithProperty(0, "queues.testaddress", 1, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id3"));
        this.closeAllConsumers();
        this.closeSessionFactory(0);
        this.closeSessionFactory(1);
        this.closeSessionFactory(2);
        this.stopServers(0);
        this.stopServers(1);
        this.startServers(0);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.addConsumer(0, 0, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 1, 0, false);
        this.waitForBindings(2, "queues.testaddress", 1, 1, false);
        this.sendWithProperty(0, "queues.testaddress", 1, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.sendWithProperty(0, "queues.testaddress", 1, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id2"));
        this.sendWithProperty(0, "queues.testaddress", 1, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id3"));
        this.verifyReceiveAll(1, 0);
        this.verifyReceiveAll(1, 0);
        this.addConsumer(1, 2, "queue0", null);
        this.verifyReceiveAll(1, 1);
    }

    @Test
    public void testTimeoutOnSending() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupServer(2, this.isFileStorage(), this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0, 2);
        this.setupClusterConnection("cluster2", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 2, 0, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 1, 0);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 2, 0);
        final CountDownLatch latch = new CountDownLatch(10);
        this.setUpGroupHandler(new GroupingHandler(){

            public void awaitBindings() throws Exception {
            }

            public void addListener(UnproposalListener listener) {
            }

            public void resendPending() throws Exception {
            }

            public void remove(SimpleString groupid, SimpleString clusterName) throws Exception {
            }

            public void forceRemove(SimpleString groupid, SimpleString clusterName) throws Exception {
            }

            public SimpleString getName() {
                return null;
            }

            public void remove(SimpleString id, SimpleString groupId, int distance) {
            }

            public void start() throws Exception {
            }

            public void stop() throws Exception {
            }

            public boolean isStarted() {
                return false;
            }

            public Response propose(Proposal proposal) throws Exception {
                return null;
            }

            public void proposed(Response response) throws Exception {
            }

            public void sendProposalResponse(Response response, int distance) throws Exception {
            }

            public Response receive(Proposal proposal, int distance) throws Exception {
                latch.countDown();
                return null;
            }

            public void onNotification(Notification notification) {
            }

            public void addGroupBinding(GroupBinding groupBinding) {
            }

            public Response getProposal(SimpleString fullID, boolean touchTime) {
                return null;
            }
        }, 0);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
        try {
            this.sendWithProperty(1, "queues.testaddress", 1, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
            Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testGroupingSendTo2queues() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupServer(2, this.isFileStorage(), this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0, 2);
        this.setupClusterConnection("cluster2", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 2, 0, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.LOCAL, 0);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 2);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
        this.sendInRange(0, "queues.testaddress", 0, 10, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.verifyReceiveAllInRange(0, 10, 0);
        this.sendInRange(1, "queues.testaddress", 10, 20, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.verifyReceiveAllInRange(10, 20, 0);
    }

    @Test
    public void testGroupingSendTo3queues() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupServer(2, this.isFileStorage(), this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0, 2);
        this.setupClusterConnection("cluster2", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 2, 0, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.LOCAL, 0);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 2);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
        this.sendInRange(0, "queues.testaddress", 0, 10, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.verifyReceiveAllInRange(0, 10, 0);
        this.sendInRange(1, "queues.testaddress", 10, 20, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.verifyReceiveAllInRange(10, 20, 0);
        this.sendInRange(2, "queues.testaddress", 10, 20, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.verifyReceiveAllInRange(10, 20, 0);
    }

    @Test
    public void testGroupingSendTo3queuesRemoteArbitrator() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupServer(2, this.isFileStorage(), this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0, 2);
        this.setupClusterConnection("cluster2", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 2, 0, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.LOCAL, 0);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 2);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.addConsumer(1, 1, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 2, 1, false);
        this.waitForBindings(1, "queues.testaddress", 2, 0, false);
        this.waitForBindings(2, "queues.testaddress", 2, 1, false);
        this.sendInRange(1, "queues.testaddress", 0, 10, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.verifyReceiveAllInRange(0, 10, 1);
        this.sendInRange(2, "queues.testaddress", 10, 20, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.verifyReceiveAllInRange(10, 20, 1);
        this.sendInRange(0, "queues.testaddress", 20, 30, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.verifyReceiveAllInRange(20, 30, 1);
    }

    @Test
    public void testGroupingSendTo3queuesNoConsumerOnLocalQueue() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupServer(2, this.isFileStorage(), this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0, 2);
        this.setupClusterConnection("cluster2", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 2, 0, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.LOCAL, 0);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 2);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 0, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 1, false);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 1, false);
        this.sendInRange(1, "queues.testaddress", 0, 1, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        int consumer = 0;
        if (this.consumers[0].consumer.receive(5000L) != null) {
            consumer = 0;
        } else if (this.consumers[2].consumer.receive(5000L) != null) {
            consumer = 2;
        } else {
            Assertions.fail((String)"Message was not received.");
        }
        this.sendInRange(1, "queues.testaddress", 0, 10, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.verifyReceiveAllInRange(0, 10, consumer);
        this.sendInRange(2, "queues.testaddress", 10, 20, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.verifyReceiveAllInRange(10, 20, consumer);
        this.sendInRange(0, "queues.testaddress", 20, 30, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.verifyReceiveAllInRange(20, 30, consumer);
    }

    @Test
    public void testGroupingRoundRobin() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupServer(2, this.isFileStorage(), this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0, 2);
        this.setupClusterConnection("cluster2", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 2, 0, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.LOCAL, 0);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 2);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
        this.sendInRange(0, "queues.testaddress", 0, 10, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.sendInRange(0, "queues.testaddress", 10, 20, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id2"));
        this.sendInRange(0, "queues.testaddress", 20, 30, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id3"));
        this.verifyReceiveAllWithGroupIDRoundRobin(0, 10, 0, 1, 2);
    }

    @Test
    public void testGroupingSendTo3queuesQueueRemoved() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupServer(2, this.isFileStorage(), this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0, 2);
        this.setupClusterConnection("cluster2", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 2, 0, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.LOCAL, 0);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 2);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
        this.sendInRange(0, "queues.testaddress", 0, 10, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.verifyReceiveAllInRange(0, 10, 0);
        this.sendInRange(1, "queues.testaddress", 10, 20, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.verifyReceiveAllInRange(10, 20, 0);
        this.sendInRange(2, "queues.testaddress", 20, 30, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.verifyReceiveAllInRange(20, 30, 0);
        this.removeConsumer(0);
        this.removeConsumer(1);
        this.removeConsumer(2);
        this.deleteQueue(0, "queue0");
        this.deleteQueue(1, "queue0");
        this.deleteQueue(2, "queue0");
        this.createQueue(0, "queues.testaddress", "queue1", null, false);
        this.addConsumer(3, 0, "queue1", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, false);
        this.waitForBindings(2, "queues.testaddress", 1, 1, false);
        this.sendInRange(0, "queues.testaddress", 30, 40, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.verifyReceiveAllInRange(30, 40, 3);
        this.sendInRange(1, "queues.testaddress", 40, 50, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.verifyReceiveAllInRange(40, 50, 3);
        this.sendInRange(2, "queues.testaddress", 50, 60, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.verifyReceiveAllInRange(50, 60, 3);
    }

    @Test
    public void testGroupingSendTo3queuesPinnedNodeGoesDown() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupServer(2, this.isFileStorage(), this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, 0, 500L, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, 0, 500L, this.isNetty(), 1, 0, 2);
        this.setupClusterConnection("cluster2", "queues", MessageLoadBalancingType.ON_DEMAND, 1, 0, 500L, this.isNetty(), 2, 0, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.LOCAL, 0);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 2);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, true);
        this.createQueue(1, "queues.testaddress", "queue0", null, true);
        this.createQueue(2, "queues.testaddress", "queue0", null, true);
        this.addConsumer(0, 1, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 2, 1, false);
        this.waitForBindings(1, "queues.testaddress", 2, 0, false);
        this.waitForBindings(2, "queues.testaddress", 2, 1, false);
        this.sendInRange(1, "queues.testaddress", 0, 10, true, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.verifyReceiveAllInRange(true, 0, 10, 0);
        this.closeAllConsumers();
        this.stopServers(1);
        this.startServers(1);
        this.closeSessionFactory(1);
        this.setupSessionFactory(1, this.isNetty());
        this.addConsumer(0, 1, "queue0", null);
        this.waitForBindings(2, "queues.testaddress", 2, 1, false);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 1, false);
        this.sendInRange(2, "queues.testaddress", 10, 20, true, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.verifyReceiveAllInRange(10, 20, 0);
    }

    @Test
    public void testGroupingSendTo3queuesPinnedNodeGoesDownSendBeforeStop() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupServer(2, this.isFileStorage(), this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, 0, 500L, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, 0, 500L, this.isNetty(), 1, 0, 2);
        this.setupClusterConnection("cluster2", "queues", MessageLoadBalancingType.ON_DEMAND, 1, 0, 500L, this.isNetty(), 2, 0, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.LOCAL, 0);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 2);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, true);
        this.createQueue(1, "queues.testaddress", "queue0", null, true);
        this.createQueue(2, "queues.testaddress", "queue0", null, true);
        this.addConsumer(0, 1, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 2, 1, false);
        this.waitForBindings(1, "queues.testaddress", 2, 0, false);
        this.waitForBindings(2, "queues.testaddress", 2, 1, false);
        this.sendInRange(1, "queues.testaddress", 0, 10, true, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.verifyReceiveAllInRange(true, 0, 10, 0);
        this.closeAllConsumers();
        this.sendInRange(2, "queues.testaddress", 10, 20, true, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.stopServers(1);
        this.closeSessionFactory(1);
        this.startServers(1);
        this.setupSessionFactory(1, this.isNetty());
        this.addConsumer(1, 1, "queue0", null);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 1, false);
        this.waitForBindings(2, "queues.testaddress", 2, 1, false);
        this.verifyReceiveAllInRange(10, 20, 1);
    }

    @Test
    public void testGroupingSendTo3queuesPinnedNodeGoesDownSendAfterRestart() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupServer(2, this.isFileStorage(), this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, 0, 500L, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, 0, 500L, this.isNetty(), 1, 0, 2);
        this.setupClusterConnection("cluster2", "queues", MessageLoadBalancingType.ON_DEMAND, 1, 0, 500L, this.isNetty(), 2, 0, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.LOCAL, 0);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 2);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, true);
        this.createQueue(1, "queues.testaddress", "queue0", null, true);
        this.createQueue(2, "queues.testaddress", "queue0", null, true);
        this.addConsumer(0, 1, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 0, true);
        this.waitForBindings(0, "queues.testaddress", 2, 1, false);
        this.waitForBindings(1, "queues.testaddress", 2, 0, false);
        this.waitForBindings(2, "queues.testaddress", 2, 1, false);
        this.sendInRange(1, "queues.testaddress", 0, 10, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.verifyReceiveAllInRange(0, 10, 0);
        this.stopServers(1);
        this.closeSessionFactory(1);
        this.startServers(1);
        this.setupSessionFactory(1, this.isNetty());
        this.addConsumer(1, 1, "queue0", null);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 1, false);
        this.waitForBindings(2, "queues.testaddress", 2, 1, false);
        this.sendInRange(2, "queues.testaddress", 10, 20, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.verifyReceiveAllInRange(10, 20, 1);
        this.sendInRange(0, "queues.testaddress", 20, 30, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.verifyReceiveAllInRange(20, 30, 1);
    }

    @Test
    public void testGroupingMultipleQueuesOnAddress() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupServer(2, this.isFileStorage(), this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0, 2);
        this.setupClusterConnection("cluster2", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 2, 0, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.LOCAL, 0);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 2);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.createQueue(0, "queues.testaddress", "queue1", null, false);
        this.createQueue(1, "queues.testaddress", "queue1", null, false);
        this.createQueue(2, "queues.testaddress", "queue1", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.addConsumer(3, 0, "queue0", null);
        this.addConsumer(4, 1, "queue0", null);
        this.addConsumer(5, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 2, 2, true);
        this.waitForBindings(1, "queues.testaddress", 2, 2, true);
        this.waitForBindings(2, "queues.testaddress", 2, 2, true);
        this.waitForBindings(0, "queues.testaddress", 4, 4, false);
        this.waitForBindings(1, "queues.testaddress", 4, 4, false);
        this.waitForBindings(2, "queues.testaddress", 4, 4, false);
        this.sendWithProperty(0, "queues.testaddress", 10, false, Message.HDR_GROUP_ID, SimpleString.of((String)"id1"));
        this.verifyReceiveAll(10, 0);
    }

    @Test
    public void testGroupingMultipleSending() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
        this.setupServer(2, this.isFileStorage(), this.isNetty());
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0, 2);
        this.setupClusterConnection("cluster2", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 2, 0, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.LOCAL, 0);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 2);
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.setupSessionFactory(2, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.createQueue(1, "queues.testaddress", "queue0", null, false);
        this.createQueue(2, "queues.testaddress", "queue0", null, false);
        this.addConsumer(0, 0, "queue0", null);
        this.addConsumer(1, 1, "queue0", null);
        this.addConsumer(2, 2, "queue0", null);
        this.waitForBindings(0, "queues.testaddress", 1, 1, true);
        this.waitForBindings(1, "queues.testaddress", 1, 1, true);
        this.waitForBindings(2, "queues.testaddress", 1, 1, true);
        this.waitForBindings(0, "queues.testaddress", 2, 2, false);
        this.waitForBindings(1, "queues.testaddress", 2, 2, false);
        this.waitForBindings(2, "queues.testaddress", 2, 2, false);
        CountDownLatch latch = new CountDownLatch(1);
        Thread[] threads = new Thread[9];
        int range = 0;
        int i = 0;
        while (i < 9) {
            threads[i] = new Thread(new ThreadSender(range, range + 10, 1, SimpleString.of((String)("id" + i)), latch, i < 8));
            ++i;
            range += 10;
        }
        for (Thread thread : threads) {
            thread.start();
        }
        this.verifyReceiveAllWithGroupIDRoundRobin(0, 30, 0, 1, 2);
    }

    public boolean isNetty() {
        return true;
    }

    class ThreadSender
    implements Runnable {
        private final int msgStart;
        private final int msgEnd;
        private final SimpleString id;
        private final CountDownLatch latch;
        private final boolean wait;
        private final int node;

        ThreadSender(int msgStart, int msgEnd, int node, SimpleString id, CountDownLatch latch, boolean wait) {
            this.msgStart = msgStart;
            this.msgEnd = msgEnd;
            this.node = node;
            this.id = id;
            this.latch = latch;
            this.wait = wait;
        }

        @Override
        public void run() {
            if (this.wait) {
                try {
                    this.latch.await(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                this.latch.countDown();
            }
            try {
                ClusteredGroupingTest.this.sendInRange(this.node, "queues.testaddress", this.msgStart, this.msgEnd, false, Message.HDR_GROUP_ID, this.id);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

