/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.group.impl.GroupingHandlerConfiguration;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AnycastRoutingWithClusterTest
extends ClusterTestBase {
    @Test
    public void testAnycastAddressOneQueueRoutingMultiNode() throws Exception {
        int i;
        String address = "test.address";
        String queueName = "test.queue";
        String clusterAddress = "test";
        for (int i2 = 0; i2 < 3; ++i2) {
            this.setupServer(i2, this.isFileStorage(), this.isNetty());
        }
        this.setupClusterConnection("cluster0", clusterAddress, MessageLoadBalancingType.STRICT, 1, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", clusterAddress, MessageLoadBalancingType.STRICT, 1, this.isNetty(), 1, 0, 2);
        this.setupClusterConnection("cluster2", clusterAddress, MessageLoadBalancingType.STRICT, 1, this.isNetty(), 2, 0, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.LOCAL, 0);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 2);
        this.startServers(0, 1, 2);
        for (i = 0; i < 3; ++i) {
            this.createAddressInfo(i, address, RoutingType.ANYCAST, -1, false);
            this.setupSessionFactory(i, this.isNetty());
            this.createQueue(i, address, queueName, null, false, RoutingType.ANYCAST);
            this.addConsumer(i, i, queueName, null);
        }
        for (i = 0; i < 3; ++i) {
            this.waitForBindings(i, address, 1, 1, true);
            this.waitForBindings(i, address, 2, 2, false);
        }
        int noMessages = 30;
        this.send(0, address, 30, true, null, null);
        for (int s = 0; s < 3; ++s) {
            Queue queue = this.servers[s].locateQueue(SimpleString.of((String)queueName));
            Wait.waitFor(() -> queue.getMessageCount() == 10L);
        }
        for (int i3 = 0; i3 < 10; ++i3) {
            for (int c = 0; c < 3; ++c) {
                Assertions.assertNotNull((Object)this.consumers[c].consumer.receive(1000L));
            }
        }
    }

    @Test
    public void testAnycastAddressMultiQueuesRoutingMultiNode() throws Exception {
        int i;
        String address = "test.address";
        String queueNamePrefix = "test.queue";
        String clusterAddress = "test";
        for (int i2 = 0; i2 < 3; ++i2) {
            this.setupServer(i2, this.isFileStorage(), this.isNetty());
        }
        this.setupClusterConnection("cluster0", clusterAddress, MessageLoadBalancingType.STRICT, 1, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", clusterAddress, MessageLoadBalancingType.STRICT, 1, this.isNetty(), 1, 0, 2);
        this.setupClusterConnection("cluster2", clusterAddress, MessageLoadBalancingType.STRICT, 1, this.isNetty(), 2, 0, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.LOCAL, 0);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 2);
        this.startServers(0, 1, 2);
        for (i = 0; i < 3; ++i) {
            this.createAddressInfo(i, address, RoutingType.ANYCAST, -1, false);
            this.setupSessionFactory(i, this.isNetty());
            this.createQueue(i, address, queueNamePrefix + i, null, false, RoutingType.ANYCAST);
            this.addConsumer(i, i, queueNamePrefix + i, null);
        }
        for (i = 0; i < 3; ++i) {
            this.waitForBindings(i, address, 1, 1, true);
            this.waitForBindings(i, address, 2, 2, false);
        }
        int noMessages = 30;
        this.send(0, address, 30, true, null, null);
        for (int s = 0; s < 3; ++s) {
            Queue queue = this.servers[s].locateQueue(SimpleString.of((String)(queueNamePrefix + s)));
            Wait.waitFor(() -> queue.getMessageCount() == 10L);
        }
        for (int i3 = 0; i3 < 10; ++i3) {
            for (int c = 0; c < 3; ++c) {
                Assertions.assertNotNull((Object)this.consumers[c].consumer.receive(1000L));
            }
        }
    }

    @Test
    public void testAnycastAddressMultiQueuesWithFilterRoutingMultiNode() throws Exception {
        int i;
        String address = "test.address";
        String queueNamePrefix = "test.queue";
        String clusterAddress = "test";
        for (int i2 = 0; i2 < 3; ++i2) {
            this.setupServer(i2, this.isFileStorage(), this.isNetty());
        }
        this.setupClusterConnection("cluster0", clusterAddress, MessageLoadBalancingType.STRICT, 1, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", clusterAddress, MessageLoadBalancingType.STRICT, 1, this.isNetty(), 1, 0, 2);
        this.setupClusterConnection("cluster2", clusterAddress, MessageLoadBalancingType.STRICT, 1, this.isNetty(), 2, 0, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.LOCAL, 0);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 2);
        this.startServers(0, 1, 2);
        for (int i3 = 0; i3 < 3; ++i3) {
            this.createAddressInfo(i3, address, RoutingType.ANYCAST, -1, false);
            this.setupSessionFactory(i3, this.isNetty());
        }
        String filter1 = "giraffe";
        String filter2 = "platypus";
        this.createQueue(0, address, queueNamePrefix + "0", filter1, false, RoutingType.ANYCAST);
        this.createQueue(1, address, queueNamePrefix + "1", filter1, false, RoutingType.ANYCAST);
        this.createQueue(2, address, queueNamePrefix + "2", filter2, false, RoutingType.ANYCAST);
        for (i = 0; i < 3; ++i) {
            this.addConsumer(i, i, queueNamePrefix + i, null);
        }
        for (i = 0; i < 3; ++i) {
            this.waitForBindings(i, address, 1, 1, true);
            this.waitForBindings(i, address, 2, 2, false);
        }
        int noMessages = 30;
        this.send(0, address, 30, true, filter1, null);
        for (int i4 = 0; i4 < 15; ++i4) {
            for (int c = 0; c < 2; ++c) {
                Assertions.assertNotNull((Object)this.consumers[c].consumer.receive(1000L));
            }
        }
        Assertions.assertNull((Object)this.consumers[2].consumer.receive(1000L));
    }

    @Test
    public void testMulitcastAddressMultiQueuesRoutingMultiNode() throws Exception {
        int i;
        String address = "test.address";
        String queueNamePrefix = "test.queue";
        String clusterAddress = "test";
        for (int i2 = 0; i2 < 3; ++i2) {
            this.setupServer(i2, this.isFileStorage(), this.isNetty());
        }
        this.setupClusterConnection("cluster0", clusterAddress, MessageLoadBalancingType.STRICT, 1, this.isNetty(), 0, 1, 2);
        this.setupClusterConnection("cluster1", clusterAddress, MessageLoadBalancingType.STRICT, 1, this.isNetty(), 1, 0, 2);
        this.setupClusterConnection("cluster2", clusterAddress, MessageLoadBalancingType.STRICT, 1, this.isNetty(), 2, 0, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.LOCAL, 0);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 1);
        this.setUpGroupHandler(GroupingHandlerConfiguration.TYPE.REMOTE, 2);
        this.startServers(0, 1, 2);
        for (i = 0; i < 3; ++i) {
            this.createAddressInfo(i, address, RoutingType.MULTICAST, -1, false);
            this.setupSessionFactory(i, this.isNetty());
            this.createQueue(i, address, queueNamePrefix + i, null, false);
            this.addConsumer(i, i, queueNamePrefix + i, null);
        }
        for (i = 0; i < 3; ++i) {
            this.waitForBindings(i, address, 1, 1, true);
            this.waitForBindings(i, address, 2, 2, false);
        }
        int noMessages = 30;
        this.send(0, address, 30, true, null, null);
        for (int s = 0; s < 3; ++s) {
            Queue queue = this.servers[s].locateQueue(SimpleString.of((String)(queueNamePrefix + s)));
            Wait.waitFor(() -> queue.getMessageCount() == 30L);
        }
        for (int i3 = 0; i3 < 30; ++i3) {
            for (int c = 0; c < 3; ++c) {
                Assertions.assertNotNull((Object)this.consumers[c].consumer.receive(1000L));
            }
        }
    }

    private boolean isNetty() {
        return true;
    }
}

