/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DurableQueueTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ClientSession session;
    private ClientSessionFactory sf;
    private ServerLocator locator;

    @Test
    public void testConsumeFromDurableQueue() throws Exception {
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)this.session.createMessage(false));
        this.session.start();
        ClientConsumer consumer = this.session.createConsumer(queue);
        ClientMessage message = consumer.receive(500L);
        Assertions.assertNotNull((Object)message);
        message.acknowledge();
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @Test
    public void testConsumeFromDurableQueueAfterServerRestart() throws Exception {
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address));
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)this.session.createMessage(true));
        this.session.close();
        this.server.stop();
        this.server.start();
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.sf.createSession(false, true, true);
        this.session.start();
        ClientConsumer consumer = this.session.createConsumer(queue);
        ClientMessage message = consumer.receive(500L);
        Assertions.assertNotNull((Object)message);
        message.acknowledge();
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @Test
    public void testUserEncoding() throws Exception {
        String userName = "myUser";
        this.session.close();
        this.session = this.sf.createSession("myUser", "myPass", false, true, true, false, 0);
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address));
        this.session.close();
        this.server.stop();
        this.server.start();
        Assertions.assertEquals((int)1, (int)((ActiveMQServerImpl)this.server).getQueueCountForUser("myUser"));
    }

    @Test
    public void testProduceAndConsumeFromDurableQueueAfterServerRestart() throws Exception {
        SimpleString queue = RandomUtil.randomSimpleString();
        SimpleString address = RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address));
        this.session.close();
        this.server.stop();
        this.server.start();
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.sf.createSession(false, true, true);
        ClientProducer producer = this.session.createProducer(address);
        producer.send((Message)this.session.createMessage(true));
        this.session.start();
        ClientConsumer consumer = this.session.createConsumer(queue);
        ClientMessage message = consumer.receive(500L);
        Assertions.assertNotNull((Object)message);
        message.acknowledge();
        consumer.close();
        this.session.deleteQueue(queue);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(true);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.addClientSession(this.sf.createSession(false, true, true));
    }
}

