/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.apache.activemq.artemis.api.core.ActiveMQTransactionOutcomeUnknownException;
import org.apache.activemq.artemis.api.core.ActiveMQUnBlockedException;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfirmationWindowTest
extends ActiveMQTestBase {
    protected ActiveMQServer server;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false, this.createDefaultNettyConfig());
        this.server.start();
    }

    @Test
    public void testMissingResponse() throws Exception {
        int confirmationWindowSize = 0x100000;
        int callTimeout = 2000;
        int totalMessagesToSend = 1000;
        int maxChunkSize = 99;
        String queueName = RandomUtil.randomString();
        this.server.createQueue(QueueConfiguration.of((String)queueName).setAddress(queueName).setRoutingType(RoutingType.ANYCAST));
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)new Interceptor(){
            private int commitCount = 0;

            public boolean intercept(Packet packet, RemotingConnection connection) {
                if (packet.getType() == 43 && ++this.commitCount > 10) {
                    log.info("Blocking commit");
                    return false;
                }
                return true;
            }
        });
        this.server.getRemotingService().addOutgoingInterceptor((BaseInterceptor)new Interceptor(){
            private int responseCount = 0;

            public boolean intercept(Packet packet, RemotingConnection connection) {
                if (++this.responseCount > 1000 && packet.getType() == 21 && packet.getCorrelationID() > 0L) {
                    try {
                        log.info("Slowing responses");
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                return true;
            }
        });
        ServerLocator locator = this.createNonHALocator(true);
        locator.setConfirmationWindowSize(0x100000);
        locator.setCallTimeout(2000L);
        try (ClientSessionFactory sessionFactory = locator.createSessionFactory();
             ClientSession session = sessionFactory.createSession(false, false, false);){
            ClientProducer producer = session.createProducer(queueName);
            int chunkSize = 0;
            for (int i = 1; i <= 1000; ++i) {
                producer.send((Message)session.createMessage(true));
                ++chunkSize;
                if (i % 99 != 0) continue;
                log.info("Committing {} messages...", (Object)chunkSize);
                session.commit();
                log.info("Commit succeeded.");
                chunkSize = 0;
            }
            if (chunkSize > 0) {
                log.info("Committing {} messages.", (Object)chunkSize);
                session.commit();
                Assertions.fail((String)"Commit should have timed out & failed.");
            }
        }
        catch (ActiveMQNotConnectedException | ActiveMQTransactionOutcomeUnknownException | ActiveMQUnBlockedException throwable) {
            // empty catch block
        }
    }
}

