/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.connect;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.qpid.protonj2.test.driver.ProtonTestServer;
import org.apache.qpid.protonj2.test.driver.ProtonTestServerOptions;
import org.apache.qpid.protonj2.test.driver.codec.security.SaslCode;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPConnectSaslTest
extends AmqpClientTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int BROKER_PORT_NUM = 5673;
    private static final String SERVER_KEYSTORE_NAME = "server-keystore.jks";
    private static final String UNKNOWN_SERVER_KEYSTORE_NAME = "unknown-server-keystore.jks";
    private static final String SERVER_KEYSTORE_PASSWORD = "securepass";
    private static final String CLIENT_KEYSTORE_NAME = "client-keystore.jks";
    private static final String CLIENT_KEYSTORE_PASSWORD = "securepass";
    private static final String SERVER_TRUSTSTORE_NAME = "server-ca-truststore.jks";
    private static final String SERVER_TRUSTSTORE_PASSWORD = "securepass";
    private static final String CLIENT_TRUSTSTORE_NAME = "client-ca-truststore.jks";
    private static final String CLIENT_TRUSTSTORE_PASSWORD = "securepass";
    private static final String USER = "MY_USER";
    private static final String PASSWD = "PASSWD_VALUE";
    private static final String PLAIN = "PLAIN";
    private static final String ANONYMOUS = "ANONYMOUS";
    private static final String EXTERNAL = "EXTERNAL";
    private static final String SCRAM_SHA_512 = "SCRAM-SHA-512";

    @Override
    protected ActiveMQServer createServer() throws Exception {
        return this.createServer(5673, false);
    }

    @Test
    @Timeout(value=20L)
    public void testConnectsWithAnonymous() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect(new String[]{PLAIN, ANONYMOUS});
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.debug("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://localhost:" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
        }
    }

    @Test
    @Timeout(value=20L)
    public void testConnectsWithPlain() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLPlainConnect(USER, PASSWD, new String[]{PLAIN, ANONYMOUS});
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.debug("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://localhost:" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.setUser(USER);
            amqpConnection.setPassword(PASSWD);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
        }
    }

    @Test
    @Timeout(value=20L)
    public void testAnonymousSelectedWhenNoCredentialsSupplied() throws Exception {
        this.doMechanismSelectedTestImpl(null, null, ANONYMOUS, new String[]{SCRAM_SHA_512, PLAIN, ANONYMOUS});
    }

    @Test
    @Timeout(value=20L)
    public void testSelectsSCRAMWhenCredentialsPresent() throws Exception {
        this.doMechanismSelectedTestImpl(USER, PASSWD, SCRAM_SHA_512, new String[]{SCRAM_SHA_512, PLAIN, ANONYMOUS});
    }

    private void doMechanismSelectedTestImpl(String user, String passwd, String selectedMechanism, String[] offeredMechanisms) throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSaslConnectThatAlwaysFailsAuthentication(offeredMechanisms, selectedMechanism);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.debug("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://localhost:" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            if (user != null) {
                amqpConnection.setUser(user);
            }
            if (passwd != null) {
                amqpConnection.setPassword(passwd);
            }
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
        }
    }

    @Test
    @Timeout(value=20L)
    public void testConnectsWithExternal() throws Exception {
        this.doConnectWithExternalTestImpl(true);
    }

    @Test
    @Timeout(value=20L)
    public void testExternalIgnoredWhenNoClientCertSupplied() throws Exception {
        this.doConnectWithExternalTestImpl(false);
    }

    private void doConnectWithExternalTestImpl(boolean requireClientCert) throws Exception {
        String keyStorePath = ((Object)((Object)this)).getClass().getClassLoader().getResource(SERVER_KEYSTORE_NAME).getFile();
        String trustStorePath = ((Object)((Object)this)).getClass().getClassLoader().getResource(CLIENT_TRUSTSTORE_NAME).getFile();
        ProtonTestServerOptions serverOptions = new ProtonTestServerOptions();
        serverOptions.setSecure(true);
        serverOptions.setKeyStoreLocation(keyStorePath);
        serverOptions.setKeyStorePassword("securepass");
        serverOptions.setVerifyHost(false);
        if (requireClientCert) {
            serverOptions.setNeedClientAuth(true);
            serverOptions.setTrustStoreLocation(trustStorePath);
            serverOptions.setTrustStorePassword("securepass");
        }
        try (ProtonTestServer peer = new ProtonTestServer(serverOptions);){
            peer.expectSASLHeader().respondWithSASLHeader();
            peer.remoteSaslMechanisms().withMechanisms(new String[]{EXTERNAL, PLAIN}).queue();
            if (requireClientCert) {
                peer.expectSaslInit().withMechanism(EXTERNAL).withInitialResponse(new byte[0]);
            } else {
                peer.expectSaslInit().withMechanism(PLAIN).withInitialResponse(peer.saslPlainInitialResponse(USER, PASSWD));
            }
            peer.remoteSaslOutcome().withCode(SaslCode.OK).queue();
            peer.expectAMQPHeader().respondWithAMQPHeader();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.debug("Connect test started, peer listening on: {}", (Object)remoteURI);
            String amqpServerConnectionURI = "tcp://localhost:" + remoteURI.getPort() + "?sslEnabled=true;trustStorePath=server-ca-truststore.jks;trustStorePassword=securepass";
            if (requireClientCert) {
                amqpServerConnectionURI = amqpServerConnectionURI + ";keyStorePath=client-keystore.jks;keyStorePassword=securepass";
            }
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), amqpServerConnectionURI);
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.setUser(USER);
            amqpConnection.setPassword(PASSWD);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
        }
    }

    @Test
    @Timeout(value=20L)
    public void testReconnectConnectsWithVerifyHostOffOnSecondURI() throws Exception {
        String keyStorePath = ((Object)((Object)this)).getClass().getClassLoader().getResource(UNKNOWN_SERVER_KEYSTORE_NAME).getFile();
        ProtonTestServerOptions server1Options = new ProtonTestServerOptions();
        server1Options.setSecure(true);
        server1Options.setKeyStoreLocation(keyStorePath);
        server1Options.setKeyStorePassword("securepass");
        server1Options.setVerifyHost(false);
        ProtonTestServerOptions server2Options = new ProtonTestServerOptions();
        server2Options.setSecure(true);
        server2Options.setKeyStoreLocation(keyStorePath);
        server2Options.setKeyStorePassword("securepass");
        server2Options.setVerifyHost(false);
        try (ProtonTestServer firstPeer = new ProtonTestServer(server1Options);
             ProtonTestServer secondPeer = new ProtonTestServer(server2Options);){
            firstPeer.expectConnectionToDrop();
            firstPeer.start();
            secondPeer.expectSASLHeader().respondWithSASLHeader();
            secondPeer.remoteSaslMechanisms().withMechanisms(new String[]{EXTERNAL, PLAIN}).queue();
            secondPeer.expectSaslInit().withMechanism(PLAIN).withInitialResponse(secondPeer.saslPlainInitialResponse(USER, PASSWD));
            secondPeer.remoteSaslOutcome().withCode(SaslCode.OK).queue();
            secondPeer.expectAMQPHeader().respondWithAMQPHeader();
            secondPeer.expectOpen().respond();
            secondPeer.expectBegin().respond();
            secondPeer.start();
            URI firstPeerURI = firstPeer.getServerURI();
            logger.debug("Connect test started, first peer listening on: {}", (Object)firstPeerURI);
            URI secondPeerURI = secondPeer.getServerURI();
            logger.debug("Connect test started, second peer listening on: {}", (Object)secondPeerURI);
            String amqpServerConnectionURI = "tcp://localhost:" + firstPeerURI.getPort() + "?verifyHost=true;sslEnabled=true;trustStorePath=server-ca-truststore.jks;trustStorePassword=securepass#tcp://localhost:" + secondPeerURI.getPort() + "?verifyHost=false";
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), amqpServerConnectionURI);
            amqpConnection.setReconnectAttempts(20);
            amqpConnection.setRetryInterval(100);
            amqpConnection.setUser(USER);
            amqpConnection.setPassword(PASSWD);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            firstPeer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            secondPeer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
        }
    }

    @Test
    @Timeout(value=20L)
    public void testReconnectionUsesConfigurationToReconnectToSecondHostAfterFirstFails() throws Exception {
        String keyStore1Path = ((Object)((Object)this)).getClass().getClassLoader().getResource(UNKNOWN_SERVER_KEYSTORE_NAME).getFile();
        String keyStore2Path = ((Object)((Object)this)).getClass().getClassLoader().getResource(SERVER_KEYSTORE_NAME).getFile();
        ProtonTestServerOptions server1Options = new ProtonTestServerOptions();
        server1Options.setSecure(true);
        server1Options.setKeyStoreLocation(keyStore1Path);
        server1Options.setKeyStorePassword("securepass");
        server1Options.setVerifyHost(false);
        ProtonTestServerOptions server2Options = new ProtonTestServerOptions();
        server2Options.setSecure(true);
        server2Options.setKeyStoreLocation(keyStore2Path);
        server2Options.setKeyStorePassword("securepass");
        server2Options.setVerifyHost(false);
        try (ProtonTestServer firstPeer = new ProtonTestServer(server1Options);
             ProtonTestServer secondPeer = new ProtonTestServer(server2Options);){
            firstPeer.expectConnectionToDrop();
            firstPeer.start();
            secondPeer.expectSASLHeader().respondWithSASLHeader();
            secondPeer.remoteSaslMechanisms().withMechanisms(new String[]{EXTERNAL, PLAIN}).queue();
            secondPeer.expectSaslInit().withMechanism(PLAIN).withInitialResponse(secondPeer.saslPlainInitialResponse(USER, PASSWD));
            secondPeer.remoteSaslOutcome().withCode(SaslCode.OK).queue();
            secondPeer.expectAMQPHeader().respondWithAMQPHeader();
            secondPeer.expectOpen().respond();
            secondPeer.expectBegin().respond();
            secondPeer.start();
            URI firstPeerURI = firstPeer.getServerURI();
            logger.debug("Connect test started, first peer listening on: {}", (Object)firstPeerURI);
            URI secondPeerURI = secondPeer.getServerURI();
            logger.debug("Connect test started, second peer listening on: {}", (Object)secondPeerURI);
            String amqpServerConnectionURI = "tcp://127.0.0.1:" + firstPeerURI.getPort() + "?sslEnabled=true;trustStorePath=server-ca-truststore.jks;trustStorePassword=securepass#tcp://localhost:" + secondPeerURI.getPort();
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), amqpServerConnectionURI);
            amqpConnection.setReconnectAttempts(20);
            amqpConnection.setRetryInterval(100);
            amqpConnection.setUser(USER);
            amqpConnection.setPassword(PASSWD);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            firstPeer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            secondPeer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
        }
    }

    @Test
    @Timeout(value=20L)
    public void testReconnectionUsesHostSpecificConfigurationToReconnectToSecondHostAfterFirstFails() throws Exception {
        String keyStore1Path = ((Object)((Object)this)).getClass().getClassLoader().getResource(UNKNOWN_SERVER_KEYSTORE_NAME).getFile();
        String keyStore2Path = ((Object)((Object)this)).getClass().getClassLoader().getResource(SERVER_KEYSTORE_NAME).getFile();
        ProtonTestServerOptions server1Options = new ProtonTestServerOptions();
        server1Options.setSecure(true);
        server1Options.setKeyStoreLocation(keyStore1Path);
        server1Options.setKeyStorePassword("securepass");
        server1Options.setVerifyHost(false);
        ProtonTestServerOptions server2Options = new ProtonTestServerOptions();
        server2Options.setSecure(true);
        server2Options.setKeyStoreLocation(keyStore2Path);
        server2Options.setKeyStorePassword("securepass");
        server2Options.setVerifyHost(false);
        try (ProtonTestServer firstPeer = new ProtonTestServer(server1Options);
             ProtonTestServer secondPeer = new ProtonTestServer(server2Options);){
            firstPeer.expectConnectionToDrop();
            firstPeer.start();
            secondPeer.expectSASLHeader().respondWithSASLHeader();
            secondPeer.remoteSaslMechanisms().withMechanisms(new String[]{EXTERNAL, PLAIN}).queue();
            secondPeer.expectSaslInit().withMechanism(PLAIN).withInitialResponse(secondPeer.saslPlainInitialResponse(USER, PASSWD));
            secondPeer.remoteSaslOutcome().withCode(SaslCode.OK).queue();
            secondPeer.expectAMQPHeader().respondWithAMQPHeader();
            secondPeer.expectOpen().respond();
            secondPeer.expectBegin().respond();
            secondPeer.start();
            URI firstPeerURI = firstPeer.getServerURI();
            logger.debug("Connect test started, first peer listening on: {}", (Object)firstPeerURI);
            URI secondPeerURI = secondPeer.getServerURI();
            logger.debug("Connect test started, second peer listening on: {}", (Object)secondPeerURI);
            String amqpServerConnectionURI = "tcp://localhost:" + firstPeerURI.getPort() + "?sslEnabled=true;trustStorePath=client-ca-truststore.jks;trustStorePassword=securepass#tcp://localhost:" + secondPeerURI.getPort() + "?sslEnabled=true;trustStorePath=server-ca-truststore.jks;trustStorePassword=securepass";
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), amqpServerConnectionURI);
            amqpConnection.setReconnectAttempts(20);
            amqpConnection.setRetryInterval(100);
            amqpConnection.setUser(USER);
            amqpConnection.setPassword(PASSWD);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            firstPeer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            secondPeer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
        }
    }
}

