/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.jms.provider.amqp.message.AmqpDestinationHelper;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class BrokerDefinedAnycastConsumerTest
extends AmqpClientTestSupport {
    SimpleString address = SimpleString.of((String)"testAddress");
    SimpleString queue1 = SimpleString.of((String)"queue1");
    SimpleString queue2 = SimpleString.of((String)"queue2");

    @Override
    protected boolean isAutoCreateQueues() {
        return false;
    }

    @Test
    @Timeout(value=60L)
    public void testConsumeFromSingleQueueOnAddressSameName() throws Exception {
        this.server.addAddressInfo(new AddressInfo(this.address, RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.address).setRoutingType(RoutingType.ANYCAST));
        this.sendMessages(this.address.toString(), 1);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.address.toString());
        receiver.flow(1);
        AmqpMessage amqpMessage = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)amqpMessage);
        Assertions.assertEquals((int)1, (int)((QueueImpl)this.server.getPostOffice().getBinding(this.address).getBindable()).getConsumerCount());
        receiver.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testConsumeFromSingleQueueOnAddressSameNameMultipleQueues() throws Exception {
        this.server.addAddressInfo(new AddressInfo(this.address, RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.queue1).setAddress(this.address).setRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.address).setRoutingType(RoutingType.ANYCAST));
        this.sendMessages(this.address.toString(), 2);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.address.toString());
        receiver.flow(1);
        AmqpMessage amqpMessage = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)amqpMessage);
        Assertions.assertEquals((int)1, (int)((QueueImpl)this.server.getPostOffice().getBinding(this.address).getBindable()).getConsumerCount());
        Assertions.assertEquals((int)0, (int)((QueueImpl)this.server.getPostOffice().getBinding(this.queue1).getBindable()).getConsumerCount());
        receiver.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testConsumeFromSingleQueueOnAddressDifferentName() throws Exception {
        this.server.addAddressInfo(new AddressInfo(this.address, RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.queue1).setAddress(this.address).setRoutingType(RoutingType.ANYCAST));
        this.sendMessages(this.address.toString(), 1);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.address.toString());
        receiver.flow(1);
        AmqpMessage amqpMessage = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)amqpMessage);
        Assertions.assertEquals((int)1, (int)((QueueImpl)this.server.getPostOffice().getBinding(this.queue1).getBindable()).getConsumerCount());
        receiver.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testConsumeFromSingleQueueOnAddressDifferentNameMultipleQueues() throws Exception {
        this.server.addAddressInfo(new AddressInfo(this.address, RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.queue1).setAddress(this.address).setRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.queue2).setAddress(this.address).setRoutingType(RoutingType.ANYCAST));
        this.sendMessages(this.address.toString(), 1);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.address.toString());
        receiver.flow(1);
        AmqpMessage amqpMessage = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)amqpMessage);
        Assertions.assertEquals((int)1, (int)((QueueImpl)this.server.getPostOffice().getBinding(this.queue1).getBindable()).getConsumerCount());
        Assertions.assertEquals((int)0, (int)((QueueImpl)this.server.getPostOffice().getBinding(this.queue2).getBindable()).getConsumerCount());
        receiver.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testConsumeFromSingleQualifiedQueueOnAddressSameName() throws Exception {
        this.server.addAddressInfo(new AddressInfo(this.address, RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.queue1).setAddress(this.address).setRoutingType(RoutingType.ANYCAST));
        this.sendMessages(this.address.toString(), 1);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.address.toString() + "::" + this.queue1.toString());
        receiver.flow(1);
        AmqpMessage amqpMessage = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)amqpMessage);
        Assertions.assertEquals((int)1, (int)((QueueImpl)this.server.getPostOffice().getBinding(this.queue1).getBindable()).getConsumerCount());
        receiver.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testConsumeWhenOnlyMulticast() throws Exception {
        this.server.addAddressInfo(new AddressInfo(this.address, RoutingType.MULTICAST));
        this.sendMessages(this.address.toString(), 1);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        Source jmsSource = this.createJmsSource(false);
        jmsSource.setAddress(this.address.toString());
        try {
            session.createReceiver(jmsSource);
            Assertions.fail((String)"should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testConsumeWhenNoAddressCreatedNoAutoCreate() throws Exception {
        AddressSettings settings = new AddressSettings();
        settings.setAutoCreateAddresses(Boolean.valueOf(false));
        this.server.getAddressSettingsRepository().addMatch(this.address.toString(), (Object)settings);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        try {
            session.createReceiver(this.address.toString());
            Assertions.fail((String)"should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testConsumeWhenNoAddressCreatedAutoCreate() throws Exception {
        this.server.getAddressSettingsRepository().clear();
        AddressSettings settings = new AddressSettings();
        settings.setAutoCreateAddresses(Boolean.valueOf(true));
        settings.setDefaultAddressRoutingType(RoutingType.ANYCAST);
        this.server.getAddressSettingsRepository().addMatch(this.address.toString(), (Object)settings);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.address.toString());
        this.sendMessages(this.address.toString(), 1);
        receiver.flow(1);
        AmqpMessage amqpMessage = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)amqpMessage);
        Assertions.assertEquals((int)1, (int)((QueueImpl)this.server.getPostOffice().getBinding(this.address).getBindable()).getConsumerCount());
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testConsumeWhenNoAddressHasBothRoutingTypesButDefaultQueueIsMultiCast() throws Exception {
        AddressInfo addressInfo = new AddressInfo(this.address);
        addressInfo.getRoutingTypes().add(RoutingType.ANYCAST);
        addressInfo.getRoutingTypes().add(RoutingType.MULTICAST);
        this.server.addAddressInfo(addressInfo);
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.address));
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        try {
            session.createReceiver(this.address.toString());
            Assertions.fail((String)"expected exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        connection.close();
    }

    protected Source createJmsSource(boolean topic) {
        Source source = new Source();
        if (!topic) {
            source.setCapabilities(new Symbol[]{AmqpDestinationHelper.QUEUE_CAPABILITY});
        } else {
            source.setCapabilities(new Symbol[]{AmqpDestinationHelper.TOPIC_CAPABILITY});
        }
        return source;
    }
}

