/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton.deployment;

import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.singleton.service.ServiceTargetFactory;
import org.wildfly.extension.clustering.singleton.deployment.SingletonDeploymentConfiguration;
import org.wildfly.extension.clustering.singleton.deployment.SingletonDeploymentProcessor;
import org.wildfly.service.ServiceDependency;

public class SingletonDeploymentDependencyProcessor
implements DeploymentUnitProcessor {
    public static final AttachmentKey<SingletonDeploymentConfiguration> CONFIGURATION_KEY = AttachmentKey.create(SingletonDeploymentConfiguration.class);

    public void deploy(DeploymentPhaseContext context) throws DeploymentUnitProcessingException {
        SingletonDeploymentConfiguration config;
        DeploymentUnit unit = context.getDeploymentUnit();
        if (unit.getParent() == null && (config = (SingletonDeploymentConfiguration)unit.getAttachment(CONFIGURATION_KEY)) != null) {
            CapabilityServiceSupport support = (CapabilityServiceSupport)unit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
            final ServiceDependency targetFactory = ServiceDependency.on((ServiceName)support.getCapabilityServiceName(ServiceTargetFactory.SERVICE_DESCRIPTOR, config.getPolicy()));
            context.requires(targetFactory);
            unit.putAttachment(SingletonDeploymentProcessor.POLICY_KEY, (Object)new ServiceTargetFactory(){

                public ServiceTarget createSingletonServiceTarget(ServiceTarget target) {
                    return ((ServiceTargetFactory)targetFactory.get()).createSingletonServiceTarget(target);
                }

                public String toString() {
                    return ((ServiceTargetFactory)targetFactory.get()).toString();
                }
            });
        }
    }

    public void undeploy(DeploymentUnit unit) {
        unit.removeAttachment(SingletonDeploymentProcessor.POLICY_KEY);
    }
}

