/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.lra.participant;

import java.util.Arrays;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.microprofile.lra.participant.MicroProfileLRAParticipantSubsystemDefinition;
import org.wildfly.extension.microprofile.lra.participant._private.MicroProfileLRAParticipantLogger;
import org.wildfly.extension.microprofile.lra.participant.deployment.LRAParticipantDeploymentDependencyProcessor;
import org.wildfly.extension.microprofile.lra.participant.deployment.LRAParticipantDeploymentSetupProcessor;
import org.wildfly.extension.microprofile.lra.participant.deployment.LRAParticipantJaxrsDeploymentUnitProcessor;
import org.wildfly.extension.microprofile.lra.participant.service.LRAParticipantService;
import org.wildfly.extension.undertow.Capabilities;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.UndertowService;

class MicroProfileLRAParticipantAdd
extends AbstractBoottimeAddStepHandler {
    MicroProfileLRAParticipantAdd() {
        super(Arrays.asList(MicroProfileLRAParticipantSubsystemDefinition.ATTRIBUTES));
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        super.performBoottime(context, operation, model);
        String url = MicroProfileLRAParticipantSubsystemDefinition.LRA_COORDINATOR_URL.resolveModelAttribute(context, model).asString();
        System.setProperty("lra.coordinator.url", url);
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            public void execute(DeploymentProcessorTarget processorTarget) {
                int STRUCTURE_MICROPROFILE_LRA_PARTICIPANT = 9216;
                int DEPENDENCIES_MICROPROFILE_LRA_PARTICIPANT = 6352;
                processorTarget.addDeploymentProcessor("microprofile-lra-participant", Phase.STRUCTURE, 9216, (DeploymentUnitProcessor)new LRAParticipantDeploymentSetupProcessor());
                processorTarget.addDeploymentProcessor("microprofile-lra-participant", Phase.DEPENDENCIES, 6352, (DeploymentUnitProcessor)new LRAParticipantDeploymentDependencyProcessor());
                processorTarget.addDeploymentProcessor("microprofile-lra-participant", Phase.POST_MODULE, 6656, (DeploymentUnitProcessor)new LRAParticipantJaxrsDeploymentUnitProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
        this.registerParticipantProxyService(context, model);
        MicroProfileLRAParticipantLogger.LOGGER.activatingSubsystem(url);
    }

    private void registerParticipantProxyService(OperationContext context, ModelNode model) throws OperationFailedException {
        CapabilityServiceBuilder builder = context.getCapabilityServiceTarget().addCapability(MicroProfileLRAParticipantSubsystemDefinition.LRA_PARTICIPANT_CAPABILITY);
        builder.requiresCapability("org.wildfly.undertow", UndertowService.class, new String[0]);
        String serverModelValue = MicroProfileLRAParticipantSubsystemDefinition.PROXY_SERVER.resolveModelAttribute(context, model).asString();
        String hostModelValue = MicroProfileLRAParticipantSubsystemDefinition.PROXY_HOST.resolveModelAttribute(context, model).asString();
        Supplier hostSupplier = builder.requiresCapability(Capabilities.CAPABILITY_HOST, Host.class, new String[]{serverModelValue, hostModelValue});
        LRAParticipantService lraParticipantProxyService = new LRAParticipantService(hostSupplier);
        builder.setInstance((Service)lraParticipantProxyService);
        builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
    }
}

