/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.routing;

import java.util.function.UnaryOperator;
import org.jboss.as.web.session.RoutingSupport;
import org.jboss.as.web.session.SessionIdentifierCodec;
import org.jboss.as.web.session.SimpleRoutingSupport;

public class DistributableSessionIdentifierCodec
implements SessionIdentifierCodec {
    private final UnaryOperator<String> locator;
    private final RoutingSupport routing;

    public DistributableSessionIdentifierCodec(UnaryOperator<String> locator) {
        this(locator, (RoutingSupport)new SimpleRoutingSupport());
    }

    public DistributableSessionIdentifierCodec(UnaryOperator<String> locator, RoutingSupport routing) {
        this.locator = locator;
        this.routing = routing;
    }

    public CharSequence encode(CharSequence sessionId) {
        String route = (String)this.locator.apply(sessionId.toString());
        return route != null ? this.routing.format(sessionId, (CharSequence)route) : sessionId;
    }

    public CharSequence decode(CharSequence encodedSessionId) {
        return (CharSequence)this.routing.parse(encodedSessionId).getKey();
    }
}

