/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.global.ListOperations;
import org.jboss.as.controller.operations.global.MapOperations;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class Util {
    private Util() {
    }

    public static String getNameFromAddress(ModelNode address) {
        PathElement pe = PathAddress.pathAddress(address).getLastElement();
        return pe == null ? null : pe.getValue();
    }

    public static String getNameFromAddress(PathAddress address) {
        PathElement pe = PathAddress.pathAddress(address, new PathElement[0]).getLastElement();
        return pe == null ? null : pe.getValue();
    }

    public static ModelNode createAddOperation(PathAddress address) {
        return Util.createAddOperation(address, Map.of());
    }

    public static ModelNode createAddOperation(PathAddress address, Map<String, ModelNode> parameters) {
        ModelNode operation = Util.createEmptyOperation("add", address);
        for (Map.Entry<String, ModelNode> entry : parameters.entrySet()) {
            operation.get(entry.getKey()).set(entry.getValue());
        }
        return operation;
    }

    public static ModelNode createAddOperation(PathAddress address, int index) {
        return Util.createAddOperation(address, index, Map.of());
    }

    public static ModelNode createAddOperation(PathAddress address, int index, Map<String, ModelNode> parameters) {
        ModelNode operation = Util.createAddOperation(address, parameters);
        operation.get("add-index").set(new ModelNode(index));
        return operation;
    }

    public static ModelNode createAddOperation() {
        return Util.createEmptyOperation("add", null);
    }

    public static ModelNode createRemoveOperation(PathAddress address) {
        return Util.createEmptyOperation("remove", address);
    }

    public static ModelNode createCompositeOperation(List<ModelNode> operations) {
        ModelNode operation = Util.createEmptyOperation("composite", PathAddress.EMPTY_ADDRESS);
        ModelNode steps = operation.get("steps");
        for (ModelNode step : operations) {
            steps.add(step);
        }
        return operation;
    }

    public static ModelNode createOperation(String operationName, PathAddress address) {
        return Util.createEmptyOperation(operationName, address);
    }

    public static ModelNode createOperation(OperationDefinition operationDefinition, PathAddress address) {
        return Util.getEmptyOperation(operationDefinition.getName(), address.toModelNode());
    }

    public static ModelNode createEmptyOperation(String operationName, PathAddress address) {
        ModelNode op = new ModelNode();
        op.get("operation").set(operationName);
        if (address != null) {
            op.get("address").set(address.toModelNode());
        } else {
            op.get("address");
        }
        return op;
    }

    public static ModelNode getEmptyOperation(String operationName, ModelNode address) {
        return Util.createEmptyOperation(operationName, address == null ? null : PathAddress.pathAddress(address));
    }

    public static ModelNode getResourceRemoveOperation(PathAddress address) {
        return Util.createEmptyOperation("remove", address);
    }

    private static ModelNode createAttributeOperation(String operationName, PathAddress address, String attributeName) {
        ModelNode operation = Util.createEmptyOperation(operationName, address);
        operation.get("name").set(attributeName);
        return operation;
    }

    public static ModelNode getWriteAttributeOperation(ModelNode address, String attributeName, String value) {
        return Util.getWriteAttributeOperation(address, attributeName, new ModelNode().set(value));
    }

    public static ModelNode getWriteAttributeOperation(PathAddress address, String attributeName, int value) {
        return Util.getWriteAttributeOperation(address, attributeName, new ModelNode().set(value));
    }

    public static ModelNode getWriteAttributeOperation(PathAddress address, String attributeName, boolean value) {
        return Util.getWriteAttributeOperation(address, attributeName, new ModelNode().set(value));
    }

    public static ModelNode getWriteAttributeOperation(ModelNode address, String attributeName, ModelNode value) {
        return Util.getWriteAttributeOperation(PathAddress.pathAddress(address), attributeName, value);
    }

    public static ModelNode getWriteAttributeOperation(PathAddress address, String attributeName, String value) {
        return Util.getWriteAttributeOperation(address, attributeName, new ModelNode().set(value));
    }

    public static ModelNode getWriteAttributeOperation(PathAddress address, String attributeName, ModelNode value) {
        ModelNode op = Util.createAttributeOperation("write-attribute", address, attributeName);
        op.get("value").set(value);
        return op;
    }

    public static ModelNode getReadAttributeOperation(PathAddress address, String attributeName) {
        return Util.createAttributeOperation("read-attribute", address, attributeName);
    }

    public static ModelNode getReadResourceDescriptionOperation(PathAddress address) {
        ModelNode op = Util.createEmptyOperation("read-resource-description", address);
        return op;
    }

    public static ModelNode getReadResourceOperation(PathAddress address) {
        ModelNode op = Util.createEmptyOperation("read-resource", address);
        return op;
    }

    public static ModelNode getUndefineAttributeOperation(PathAddress address, String attributeName) {
        return Util.createAttributeOperation("undefine-attribute", address, attributeName);
    }

    public static ModelNode createListAddOperation(PathAddress address, String attributeName, String value) {
        return Util.createListElementOperation(ListOperations.LIST_ADD_DEFINITION, address, attributeName, value);
    }

    public static ModelNode createListRemoveOperation(PathAddress address, String attributeName, String value) {
        return Util.createListElementOperation(ListOperations.LIST_REMOVE_DEFINITION, address, attributeName, value);
    }

    public static ModelNode createListRemoveOperation(PathAddress address, String attributeName, int index) {
        return Util.createListElementOperation(ListOperations.LIST_REMOVE_DEFINITION, address, attributeName, index);
    }

    public static ModelNode createListGetOperation(PathAddress address, String attributeName, int index) {
        return Util.createListElementOperation(ListOperations.LIST_GET_DEFINITION, address, attributeName, index);
    }

    public static ModelNode createListClearOperation(PathAddress address, String attributeName) {
        return Util.createAttributeOperation(ListOperations.LIST_CLEAR_DEFINITION.getName(), address, attributeName);
    }

    private static ModelNode createListElementOperation(OperationDefinition definition, PathAddress address, String attributeName, String value) {
        ModelNode operation = Util.createAttributeOperation(definition.getName(), address, attributeName);
        operation.get("value").set(value);
        return operation;
    }

    private static ModelNode createListElementOperation(OperationDefinition definition, PathAddress address, String attributeName, int index) {
        ModelNode operation = Util.createAttributeOperation(definition.getName(), address, attributeName);
        operation.get(ListOperations.INDEX.getName()).set(new ModelNode(index));
        return operation;
    }

    public static ModelNode createMapGetOperation(PathAddress address, String attributeName, String key) {
        return Util.createMapEntryOperation(MapOperations.MAP_GET_DEFINITION, address, attributeName, key);
    }

    public static ModelNode createMapPutOperation(PathAddress address, String attributeName, String key, String value) {
        ModelNode operation = Util.createMapEntryOperation(MapOperations.MAP_PUT_DEFINITION, address, attributeName, key);
        operation.get("value").set(value);
        return operation;
    }

    public static ModelNode createMapRemoveOperation(PathAddress address, String attributeName, String key) {
        return Util.createMapEntryOperation(MapOperations.MAP_REMOVE_DEFINITION, address, attributeName, key);
    }

    public static ModelNode createMapClearOperation(PathAddress address, String attributeName) {
        return Util.createAttributeOperation(MapOperations.MAP_CLEAR_DEFINITION.getName(), address, attributeName);
    }

    private static ModelNode createMapEntryOperation(OperationDefinition definition, PathAddress address, String attributeName, String key) {
        ModelNode operation = Util.createAttributeOperation(definition.getName(), address, attributeName);
        operation.get(MapOperations.KEY.getName()).set(key);
        return operation;
    }

    public static boolean isExpression(String value) {
        return value != null && value.startsWith("${") && value.endsWith("}");
    }

    public static ModelNode getOperation(String operationName, PathAddress address, ModelNode params) {
        ModelNode op = Util.createEmptyOperation(operationName, address);
        Set keys = params.keys();
        keys.remove("operation");
        keys.remove("address");
        for (String key : keys) {
            op.get(key).set(params.get(key));
        }
        return op;
    }

    public static ModelNode getOperation(String operationName, ModelNode address, ModelNode params) {
        return Util.getOperation(operationName, PathAddress.pathAddress(address), params);
    }

    public static PathAddress getParentAddressByKey(PathAddress address, String parentKey) {
        for (int i = address.size() - 1; i >= 0; --i) {
            PathElement pe = address.getElement(i);
            if (!parentKey.equals(pe.getKey())) continue;
            return address.subAddress(0, i + 1);
        }
        return null;
    }

    public static ModelNode validateOperation(ModelNode operation) {
        ModelNode responseNode = new ModelNode();
        StringBuilder errors = new StringBuilder();
        if (!operation.hasDefined("operation") || operation.get("operation").asString() == null || operation.get("operation").asString().isEmpty()) {
            errors.append(ControllerLogger.ROOT_LOGGER.noOperationDefined(operation));
        }
        if (operation.hasDefined("address")) {
            try {
                if (operation.get("address").getType() == ModelType.STRING) {
                    ModelNode address = PathAddress.parseCLIStyleAddress(operation.get("address").asString()).toModelNode();
                    operation.get("address").set(address);
                } else {
                    operation.get("address").asList();
                }
            }
            catch (IllegalArgumentException ex) {
                if (errors.length() > 0) {
                    errors.append(System.lineSeparator());
                }
                if (ex.getMessage() != null) {
                    errors.append(ex.getMessage());
                }
                errors.append(ControllerLogger.ROOT_LOGGER.attributeIsWrongType("address", ModelType.LIST, operation.get("address").getType()).getMessage());
            }
        }
        if (errors.length() > 0) {
            responseNode.get("outcome").set("failed");
            responseNode.get("failure-description").set(errors.toString());
        }
        return responseNode;
    }
}

