/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.responses;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.marshall.core.Ids;
import org.infinispan.remoting.responses.ValidResponse;

public class SuccessfulResponse<T>
extends ValidResponse {
    public static final SuccessfulResponse SUCCESSFUL_EMPTY_RESPONSE = new SuccessfulResponse<Object>(null);
    private final T responseValue;

    protected SuccessfulResponse(T responseValue) {
        this.responseValue = responseValue;
    }

    public static <T> SuccessfulResponse<T> create(T responseValue) {
        return responseValue == null ? SUCCESSFUL_EMPTY_RESPONSE : new SuccessfulResponse<T>(responseValue);
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }

    public T getResponseValue() {
        return this.responseValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SuccessfulResponse that = (SuccessfulResponse)o;
        return !(this.responseValue != null ? !this.responseValue.equals(that.responseValue) : that.responseValue != null);
    }

    public int hashCode() {
        return this.responseValue != null ? this.responseValue.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "SuccessfulResponse(" + Util.toStr(this.responseValue) + ")";
    }

    public static class Externalizer
    extends AbstractExternalizer<SuccessfulResponse> {
        public void writeObject(ObjectOutput output, SuccessfulResponse response) throws IOException {
            output.writeObject(response.responseValue);
        }

        public SuccessfulResponse readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return SuccessfulResponse.create(input.readObject());
        }

        public Integer getId() {
            return Ids.SUCCESSFUL_RESPONSE;
        }

        public Set<Class<? extends SuccessfulResponse>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{SuccessfulResponse.class});
        }
    }
}

