/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.predicateindex.be;

import java.util.List;
import org.infinispan.objectfilter.impl.predicateindex.FilterEvalContext;
import org.infinispan.objectfilter.impl.predicateindex.IntervalPredicate;
import org.infinispan.objectfilter.impl.predicateindex.Predicate;
import org.infinispan.objectfilter.impl.predicateindex.be.BENode;

public final class PredicateNode<AttributeId extends Comparable<AttributeId>>
extends BENode {
    private final Predicate<?> predicate;
    private final boolean isNegated;
    private final List<AttributeId> attributePath;

    public PredicateNode(BENode parent, Predicate<?> predicate, boolean isNegated, List<AttributeId> attributePath) {
        super(parent);
        if (isNegated && predicate instanceof IntervalPredicate) {
            throw new IllegalArgumentException("Interval predicates should not be negated");
        }
        this.predicate = predicate;
        this.isNegated = isNegated;
        this.attributePath = attributePath;
    }

    public Predicate<?> getPredicate() {
        return this.predicate;
    }

    public boolean isNegated() {
        return this.isNegated;
    }

    public List<AttributeId> getAttributePath() {
        return this.attributePath;
    }

    @Override
    public void handleChildValue(BENode child, boolean childValue, FilterEvalContext evalContext) {
        int value;
        if (child != null) {
            throw new IllegalArgumentException("Predicates have value but do not have children");
        }
        int n = value = childValue ? 0 : -1;
        if (this.isEvaluationComplete(evalContext)) {
            if (this.predicate.isRepeated() && evalContext.treeCounters[this.startIndex] == value) {
                return;
            }
            throw new IllegalStateException("This should never be called again if the state of this node was previously decided.");
        }
        if (this.parent == null) {
            evalContext.treeCounters[this.startIndex] = value;
            this.suspendSubscription(evalContext);
        } else {
            this.parent.handleChildValue(this, childValue, evalContext);
        }
    }

    @Override
    public void suspendSubscription(FilterEvalContext ctx) {
        if (this.predicate.isRepeated()) {
            ctx.matcherContext.addSuspendedSubscription(this.predicate);
        }
    }

    public String toString() {
        return "PredicateNode{attributePath=" + String.valueOf(this.attributePath) + ", isNegated=" + this.isNegated + ", predicate=" + String.valueOf(this.predicate) + "}";
    }
}

