/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.common.spi;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import java.lang.invoke.MethodHandles;
import java.util.function.Supplier;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.search.mapper.orm.common.impl.HibernateOrmUtils;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public final class TransactionHelper {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final TransactionManager transactionManager;
    private final boolean useJta;
    private final Integer transactionTimeout;

    public TransactionHelper(SessionFactoryImplementor sessionFactory, Integer transactionTimeout) {
        ServiceRegistryImplementor serviceRegistry = sessionFactory.getServiceRegistry();
        this.transactionManager = HibernateOrmUtils.getServiceOrFail((ServiceRegistry)serviceRegistry, JtaPlatform.class).retrieveTransactionManager();
        TransactionCoordinatorBuilder transactionCoordinatorBuilder = HibernateOrmUtils.getServiceOrFail((ServiceRegistry)serviceRegistry, TransactionCoordinatorBuilder.class);
        this.useJta = TransactionHelper.shouldUseJta(this.transactionManager, transactionCoordinatorBuilder);
        this.transactionTimeout = transactionTimeout;
    }

    public void inTransaction(SharedSessionContractImplementor session, Runnable action) {
        this.begin(session);
        try {
            action.run();
        }
        catch (Exception e) {
            this.rollbackSafely(session, e);
            throw e;
        }
        this.commit(session);
    }

    public <T> T inTransaction(SharedSessionContractImplementor session, Supplier<T> action) {
        T result;
        this.begin(session);
        try {
            result = action.get();
        }
        catch (Exception e) {
            this.rollbackSafely(session, e);
            throw e;
        }
        this.commit(session);
        return result;
    }

    public void begin(SharedSessionContractImplementor session) {
        try {
            if (this.useJta) {
                if (this.transactionTimeout != null) {
                    this.transactionManager.setTransactionTimeout(this.transactionTimeout.intValue());
                }
                this.transactionManager.begin();
            } else {
                session.accessTransaction().begin();
            }
        }
        catch (NotSupportedException | SystemException e) {
            throw log.transactionHandlingException(e.getMessage(), e);
        }
    }

    public void commit(SharedSessionContractImplementor session) {
        try {
            if (this.useJta) {
                this.transactionManager.commit();
            } else {
                session.accessTransaction().commit();
            }
        }
        catch (HeuristicMixedException | HeuristicRollbackException | RollbackException | SystemException e) {
            throw log.transactionHandlingException(e.getMessage(), e);
        }
    }

    public void rollbackSafely(SharedSessionContractImplementor session, Throwable t) {
        try {
            this.rollback(session);
        }
        catch (RuntimeException e) {
            t.addSuppressed(e);
        }
    }

    private void rollback(SharedSessionContractImplementor session) {
        try {
            if (this.useJta) {
                this.transactionManager.rollback();
            } else {
                session.accessTransaction().rollback();
            }
        }
        catch (Exception e) {
            throw log.transactionHandlingException(e.getMessage(), e);
        }
    }

    private static boolean shouldUseJta(TransactionManager transactionManager, TransactionCoordinatorBuilder transactionCoordinatorBuilder) {
        if (!transactionCoordinatorBuilder.isJta()) {
            log.trace("TransactionFactory does not require a TransactionManager: don't wrap in a JTA transaction");
            return false;
        }
        if (transactionManager == null) {
            log.trace("No TransactionManager found, do not start a surrounding JTA transaction");
            return false;
        }
        try {
            if (transactionManager.getStatus() == 6) {
                log.trace("No Transaction in progress, needs to start a JTA transaction");
                return true;
            }
        }
        catch (SystemException e) {
            log.cannotGuessTransactionStatus((Exception)((Object)e));
            return false;
        }
        log.trace("Transaction in progress, no need to start a JTA transaction");
        return false;
    }
}

