/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.EnumSet;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.GenericProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsExtension;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jgroups.stack.Protocol;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.common.function.Functions;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;

public class ProtocolResourceDefinition<P extends Protocol>
extends AbstractProtocolResourceDefinition<P, ProtocolConfiguration<P>> {
    static final PathElement WILDCARD_PATH = ProtocolResourceDefinition.pathElement("*");
    static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of((BinaryServiceDescriptor)ProtocolConfiguration.SERVICE_DESCRIPTOR).setAllowMultipleRegistrations(true).build();
    static final UnaryOperator<OperationStepHandler> LEGACY_OPERATION_TRANSFORMER = new UnaryOperator<OperationStepHandler>(){

        @Override
        public OperationStepHandler apply(final OperationStepHandler handler) {
            return new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    PathElement legacyPath;
                    PathAddress address = context.getCurrentAddress();
                    PathAddress parentAddress = address.getParent();
                    Resource parent = context.readResourceFromRoot(parentAddress, false);
                    if (parent.hasChild(legacyPath = GenericProtocolResourceDefinition.pathElement(address.getLastElement().getValue()))) {
                        PathAddress legacyAddress = parentAddress.append(new PathElement[]{legacyPath});
                        operation.get("address").set(legacyAddress.toModelNode());
                        String operationName = operation.get("operation").asString();
                        context.addStep(operation, context.getRootResourceRegistration().getOperationHandler(legacyAddress, operationName), OperationContext.Stage.MODEL);
                    } else {
                        handler.execute(context, operation);
                    }
                }
            };
        }
    };

    public static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"protocol", (String)name);
    }

    ProtocolResourceDefinition(PathElement path, UnaryOperator<ResourceDescriptor> configurator, ResourceServiceConfigurator parentServiceConfigurator) {
        super(new SimpleResourceDefinition.Parameters(path, (ResourceDescriptionResolver)(path.isWildcard() ? JGroupsExtension.SUBSYSTEM_RESOLVER.createChildResolver(path) : JGroupsExtension.SUBSYSTEM_RESOLVER.createChildResolver(path, WILDCARD_PATH))).setOrderedChild(), CAPABILITY, configurator, parentServiceConfigurator);
    }

    public Map.Entry<Function<ProtocolConfiguration<P>, ProtocolConfiguration<P>>, Consumer<RequirementServiceBuilder<?>>> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        return Map.entry(UnaryOperator.identity(), Functions.discardingConsumer());
    }

    static class LegacyAddOperationTransformation
    implements UnaryOperator<OperationStepHandler> {
        private final Predicate<ModelNode> legacy;

        <E extends Enum<E>> LegacyAddOperationTransformation(Class<E> attributeClass) {
            this.legacy = operation -> {
                for (Attribute attribute : EnumSet.allOf(attributeClass)) {
                    if (!operation.hasDefined(attribute.getName())) continue;
                    return false;
                }
                return true;
            };
        }

        LegacyAddOperationTransformation(String ... legacyProperties) {
            this.legacy = operation -> {
                if (!operation.hasDefined(AbstractProtocolResourceDefinition.Attribute.PROPERTIES.getName())) {
                    return false;
                }
                for (String legacyProperty : legacyProperties) {
                    if (!operation.get(AbstractProtocolResourceDefinition.Attribute.PROPERTIES.getName()).hasDefined(legacyProperty)) continue;
                    return true;
                }
                return false;
            };
        }

        @Override
        public OperationStepHandler apply(OperationStepHandler handler) {
            return (context, operation) -> {
                if (this.legacy.test(operation)) {
                    PathElement path = context.getCurrentAddress().getLastElement();
                    OperationStepHandler genericHandler = context.getResourceRegistration().getParent().getOperationHandler(PathAddress.pathAddress((PathElement[])new PathElement[]{WILDCARD_PATH}), "add");
                    operation.get("address").set(context.getCurrentAddress().getParent().append(new PathElement[]{GenericProtocolResourceDefinition.pathElement(path.getValue())}).toModelNode());
                    context.addStep(operation, genericHandler, OperationContext.Stage.MODEL, true);
                } else {
                    handler.execute(context, operation);
                }
            };
        }
    }
}

