/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.common.annotation.NonBlocking;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.ConfigUtil;
import io.smallrye.faulttolerance.config.NonBlockingConfig;
import java.lang.annotation.Annotation;

public final class NonBlockingConfigImpl
implements NonBlockingConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final NonBlocking instance;
    private final boolean onMethod;

    private NonBlockingConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.nonBlocking;
        this.onMethod = method.annotationsPresentDirectly.contains(NonBlocking.class);
    }

    public static NonBlockingConfigImpl create(FaultToleranceMethod method) {
        if (method.nonBlocking == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled(NonBlocking.class, method.method)) {
            return null;
        }
        return new NonBlockingConfigImpl(method);
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return NonBlocking.class;
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public void materialize() {
    }
}

