/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.NewConfig;
import java.lang.annotation.Annotation;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Fallback;

final class ConfigUtil {
    static final String ENABLED = "enabled";
    static final String GLOBAL = "global";

    ConfigUtil() {
    }

    static String newKey(Class<? extends Annotation> annotation, String member, Class<?> declaringClass, String method) {
        return "smallrye.faulttolerance.\"" + declaringClass.getName() + "/" + method + "\"." + NewConfig.get(annotation, member);
    }

    static String oldKey(Class<? extends Annotation> annotation, String member, Class<?> declaringClass, String method) {
        return declaringClass.getName() + "/" + method + "/" + annotation.getSimpleName() + "/" + member;
    }

    static String newKey(Class<? extends Annotation> annotation, String member, Class<?> declaringClass) {
        return "smallrye.faulttolerance.\"" + declaringClass.getName() + "\"." + NewConfig.get(annotation, member);
    }

    static String oldKey(Class<? extends Annotation> annotation, String member, Class<?> declaringClass) {
        return declaringClass.getName() + "/" + annotation.getSimpleName() + "/" + member;
    }

    static String newKey(Class<? extends Annotation> annotation, String member) {
        return "smallrye.faulttolerance.global." + NewConfig.get(annotation, member);
    }

    static String oldKey(Class<? extends Annotation> annotation, String member) {
        return annotation.getSimpleName() + "/" + member;
    }

    static boolean isEnabled(Class<? extends Annotation> annotationType, MethodDescriptor method) {
        Config config = ConfigProvider.getConfig();
        Optional onMethodNew = config.getOptionalValue(ConfigUtil.newKey(annotationType, ENABLED, method.declaringClass, method.name), String.class);
        if (onMethodNew.isPresent()) {
            return Boolean.parseBoolean((String)onMethodNew.get());
        }
        Optional onMethod = config.getOptionalValue(ConfigUtil.oldKey(annotationType, ENABLED, method.declaringClass, method.name), String.class);
        if (onMethod.isPresent()) {
            return Boolean.parseBoolean((String)onMethod.get());
        }
        Optional onClassNew = config.getOptionalValue(ConfigUtil.newKey(annotationType, ENABLED, method.declaringClass), String.class);
        if (onClassNew.isPresent()) {
            return Boolean.parseBoolean((String)onClassNew.get());
        }
        Optional onClass = config.getOptionalValue(ConfigUtil.oldKey(annotationType, ENABLED, method.declaringClass), String.class);
        if (onClass.isPresent()) {
            return Boolean.parseBoolean((String)onClass.get());
        }
        Optional onGlobalNew = config.getOptionalValue(ConfigUtil.newKey(annotationType, ENABLED), String.class);
        if (onGlobalNew.isPresent()) {
            return Boolean.parseBoolean((String)onGlobalNew.get());
        }
        Optional onGlobal = config.getOptionalValue(ConfigUtil.oldKey(annotationType, ENABLED), String.class);
        if (onGlobal.isPresent()) {
            return Boolean.parseBoolean((String)onGlobal.get());
        }
        if (Fallback.class.equals(annotationType)) {
            return true;
        }
        Optional ftEnabledNew = config.getOptionalValue("smallrye.faulttolerance.enabled", Boolean.class);
        if (ftEnabledNew.isPresent()) {
            return (Boolean)ftEnabledNew.get();
        }
        Optional ftEnabled = config.getOptionalValue("MP_Fault_Tolerance_NonFallback_Enabled", Boolean.class);
        if (ftEnabled.isPresent()) {
            return (Boolean)ftEnabled.get();
        }
        return true;
    }
}

