/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.AsynchronousConfig;
import io.smallrye.faulttolerance.config.ConfigUtil;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.faulttolerance.Asynchronous;

public final class AsynchronousConfigImpl
implements AsynchronousConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final Asynchronous instance;
    private final boolean onMethod;

    private AsynchronousConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.asynchronous;
        this.onMethod = method.annotationsPresentDirectly.contains(Asynchronous.class);
    }

    public static AsynchronousConfigImpl create(FaultToleranceMethod method) {
        if (method.asynchronous == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled(Asynchronous.class, method.method)) {
            return null;
        }
        return new AsynchronousConfigImpl(method);
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return Asynchronous.class;
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public void materialize() {
    }
}

