/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.cdi;

import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.ws.rs.HttpMethod;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.WriterInterceptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;

public class Utils {
    private static final List<Class<?>> REST_INTERFACES = List.of(ContainerRequestFilter.class, ContainerResponseFilter.class, ContextResolver.class, DynamicFeature.class, ExceptionMapper.class, Feature.class, MessageBodyReader.class, MessageBodyWriter.class, ParamConverterProvider.class, ReaderInterceptor.class, WriterInterceptor.class);

    public static boolean isJaxrsAnnotatedClass(Class<?> clazz) {
        if (clazz.isAnnotationPresent(Path.class)) {
            return true;
        }
        if (clazz.isAnnotationPresent(Provider.class)) {
            return true;
        }
        for (Method method : clazz.getMethods()) {
            if (method.isAnnotationPresent(Path.class)) {
                return true;
            }
            for (Annotation annotation : method.getAnnotations()) {
                if (!annotation.annotationType().isAnnotationPresent(HttpMethod.class)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isJaxrsResource(Class<?> clazz) {
        if (Utils.isJaxrsAnnotatedClass(clazz)) {
            return true;
        }
        for (Class<?> intf : REST_INTERFACES) {
            if (!intf.isAssignableFrom(clazz)) continue;
            return true;
        }
        for (Class<?> intf : clazz.getInterfaces()) {
            if (!Utils.isJaxrsAnnotatedClass(intf)) continue;
            return true;
        }
        return false;
    }

    public static boolean isJaxrsComponent(Class<?> clazz) {
        return clazz.isAnnotationPresent(Provider.class) || Utils.isJaxrsResource(clazz) || Application.class.isAssignableFrom(clazz);
    }

    public static boolean isScopeDefined(AnnotatedType<?> annotatedType, BeanManager manager) {
        for (Annotation annotation : annotatedType.getAnnotations()) {
            if (manager.isScope(annotation.annotationType())) {
                return true;
            }
            if (!manager.isStereotype(annotation.annotationType()) || !Utils.isScopeDefined(annotation.annotationType(), manager)) continue;
            return true;
        }
        return false;
    }

    private static boolean isScopeDefined(Class<?> clazz, BeanManager manager) {
        for (Annotation annotation : clazz.getAnnotations()) {
            if (manager.isScope(annotation.annotationType())) {
                return true;
            }
            if (!manager.isStereotype(annotation.annotationType()) || !Utils.isScopeDefined(annotation.annotationType(), manager)) continue;
            return true;
        }
        return false;
    }
}

